/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog.expr.nodset;

import java.util.ArrayList;
import java.util.List;
import jlibs.core.util.LongTreeMap;
import jlibs.xml.sax.dog.expr.Evaluation;
import jlibs.xml.sax.dog.expr.nodset.NodeSetListener;
import jlibs.xml.sax.dog.expr.nodset.PathExpression;
import jlibs.xml.sax.dog.sniff.Event;

final class EvaluationInfo
extends Evaluation<PathExpression.HitExpression>
implements NodeSetListener {
    Event event;
    Evaluation eval;
    LongTreeMap result;
    public int hitCount;
    private Boolean hit;
    public NodeSetListener nodeSetListener;
    private List<Long> mayHits;

    EvaluationInfo(Event event, PathExpression.HitExpression expression, long order, NodeSetListener nodeSetListener) {
        super(expression, order);
        this.event = event;
        this.nodeSetListener = nodeSetListener;
        if (nodeSetListener != null) {
            this.mayHits = new ArrayList<Long>();
        }
    }

    public void setResult(Object result) {
        if (result instanceof LongTreeMap) {
            this.result = (LongTreeMap)result;
        } else {
            this.result = new LongTreeMap();
            this.result.put(this.order, result);
        }
    }

    public int discard() {
        if (--this.hitCount == 0) {
            this.hit = Boolean.FALSE;
            this.doDiscards();
            if (this.listener != null) {
                this.fireFinished();
            }
        }
        return this.hitCount;
    }

    public void doFinish() {
        this.hit = Boolean.TRUE;
        if (this.listener != null) {
            this.fireFinished();
        }
    }

    @Override
    public void start() {
    }

    @Override
    public Object getResult() {
        return this.hit;
    }

    @Override
    public void finished(Evaluation evaluation) {
    }

    @Override
    public void mayHit() {
        this.mayHits.add(this.event.order());
        this.nodeSetListener.mayHit();
    }

    public void doDiscards() {
        if (this.nodeSetListener != null) {
            for (long order : this.mayHits) {
                this.nodeSetListener.discard(order);
            }
        }
    }

    @Override
    public void discard(long order) {
        this.mayHits.remove(order);
        this.nodeSetListener.discard(order);
    }

    @Override
    public void finished() {
    }
}

