/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog.expr.nodset;

import java.util.ArrayList;
import java.util.List;
import jlibs.core.util.LongTreeMap;
import jlibs.xml.sax.dog.DataType;
import jlibs.xml.sax.dog.NodeItem;
import jlibs.xml.sax.dog.expr.Evaluation;
import jlibs.xml.sax.dog.expr.Expression;
import jlibs.xml.sax.dog.expr.LinkableEvaluation;
import jlibs.xml.sax.dog.expr.nodset.ExactPosition;
import jlibs.xml.sax.dog.expr.nodset.LocationExpression;
import jlibs.xml.sax.dog.expr.nodset.NodeSetListener;
import jlibs.xml.sax.dog.expr.nodset.PositionTracker;
import jlibs.xml.sax.dog.expr.nodset.PredicateEvaluation;
import jlibs.xml.sax.dog.expr.nodset.Strings;
import jlibs.xml.sax.dog.path.AxisListener;
import jlibs.xml.sax.dog.path.EventID;
import jlibs.xml.sax.dog.path.Step;
import jlibs.xml.sax.dog.sniff.Event;

public final class LocationEvaluation
extends AxisListener<LocationExpression>
implements NodeSetListener.Support {
    private final Event event;
    private final EventID eventID;
    private final int index;
    private final boolean lastStep;
    private final Step currentStep;
    private final boolean exactPosition;
    private Evaluation predicateEvaluation;
    private Boolean predicateResult = Boolean.TRUE;
    private PositionTracker positionTracker;
    private int predicateChain = -1;
    private LinkableEvaluation pendingEvaluationHead;
    private LinkableEvaluation pendingEvaluationTail;
    private List<Evaluation> stringEvaluations;
    private boolean expired = false;
    private boolean resultPrepared = false;
    private boolean finished = false;
    private LongTreeMap<Object> result = new LongTreeMap();
    private Object finalResult;
    public NodeSetListener nodeSetListener;

    protected LocationEvaluation(LocationExpression expression, int stepIndex, Event event, EventID eventID) {
        super(expression, event.order());
        this.event = event;
        this.eventID = eventID;
        this.index = stepIndex;
        boolean bl = this.lastStep = this.index == expression.locationPath.steps.length - 1;
        if (expression instanceof Strings) {
            this.stringEvaluations = new ArrayList<Evaluation>();
        }
        this.currentStep = expression.locationPath.steps[stepIndex];
        this.exactPosition = this.currentStep.predicateSet.getPredicate() instanceof ExactPosition;
        if (this.currentStep.predicateSet.hasPosition) {
            this.positionTracker = new PositionTracker(this.currentStep.predicateSet.headPositionalPredicate);
        }
    }

    private LocationEvaluation(LocationExpression expression, int stepIndex, Event event, EventID eventID, Expression predicate, Evaluation predicateEvaluation) {
        this(expression, stepIndex, event, eventID);
        this.predicateResult = null;
        if (predicateEvaluation == null) {
            this.predicateEvaluation = event.addListener(predicate, this);
        } else {
            this.predicateEvaluation = predicateEvaluation;
            predicateEvaluation.addListener(this);
        }
    }

    @Override
    public void start() {
        Object predicate;
        assert (this.predicateResult != Boolean.FALSE);
        assert (!this.finished);
        if (this.event.hasInstantListener(this.expression)) {
            this.predicateChain = this.listener instanceof LocationEvaluation ? ((LocationEvaluation)this.listener).predicateChain : 0;
            if (this.predicateEvaluation != null) {
                ++this.predicateChain;
            }
        }
        if (this.predicateEvaluation != null && ((Expression)(predicate = this.predicateEvaluation.expression)).scope() != 1) {
            this.predicateEvaluation.start();
        }
        this.eventID.addListener(this.event, this.currentStep, this);
    }

    @Override
    public void onHit(EventID eventID) {
        Boolean predicateResult;
        assert (!this.finished) : "getting events even after finish";
        LocationExpression expression = (LocationExpression)this.expression;
        if (!this.lastStep && eventID.isEmpty(expression.locationPath.steps[this.index + 1].axis)) {
            return;
        }
        Event event = this.event;
        if (this.positionTracker != null) {
            event.positionTrackerStack.addFirst(this.positionTracker);
            this.positionTracker.addEvaluation(event);
        }
        LinkableEvaluation childEval = null;
        Expression predicate = this.currentStep.predicateSet.getPredicate();
        Boolean bl = predicateResult = predicate == null ? Boolean.TRUE : event.evaluate(predicate);
        if (predicateResult == Boolean.TRUE) {
            if (this.lastStep) {
                this.consume(event);
            } else {
                childEval = new LocationEvaluation(expression, this.index + 1, event, eventID);
            }
        } else if (predicateResult == null) {
            Evaluation predicateEvaluation = event.evaluation;
            if (this.lastStep) {
                childEval = new PredicateEvaluation(expression, event.order(), expression.getResultItem(event), event, predicate, predicateEvaluation);
                if (this.nodeSetListener != null) {
                    this.nodeSetListener.mayHit();
                }
            } else {
                childEval = new LocationEvaluation(expression, this.index + 1, event, eventID, predicate, predicateEvaluation);
            }
        }
        if (childEval != null) {
            if (childEval instanceof LocationEvaluation) {
                ((LocationEvaluation)childEval).nodeSetListener = this.nodeSetListener;
            } else {
                ((PredicateEvaluation)childEval).nodeSetListener = this.nodeSetListener;
            }
            childEval.addListener(this);
            if (this.pendingEvaluationTail != null) {
                this.pendingEvaluationTail.next = childEval;
                childEval.previous = this.pendingEvaluationTail;
                this.pendingEvaluationTail = childEval;
            } else {
                this.pendingEvaluationHead = this.pendingEvaluationTail = childEval;
            }
            childEval.start();
        }
        if (this.positionTracker != null) {
            this.positionTracker.startEvaluation();
            event.positionTrackerStack.pollFirst();
        }
        if (this.exactPosition && predicateResult == Boolean.TRUE) {
            this.manuallyExpired = true;
            this.expired();
        }
    }

    @Override
    public void expired() {
        assert (!this.expired);
        this.expired = true;
        if (this.positionTracker != null) {
            this.positionTracker.expired();
        }
        if (this.pendingEvaluationHead == null) {
            this.resultPrepared();
        }
    }

    private void resultPrepared() {
        if (!this.resultPrepared) {
            this.manuallyExpired = true;
            this.resultPrepared = true;
            LinkableEvaluation pendingEval = this.pendingEvaluationHead;
            while (pendingEval != null) {
                pendingEval.removeListener(this);
                pendingEval = pendingEval.next;
            }
            this.pendingEvaluationTail = null;
            this.pendingEvaluationHead = null;
        }
        if (this.predicateResult != null && (this.index != 0 || this.stringEvaluations == null || this.stringEvaluations.size() == 0)) {
            this.finished();
        } else if (this.result.size() == 0 && this.predicateResult == null) {
            Object predicate = this.predicateEvaluation.expression;
            if (((Expression)predicate).scope() != 1) {
                this.predicateEvaluation.removeListener(this);
            } else {
                this.event.removeListener((Expression)predicate, this);
            }
            this.finished();
        }
    }

    private void finished() {
        if (!this.finished) {
            this.finished = true;
            LinkableEvaluation pendingEval = this.pendingEvaluationHead;
            while (pendingEval != null) {
                pendingEval.removeListener(this);
                pendingEval = pendingEval.next;
            }
            this.pendingEvaluationTail = null;
            this.pendingEvaluationHead = null;
            this.fireFinished();
        }
    }

    @Override
    protected void fireFinished() {
        if (this.index == 0 && this.nodeSetListener != null) {
            this.nodeSetListener.finished();
        }
        super.fireFinished();
        if (this.stringEvaluations != null) {
            for (Evaluation stringEval : this.stringEvaluations) {
                stringEval.removeListener(this);
            }
        }
    }

    @Override
    protected void dispose() {
        if (this.nodeSetListener != null) {
            for (LongTreeMap.Entry entry = this.result.firstEntry(); entry != null; entry = entry.next()) {
                this.nodeSetListener.discard(entry.getKey());
            }
        }
        this.manuallyExpired = true;
        LinkableEvaluation pendingEval = this.pendingEvaluationHead;
        while (pendingEval != null) {
            pendingEval.removeListener(this);
            pendingEval = pendingEval.next;
        }
        this.pendingEvaluationTail = null;
        this.pendingEvaluationHead = null;
        if (this.predicateResult == null) {
            this.predicateEvaluation.removeListener(this);
        }
    }

    private void consumedResult() {
        int resultSize = this.result.size();
        if (resultSize > 0 && !((LocationExpression)this.expression).many) {
            if (resultSize > 1) {
                this.result.deleteEntry(this.result.lastEntry());
            }
            if (((LocationExpression)this.expression).first) {
                if (this.pendingEvaluationHead == null || this.result.firstEntry().getKey() <= this.pendingEvaluationHead.order) {
                    this.resultPrepared();
                } else if (!this.expired) {
                    this.manuallyExpired = true;
                    this.expired = true;
                }
            } else {
                this.resultPrepared();
            }
        } else if (this.expired && this.pendingEvaluationHead == null) {
            this.resultPrepared();
        }
    }

    private void consume(Event event) {
        assert (this.lastStep);
        Object resultItem = ((LocationExpression)this.expression).getResultItem(event);
        if (resultItem instanceof Evaluation) {
            Evaluation eval = (Evaluation)resultItem;
            this.stringEvaluations.add(eval);
            eval.addListener(this);
            eval.start();
        } else if (this.predicateChain == 0) {
            event.onInstantResult(this.expression, (NodeItem)resultItem);
            resultItem = Event.DUMMY_VALUE;
        }
        assert (resultItem != null) : "ResultItem should be non-null";
        this.result.put(event.order(), resultItem);
        this.consumedResult();
        if (this.nodeSetListener != null) {
            this.nodeSetListener.mayHit();
        }
    }

    private void consumeChildEvaluation(long order, Object resultItem) {
        boolean prepareResult = false;
        if (((LocationExpression)this.expression).resultType == DataType.NUMBER && resultItem instanceof Double && ((Double)resultItem).isNaN()) {
            this.result.clear();
            prepareResult = true;
        }
        if (this.predicateChain == 0) {
            this.event.onInstantResult(this.expression, (NodeItem)resultItem);
            resultItem = Event.DUMMY_VALUE;
        }
        this.result.put(order, resultItem);
        this.consumedResult();
        if (prepareResult) {
            this.resultPrepared();
        }
    }

    private void consumeChildEvaluation(LongTreeMap<Object> childResult) {
        Object resultItem;
        boolean prepareResult = false;
        int size = childResult.size();
        if (size == 1 && ((LocationExpression)this.expression).resultType == DataType.NUMBER && (resultItem = childResult.firstEntry().value) instanceof Double && ((Double)resultItem).isNaN()) {
            this.result.clear();
            prepareResult = true;
        }
        if (size > 0) {
            if (this.predicateChain == 0) {
                this.fireInstantResult(childResult);
            }
            if (this.result.size() > 0) {
                if (this.nodeSetListener != null) {
                    for (LongTreeMap.Entry entry = childResult.firstEntry(); entry != null; entry = entry.next()) {
                        if (this.result.put(entry.getKey(), entry.value) == null) continue;
                        this.nodeSetListener.discard(entry.getKey());
                    }
                } else {
                    this.result.putAll(childResult);
                }
            } else {
                this.result = childResult;
            }
        }
        this.consumedResult();
        if (prepareResult) {
            this.resultPrepared();
        }
    }

    private void remove(LinkableEvaluation eval) {
        LinkableEvaluation prev = eval.previous;
        LinkableEvaluation next = eval.next;
        if (prev != null) {
            prev.next = next;
        } else {
            this.pendingEvaluationHead = next;
        }
        if (next != null) {
            next.previous = prev;
        } else {
            this.pendingEvaluationTail = prev;
        }
    }

    private void fireInstantResult(LongTreeMap<Object> result) {
        for (LongTreeMap.Entry entry = result.firstEntry(); entry != null; entry = entry.next()) {
            if (!(entry.value instanceof NodeItem)) continue;
            this.event.onInstantResult(this.expression, (NodeItem)entry.value);
            entry.value = Event.DUMMY_VALUE;
        }
        result.clear();
    }

    private void decreasePredicateChain() {
        --this.predicateChain;
        LinkableEvaluation pendingEval = this.pendingEvaluationHead;
        while (pendingEval != null) {
            if (pendingEval instanceof LocationEvaluation) {
                ((LocationEvaluation)pendingEval).decreasePredicateChain();
            }
            pendingEval = pendingEval.next;
        }
        if (this.predicateChain == 0) {
            this.fireInstantResult(this.result);
        }
    }

    @Override
    public final void finished(Evaluation evaluation) {
        assert (!this.finished) : "can't consume evaluation result after finish";
        if (evaluation == this.predicateEvaluation) {
            this.predicateResult = (Boolean)evaluation.getResult();
            assert (this.predicateResult != null) : "evaluation result should be non-null";
            if (this.predicateResult == Boolean.FALSE) {
                if (this.nodeSetListener != null) {
                    for (Object entry = this.result.firstEntry(); entry != null; entry = entry.next()) {
                        this.nodeSetListener.discard(entry.getKey());
                    }
                }
                this.result.clear();
                if (this.stringEvaluations != null) {
                    for (Evaluation stringEval : this.stringEvaluations) {
                        stringEval.removeListener(this);
                    }
                    this.stringEvaluations = null;
                }
                this.resultPrepared();
            } else {
                if (this.predicateChain != -1) {
                    this.decreasePredicateChain();
                }
                if (this.resultPrepared) {
                    this.finished();
                }
            }
        } else if (evaluation instanceof PredicateEvaluation) {
            PredicateEvaluation predicateEvaluation = (PredicateEvaluation)evaluation;
            this.remove(predicateEvaluation);
            if (predicateEvaluation.result != null) {
                Object resultItem = predicateEvaluation.result;
                if (resultItem instanceof Evaluation) {
                    Evaluation stringEval = (Evaluation)resultItem;
                    this.stringEvaluations.add(stringEval);
                    stringEval.addListener(this);
                }
                this.consumeChildEvaluation(predicateEvaluation.order, resultItem);
            } else {
                if (this.nodeSetListener != null) {
                    this.nodeSetListener.discard(predicateEvaluation.order);
                }
                this.consumedResult();
            }
        } else if (evaluation instanceof LocationEvaluation) {
            LocationEvaluation locEval = (LocationEvaluation)evaluation;
            this.remove(locEval);
            if (locEval.stringEvaluations != null) {
                for (Evaluation stringEval : locEval.stringEvaluations) {
                    stringEval.addListener(this);
                }
                this.stringEvaluations.addAll(locEval.stringEvaluations);
            }
            boolean wasExpired = this.expired;
            this.consumeChildEvaluation(locEval.result);
            if (!wasExpired && this.expired) {
                assert (!this.finished);
                LinkableEvaluation eval = locEval.next;
                while (eval != null) {
                    eval.removeListener(this);
                    this.remove(eval);
                    eval = eval.next;
                }
                if (this.pendingEvaluationHead == null) {
                    this.resultPrepared();
                }
            }
        } else {
            this.stringEvaluations.remove(evaluation);
            this.consumeChildEvaluation(evaluation.order, evaluation.getResult());
        }
    }

    @Override
    public Object getResult() {
        if (this.index == 0 && this.predicateChain == 0) {
            return null;
        }
        if (this.finalResult == null) {
            this.finalResult = ((LocationExpression)this.expression).getResult(this.result);
        }
        return this.finalResult;
    }

    @Override
    public void setNodeSetListener(NodeSetListener nodeSetListener) {
        this.nodeSetListener = nodeSetListener;
    }
}

