/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog.expr.nodset;

import java.util.ArrayList;
import jlibs.core.util.LongTreeMap;
import jlibs.xml.sax.dog.DataType;
import jlibs.xml.sax.dog.expr.Expression;
import jlibs.xml.sax.dog.expr.nodset.LocationEvaluation;
import jlibs.xml.sax.dog.path.LocationPath;
import jlibs.xml.sax.dog.sniff.Event;

public abstract class LocationExpression
extends Expression {
    public boolean rawResult;
    public final LocationPath locationPath;
    public final boolean many;
    public final boolean first;

    public LocationExpression(LocationPath locationPath, DataType resultType, boolean many, boolean first) {
        this(locationPath.scope, locationPath, resultType, many, first);
    }

    public LocationExpression(int scope, LocationPath locationPath, DataType resultType, boolean many, boolean first) {
        super(scope, resultType);
        this.locationPath = locationPath;
        this.many = many;
        this.first = first;
    }

    @Override
    public Object getResult(Event event) {
        if (this.locationPath.steps.length == 0) {
            return this.getResultItem(event);
        }
        return new LocationEvaluation(this, 0, event, event.getID());
    }

    protected abstract Object getResultItem(Event var1);

    protected Object getResult(LongTreeMap<Object> result) {
        if (this.rawResult) {
            return result;
        }
        switch (this.resultType) {
            case NODESET: 
            case STRINGS: 
            case NUMBERS: {
                if (this.xpath == null) {
                    return result.values();
                }
                return new ArrayList(result.values());
            }
            case NUMBER: {
                double d = 0.0;
                for (LongTreeMap.Entry entry = result.firstEntry(); entry != null; entry = entry.next()) {
                    d += ((Double)entry.value).doubleValue();
                }
                return d;
            }
            case BOOLEAN: {
                return !result.isEmpty();
            }
        }
        if (result.isEmpty()) {
            return this.resultType.defaultValue;
        }
        return result.firstEntry().value;
    }

    protected abstract String getName();

    public final String toString() {
        return String.format("%s(%s)", this.getName(), this.locationPath);
    }
}

