/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog.expr.nodset;

import java.util.ArrayList;
import jlibs.core.lang.ImpossibleException;
import jlibs.core.lang.NotImplementedException;
import jlibs.core.util.LongTreeMap;
import jlibs.xml.sax.dog.expr.Evaluation;
import jlibs.xml.sax.dog.expr.Expression;
import jlibs.xml.sax.dog.expr.nodset.Count;
import jlibs.xml.sax.dog.expr.nodset.EvaluationInfo;
import jlibs.xml.sax.dog.expr.nodset.LocationEvaluation;
import jlibs.xml.sax.dog.expr.nodset.NodeSetListener;
import jlibs.xml.sax.dog.expr.nodset.PathExpression;
import jlibs.xml.sax.dog.expr.nodset.PositionTracker;
import jlibs.xml.sax.dog.expr.nodset.PredicateEvaluation;
import jlibs.xml.sax.dog.sniff.Event;

final class PathEvaluation
extends Evaluation<PathExpression>
implements NodeSetListener,
NodeSetListener.Support {
    private Event event;
    private PositionTracker positionTracker;
    protected LongTreeMap<EvaluationInfo> evaluations = new LongTreeMap();
    private int contextsPending;
    private int pendingCount;
    private Object finalResult;
    private NodeSetListener nodeSetListener;

    public PathEvaluation(PathExpression expression, Event event) {
        super(expression, event.order());
        this.event = event;
        this.contextsPending = expression.contexts.length;
        if (expression.union.predicateSet.hasPosition) {
            this.positionTracker = new PositionTracker(expression.union.predicateSet.headPositionalPredicate);
        }
    }

    @Override
    public void start() {
        for (Expression context : ((PathExpression)this.expression).contexts) {
            Object result = this.event.evaluate(context);
            if (result == null) {
                Object eval = this.event.result(context);
                if (eval instanceof LocationEvaluation) {
                    ((LocationEvaluation)eval).nodeSetListener = this;
                    continue;
                }
                ((PathEvaluation)eval).nodeSetListener = this;
                continue;
            }
            throw new NotImplementedException();
        }
    }

    @Override
    public void mayHit() {
        long order = this.event.order();
        EvaluationInfo evalInfo = (EvaluationInfo)this.evaluations.get(order);
        if (evalInfo == null) {
            Expression predicate;
            Boolean predicateResult;
            evalInfo = new EvaluationInfo(this.event, ((PathExpression)this.expression).union.hitExpression, order, this.nodeSetListener);
            this.evaluations.put(order, (Object)evalInfo);
            if (this.positionTracker != null) {
                this.event.positionTrackerStack.addFirst(this.positionTracker);
                this.positionTracker.addEvaluation(this.event);
            }
            Boolean bl = predicateResult = (predicate = ((PathExpression)this.expression).union.predicateSet.getPredicate()) == null ? Boolean.TRUE : this.event.evaluate(predicate);
            if (predicateResult == Boolean.TRUE) {
                Object r = this.event.evaluate(((PathExpression)this.expression).relativeExpression);
                if (r == null) {
                    this.event.evaluation.addListener(this);
                    this.event.evaluation.start();
                    evalInfo.eval = this.event.evaluation;
                    ++this.pendingCount;
                    if (this.nodeSetListener != null) {
                        if (this.event.evaluation instanceof LocationEvaluation) {
                            ((LocationEvaluation)this.event.evaluation).nodeSetListener = evalInfo;
                        } else {
                            ((PathEvaluation)this.event.evaluation).nodeSetListener = evalInfo;
                        }
                    }
                } else {
                    if (this.nodeSetListener != null) {
                        this.nodeSetListener.mayHit();
                    }
                    evalInfo.setResult(r);
                }
            } else if (predicateResult == null) {
                Evaluation predicateEvaluation = this.event.evaluation;
                Object resultItem = ((PathExpression)this.expression).relativeExpression.getResult(this.event);
                if (this.nodeSetListener != null && !(this.nodeSetListener instanceof Event)) {
                    if (resultItem instanceof LocationEvaluation) {
                        ((LocationEvaluation)resultItem).nodeSetListener = evalInfo;
                    } else {
                        ((PathEvaluation)resultItem).nodeSetListener = evalInfo;
                    }
                }
                PredicateEvaluation childEval = new PredicateEvaluation(((PathExpression)this.expression).relativeExpression, this.event.order(), resultItem, this.event, predicate, predicateEvaluation);
                childEval.addListener(this);
                ((Evaluation)childEval).start();
                evalInfo.eval = childEval;
                ++this.pendingCount;
            } else {
                throw new ImpossibleException();
            }
        }
        ++evalInfo.hitCount;
        if (evalInfo.hitCount == 1 && this.positionTracker != null) {
            this.positionTracker.startEvaluation();
            this.event.positionTrackerStack.pollFirst();
        }
    }

    @Override
    public void discard(long order) {
        LongTreeMap.Entry entry = this.evaluations.getEntry(order);
        if (entry != null && ((EvaluationInfo)entry.value).discard() == 0) {
            this.evaluations.deleteEntry(entry);
            if (((EvaluationInfo)entry.value).eval != null) {
                --this.pendingCount;
                ((EvaluationInfo)entry.value).eval.removeListener(this);
            }
        }
    }

    @Override
    public void finished() {
        --this.contextsPending;
        if (this.contextsPending == 0 && ((PathExpression)this.expression).union.hitExpression != null) {
            for (EvaluationInfo evalInfo : new ArrayList(this.evaluations.values())) {
                evalInfo.doFinish();
            }
            if (this.positionTracker != null) {
                this.positionTracker.expired();
            }
        }
        this.tryToFinish();
    }

    private int pendingCount() {
        int count = 0;
        for (LongTreeMap.Entry entry = this.evaluations.firstEntry(); entry != null; entry = entry.next()) {
            if (((EvaluationInfo)entry.value).eval == null) continue;
            ++count;
        }
        return count;
    }

    private void tryToFinish() {
        if (this.finalResult == null) {
            if (this.contextsPending > 0) {
                return;
            }
            assert (this.pendingCount == this.pendingCount());
            if (this.pendingCount == 0) {
                this.finalResult = this.computeResult();
                if (this.nodeSetListener != null) {
                    this.nodeSetListener.finished();
                }
                this.fireFinished();
            }
        }
    }

    public Object computeResult() {
        if (((PathExpression)this.expression).forEach) {
            ArrayList<Object> result = new ArrayList<Object>(this.evaluations.size());
            for (LongTreeMap.Entry entry = this.evaluations.firstEntry(); entry != null; entry = entry.next()) {
                result.add(this.computeResultItem(((EvaluationInfo)entry.value).result));
            }
            return result;
        }
        LongTreeMap result = new LongTreeMap();
        for (LongTreeMap.Entry entry = this.evaluations.firstEntry(); entry != null; entry = entry.next()) {
            result.putAll(((EvaluationInfo)entry.value).result);
        }
        return this.computeResultItem(result);
    }

    private Object computeResultItem(LongTreeMap result) {
        switch (((PathExpression)this.expression).resultType) {
            case NODESET: 
            case STRINGS: 
            case NUMBERS: {
                return new ArrayList(result.values());
            }
            case NUMBER: {
                if (((PathExpression)this.expression).relativeExpression instanceof Count) {
                    return new Double(result.size());
                }
                double d = 0.0;
                for (LongTreeMap.Entry entry = result.firstEntry(); entry != null; entry = entry.next()) {
                    d += ((Double)entry.value).doubleValue();
                }
                return d;
            }
            case BOOLEAN: {
                return !result.isEmpty();
            }
        }
        if (result.isEmpty()) {
            return ((PathExpression)this.expression).resultType.defaultValue;
        }
        return result.firstEntry().value;
    }

    @Override
    public Object getResult() {
        return this.finalResult;
    }

    @Override
    public void finished(Evaluation evaluation) {
        LongTreeMap.Entry entry = this.evaluations.getEntry(evaluation.order);
        assert (((EvaluationInfo)entry.value).eval == evaluation);
        if (evaluation instanceof PredicateEvaluation) {
            PredicateEvaluation predicateEvaluation = (PredicateEvaluation)evaluation;
            if (predicateEvaluation.result != null) {
                if (predicateEvaluation.result instanceof Evaluation) {
                    ((EvaluationInfo)entry.value).eval = (Evaluation)predicateEvaluation.result;
                    ((EvaluationInfo)entry.value).eval.addListener(this);
                    return;
                }
                ((EvaluationInfo)entry.value).setResult(predicateEvaluation.result);
                ((EvaluationInfo)entry.value).eval = null;
                --this.pendingCount;
            } else {
                ((EvaluationInfo)entry.value).doDiscards();
                this.evaluations.deleteEntry(entry);
                if (((EvaluationInfo)entry.value).eval != null) {
                    --this.pendingCount;
                }
            }
        } else {
            ((EvaluationInfo)entry.value).setResult(evaluation.getResult());
            ((EvaluationInfo)entry.value).eval = null;
            --this.pendingCount;
        }
        this.tryToFinish();
    }

    @Override
    public void setNodeSetListener(NodeSetListener nodeSetListener) {
        this.nodeSetListener = nodeSetListener;
    }
}

