/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog.expr.nodset;

import jlibs.core.lang.ImpossibleException;
import jlibs.xml.sax.dog.DataType;
import jlibs.xml.sax.dog.expr.Expression;
import jlibs.xml.sax.dog.expr.Literal;
import jlibs.xml.sax.dog.expr.nodset.LocationExpression;
import jlibs.xml.sax.dog.expr.nodset.PathEvaluation;
import jlibs.xml.sax.dog.path.LocationPath;
import jlibs.xml.sax.dog.sniff.Event;

public class PathExpression
extends Expression {
    public final LocationPath union;
    public final Expression[] contexts;
    public final Expression relativeExpression;
    public final boolean forEach;

    public PathExpression(LocationPath union, Expression relativeExpression, boolean forEach) {
        super(1, relativeExpression.resultType);
        assert (relativeExpression.scope() != 1);
        this.union = union;
        this.contexts = new Expression[union.contexts.size()];
        for (int i = 0; i < this.contexts.length; ++i) {
            this.contexts[i] = union.contexts.get(i).typeCast(DataType.NODESET);
        }
        this.relativeExpression = relativeExpression;
        if (relativeExpression instanceof LocationExpression) {
            ((LocationExpression)relativeExpression).rawResult = true;
        } else {
            ((Literal)relativeExpression).rawResultRequired();
        }
        this.forEach = forEach;
        if (union.hitExpression != null) {
            union.hitExpression.pathExpression = this;
        }
    }

    @Override
    public Object getResult() {
        return null;
    }

    @Override
    public Object getResult(Event event) {
        return new PathEvaluation(this, event);
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        for (Expression context : this.contexts) {
            if (buff.length() > 0) {
                buff.append(", ");
            }
            buff.append(context);
        }
        if (this.union.predicateSet.getPredicate() != null) {
            buff.insert(0, '(');
            buff.append(')');
            buff.append('[');
            buff.append(this.union.predicateSet.getPredicate());
            buff.append(']');
        }
        return String.format("path-expression(context(%s), %s, %s)", buff, this.relativeExpression, this.forEach);
    }

    public static class HitExpression
    extends Expression {
        public PathExpression pathExpression;

        public HitExpression() {
            super(2, DataType.BOOLEAN);
        }

        @Override
        public Object getResult() {
            throw new ImpossibleException();
        }

        @Override
        public Object getResult(Event event) {
            PathEvaluation pathEvaluation = (PathEvaluation)event.result(this.pathExpression);
            return pathEvaluation.evaluations.get(event.order());
        }
    }
}

