/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog.expr.nodset;

import jlibs.core.lang.ImpossibleException;
import jlibs.xml.sax.dog.DataType;
import jlibs.xml.sax.dog.expr.Expression;
import jlibs.xml.sax.dog.expr.Literal;
import jlibs.xml.sax.dog.expr.nodset.DelegatingEvaluation;
import jlibs.xml.sax.dog.expr.nodset.LocationExpression;
import jlibs.xml.sax.dog.expr.nodset.StringEvaluation;
import jlibs.xml.sax.dog.path.LocationPath;
import jlibs.xml.sax.dog.sniff.Event;

public final class Strings
extends LocationExpression {
    public Strings(LocationPath locationPath, DataType resultType, boolean many, boolean first) {
        super(locationPath, resultType, many, first);
    }

    @Override
    public final Object getResult() {
        return this.resultType.defaultValue;
    }

    @Override
    protected final Object getResultItem(Event event) {
        switch (event.type()) {
            case 1: 
            case 9: {
                StringEvaluation stringEvaluation = event.stringEvaluation;
                if (stringEvaluation == null || stringEvaluation.order != event.order()) {
                    event.stringEvaluation = new StringEvaluation(this, event);
                    return event.stringEvaluation;
                }
                return new DelegatingEvaluation(this, event.order(), stringEvaluation);
            }
        }
        if (this.resultType == DataType.NUMBER || this.resultType == DataType.NUMBERS) {
            try {
                return Double.parseDouble(event.value());
            }
            catch (NumberFormatException ex) {
                return Double.NaN;
            }
        }
        return event.value();
    }

    @Override
    protected String getName() {
        switch (this.resultType) {
            case STRING: {
                return "string";
            }
            case STRINGS: {
                return "strings";
            }
            case NUMBER: {
                return this.many ? "sum" : "number";
            }
            case NUMBERS: {
                return "numbers";
            }
        }
        throw new ImpossibleException();
    }

    @Override
    public final Expression simplify() {
        if (this.locationPath == LocationPath.IMPOSSIBLE) {
            return new Literal(this.resultType.defaultValue, this.resultType);
        }
        return this;
    }
}

