/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog.path;

import java.util.ArrayList;
import java.util.List;
import jlibs.core.lang.ArrayUtil;
import jlibs.core.lang.ImpossibleException;
import jlibs.xml.sax.dog.DataType;
import jlibs.xml.sax.dog.expr.Expression;
import jlibs.xml.sax.dog.expr.nodset.Bool;
import jlibs.xml.sax.dog.expr.nodset.Count;
import jlibs.xml.sax.dog.expr.nodset.LocalName;
import jlibs.xml.sax.dog.expr.nodset.LocationExpression;
import jlibs.xml.sax.dog.expr.nodset.NamespaceURI;
import jlibs.xml.sax.dog.expr.nodset.NodeSet;
import jlibs.xml.sax.dog.expr.nodset.PathExpression;
import jlibs.xml.sax.dog.expr.nodset.QualifiedName;
import jlibs.xml.sax.dog.expr.nodset.Strings;
import jlibs.xml.sax.dog.path.PredicateSet;
import jlibs.xml.sax.dog.path.Predicated;
import jlibs.xml.sax.dog.path.Step;

public final class LocationPath
extends Predicated {
    public static final LocationPath LOCAL_CONTEXT = new LocationPath(2, 0);
    public static final LocationPath DOCUMENT_CONTEXT = new LocationPath(1, 0);
    public static final LocationPath IMPOSSIBLE = new LocationPath(0, 0);
    public final int scope;
    public final Step[] steps;
    public boolean pathExpression;
    public final List<LocationPath> contexts = new ArrayList<LocationPath>();
    public PathExpression.HitExpression hitExpression;

    public LocationPath(int scope, int noOfSteps) {
        this.scope = scope;
        this.steps = new Step[noOfSteps];
    }

    public void addToContext(LocationPath path) {
        if (!path.pathExpression && path.contexts.size() > 0) {
            this.contexts.addAll(path.contexts);
        } else {
            this.contexts.add(path);
        }
        if (!path.pathExpression && path.predicateSet.predicate != null) {
            assert (this.predicateSet.predicate == null);
            this.predicateSet = path.predicateSet;
            path.predicateSet = new PredicateSet();
            assert (this.hitExpression == null);
            this.hitExpression = path.hitExpression;
            path.hitExpression = null;
        }
    }

    @Override
    public void addPredicate(Expression predicate) {
        boolean hasPosition;
        if (this.hitExpression == null && !this.predicateSet.hasPosition && (hasPosition = this.predicateSet.hasPosition(predicate))) {
            this.hitExpression = new PathExpression.HitExpression();
            super.addPredicate(this.hitExpression);
        }
        super.addPredicate(predicate);
    }

    public Expression typeCast(DataType dataType) {
        LocationExpression expr = this._typeCast(dataType);
        if (this.contexts.size() > 0) {
            return new PathExpression(this, expr, false);
        }
        return expr;
    }

    private LocationExpression _typeCast(DataType dataType) {
        switch (dataType) {
            case NODESET: {
                return new NodeSet(this);
            }
            case BOOLEAN: {
                return new Bool(this);
            }
            case STRINGS: {
                return new Strings(this, DataType.STRINGS, true, false);
            }
            case STRING: {
                return new Strings(this, DataType.STRING, false, true);
            }
            case NUMBER: {
                return new Strings(this, DataType.NUMBER, false, true);
            }
            case NUMBERS: {
                return new Strings(this, DataType.NUMBERS, true, false);
            }
        }
        throw new ImpossibleException("can't type cast locationPath to " + dataType.name());
    }

    public Expression apply(String function) {
        LocationExpression expr = this._apply(function);
        if (this.contexts.size() > 0) {
            return new PathExpression(this, expr, false);
        }
        return expr;
    }

    private LocationExpression _apply(String function) {
        switch (function.length()) {
            case 3: {
                if (function.equals("sum")) {
                    return new Strings(this, DataType.NUMBER, true, false);
                }
                return null;
            }
            case 4: {
                if (function.equals("name")) {
                    return new QualifiedName(this);
                }
                return null;
            }
            case 5: {
                if (function.equals("count")) {
                    return new Count(this);
                }
                return null;
            }
            case 6: {
                if (function.equals("string")) {
                    return new Strings(this, DataType.STRING, false, true);
                }
                if (function.equals("number")) {
                    return new Strings(this, DataType.NUMBER, false, true);
                }
                return null;
            }
            case 7: {
                if (function.equals("boolean")) {
                    return new Bool(this);
                }
                if (function.equals("strings")) {
                    return new Strings(this, DataType.STRINGS, true, false);
                }
                return null;
            }
            case 10: {
                if (function.equals("local-name")) {
                    return new LocalName(this);
                }
                return null;
            }
            case 13: {
                if (function.equals("namespace-uri")) {
                    return new NamespaceURI(this);
                }
                return null;
            }
        }
        assert (!ArrayUtil.contains((Object[])new String[]{"sum", "name", "count", "string", "number", "boolean", "strings", "local-name", "namespace-uri"}, (Object)function));
        return null;
    }

    public String toString() {
        if (this.steps.length == 0) {
            return this.scope == 1 ? "/" : "";
        }
        StringBuilder buff = new StringBuilder();
        for (Step step : this.steps) {
            buff.append('/').append(step);
        }
        return buff.substring(this.scope == 1 ? 0 : 1);
    }
}

