/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import javax.xml.namespace.NamespaceContext;
import jlibs.core.io.IOUtil;
import jlibs.core.lang.ImpossibleException;
import jlibs.xml.dom.DOMNavigator;
import jlibs.xml.dom.DOMUtil;
import jlibs.xml.sax.dog.NodeType;
import jlibs.xml.sax.dog.sniff.Event;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class NodeItem
implements NodeType {
    public final int type;
    public final String location;
    public final String value;
    public final String localName;
    public final String namespaceURI;
    public final String qualifiedName;
    public final long order;
    public int refCount;
    public Object xml;
    public boolean xmlBuilt;
    public BitSet expressions;

    public NodeItem() {
        this.order = 0L;
        this.type = 9;
        this.location = "/";
        this.value = null;
        this.localName = null;
        this.namespaceURI = null;
        this.qualifiedName = null;
    }

    public NodeItem(Event event) {
        this.order = event.order();
        this.type = event.type();
        this.location = event.location();
        this.value = event.value();
        this.localName = event.localName();
        this.namespaceURI = event.namespaceURI();
        this.qualifiedName = event.qualifiedName();
    }

    public NodeItem(Node node, NamespaceContext nsContext) {
        this.order = -100L;
        this.type = node instanceof Attr && "http://www.w3.org/2000/xmlns/".equals(node.getNamespaceURI()) ? 13 : (node.getNodeType() == 13 ? 13 : (int)node.getNodeType());
        this.location = new DOMNavigator().getXPath(node, nsContext);
        this.value = node.getNodeValue();
        this.localName = node.getLocalName();
        this.namespaceURI = node.getNamespaceURI();
        this.qualifiedName = node.getNodeName();
        this.xml = node;
    }

    public NodeItem(int type, String location, String value, String localName, String namespaceURI, String qualifiedName) {
        this.order = -100L;
        this.type = type;
        this.location = location;
        this.value = value;
        this.localName = localName;
        this.namespaceURI = namespaceURI;
        this.qualifiedName = qualifiedName;
    }

    public NodeItem(Node node, String prefix, String uri, NamespaceContext nsContext) {
        this.order = -100L;
        this.type = 13;
        this.location = new DOMNavigator().getXPath(node, nsContext) + "/namespace::" + prefix;
        this.value = uri;
        this.localName = prefix;
        this.namespaceURI = "http://www.w3.org/2000/xmlns/";
        this.qualifiedName = "xmlns:" + prefix;
        this.xml = node;
    }

    public void printTo(PrintStream out) {
        if (this.xml instanceof Node) {
            out.println(this.location);
            DOMUtil.serialize((Node)((Node)this.xml), (PrintStream)out);
        } else {
            out.print(this.localName);
        }
    }

    public String toString() {
        if (this.xml instanceof Node) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.printTo(new PrintStream(bout, true));
            try {
                return bout.toString(IOUtil.UTF_8.name());
            }
            catch (UnsupportedEncodingException ex) {
                throw new ImpossibleException((Throwable)ex);
            }
        }
        return this.location;
    }
}

