/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog.path;

import jlibs.xml.sax.dog.DataType;
import jlibs.xml.sax.dog.expr.Expression;
import jlibs.xml.sax.dog.expr.func.FunctionCall;
import jlibs.xml.sax.dog.expr.func.Functions;
import jlibs.xml.sax.dog.expr.nodset.ExactPosition;
import jlibs.xml.sax.dog.expr.nodset.Positional;
import jlibs.xml.sax.dog.path.PositionalPredicate;

public class PredicateSet {
    protected Expression predicate;
    public boolean hasPosition;
    public PositionalPredicate headPositionalPredicate;
    public PositionalPredicate tailPositionalPredicate;
    public int position;
    public int last;
    private int _position;
    private int _last;
    public boolean impossible;

    protected boolean hasPosition(Expression expr) {
        if (expr instanceof Positional) {
            Positional positional = (Positional)expr;
            positional.predicate = this.predicate;
            if (positional.position) {
                ++this._position;
            } else {
                ++this._last;
            }
            return true;
        }
        if (expr instanceof FunctionCall) {
            FunctionCall functionCall = (FunctionCall)expr;
            boolean hasPosition = false;
            for (Expression member : functionCall.members) {
                if (!this.hasPosition(member)) continue;
                hasPosition = true;
            }
            return hasPosition;
        }
        return false;
    }

    public void setPredicate(Expression predicate) {
        FunctionCall and;
        assert (predicate.resultType == DataType.BOOLEAN) : "predicate must of boolean type";
        if (this.impossible) {
            return;
        }
        if (this.predicate instanceof ExactPosition && predicate instanceof ExactPosition) {
            ExactPosition exactPosition = (ExactPosition)predicate;
            if (exactPosition.pos != 1) {
                this.impossible = true;
            }
            return;
        }
        if (predicate.scope() == 0) {
            if (predicate.getResult() == Boolean.FALSE) {
                this.impossible = true;
            }
            return;
        }
        if (this.predicate != null && this.predicate.scope() == 1) {
            and = new FunctionCall(Functions.AND);
            and.addValidMember(this.predicate, 0);
            and.addValidMember(predicate, 1);
            predicate = and;
            this.predicate = null;
        }
        this._last = 0;
        this._position = 0;
        if (this.hasPosition(predicate)) {
            this.hasPosition = true;
            if (this.predicate != null) {
                PositionalPredicate positionalPredicate = new PositionalPredicate(this.predicate, this._position, this._last);
                if (this.tailPositionalPredicate != null) {
                    this.tailPositionalPredicate.next = positionalPredicate;
                    this.tailPositionalPredicate = positionalPredicate;
                } else {
                    this.headPositionalPredicate = this.tailPositionalPredicate = positionalPredicate;
                }
                this.predicate = null;
            } else {
                this.position = this._position;
                this.last = this._last;
            }
        }
        if (this.predicate == null) {
            this.predicate = predicate;
        } else {
            and = new FunctionCall(Functions.AND);
            and.addValidMember(this.predicate, 0);
            and.addValidMember(predicate, 1);
            this.predicate = and;
        }
    }

    public Expression getPredicate() {
        return this.predicate;
    }
}

