/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog.sniff;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamReader;
import jlibs.core.lang.NotImplementedException;
import jlibs.xml.DefaultNamespaceContext;
import jlibs.xml.sax.dog.DataType;
import jlibs.xml.sax.dog.NodeItem;
import jlibs.xml.sax.dog.expr.Evaluation;
import jlibs.xml.sax.dog.expr.EvaluationListener;
import jlibs.xml.sax.dog.expr.Expression;
import jlibs.xml.sax.dog.expr.InstantEvaluationListener;
import jlibs.xml.sax.dog.expr.StaticEvaluation;
import jlibs.xml.sax.dog.expr.nodset.NodeSet;
import jlibs.xml.sax.dog.expr.nodset.NodeSetListener;
import jlibs.xml.sax.dog.expr.nodset.PositionTracker;
import jlibs.xml.sax.dog.expr.nodset.StringEvaluation;
import jlibs.xml.sax.dog.path.EventID;
import jlibs.xml.sax.dog.sniff.SAXHandler;
import jlibs.xml.sax.dog.sniff.XMLBuilder;
import jlibs.xml.sax.helpers.MyNamespaceSupport;
import org.xml.sax.Attributes;

public final class Event
extends EvaluationListener
implements NodeSetListener {
    private final List<Expression> exprList;
    private final List<Expression> globalExprList;
    private final EventID.ConstraintEntry[][] listenersArray;
    private final SAXHandler handler;
    private long order;
    private int type;
    private String namespaceURI;
    private String localName;
    private String qualifiedName;
    private String value;
    private StringBuilder elementLocation = new StringBuilder();
    private Info locationInfo;
    private EventID current;
    private boolean interestedInAttributes;
    private boolean interestedInNamespaces;
    private boolean interestedInText;
    private NodeItem nodeItem;
    private XMLBuilder xmlBuilder = null;
    private final Object[] results;
    private final int[] pendingInstantResults;
    private final BitSet finished;
    private int pendingExpressions;
    public static final RuntimeException STOP_PARSING = new RuntimeException("STOP_PARSING");
    private boolean stopped;
    public static final Object DUMMY_VALUE = new Object();
    private EvaluationListener listener;
    private final List<EvaluationListener>[] listeners;
    private final int[] instantListenersCount;
    private Info tailInfo;
    private DefaultNamespaceContext nsContext;
    public final NamespaceContext givenNSContext;
    public final StringBuilder buff = new StringBuilder(500);
    public Evaluation evaluation;
    public ArrayDeque<PositionTracker> positionTrackerStack = new ArrayDeque();
    public StringEvaluation stringEvaluation;

    public Event(NamespaceContext givenNSContext, List<Expression> globalExprList, List<Expression> exprList, int noOfConstraints, boolean langInterested) {
        this.givenNSContext = givenNSContext;
        this.globalExprList = globalExprList;
        this.exprList = exprList;
        int noOfXPaths = exprList.size();
        this.results = new Object[noOfXPaths];
        this.pendingInstantResults = new int[noOfXPaths];
        this.listeners = new List[noOfXPaths];
        this.instantListenersCount = new int[noOfXPaths];
        this.finished = new BitSet(noOfXPaths);
        this.listenersArray = new EventID.ConstraintEntry[6][noOfConstraints];
        this.handler = new SAXHandler(this, langInterested);
    }

    public NamespaceContext getNamespaceContext() {
        return this.nsContext;
    }

    public SAXHandler getSAXHandler() {
        return this.handler;
    }

    public long order() {
        return this.order;
    }

    public int type() {
        return this.type;
    }

    public String namespaceURI() {
        return this.namespaceURI;
    }

    public String localName() {
        return this.localName;
    }

    public String qualifiedName() {
        return this.qualifiedName;
    }

    public String value() {
        if (this.type == 3 && this.value == null) {
            this.value = this.buff.length() > 0 ? this.buff.toString() : null;
        }
        return this.value;
    }

    public String language() {
        return this.tailInfo == null ? "" : this.tailInfo.lang;
    }

    public String location() {
        int len;
        if (this.type == 9) {
            return "/";
        }
        StringBuilder elementLocation = this.elementLocation;
        Info info = this.locationInfo.next;
        while (info != null) {
            assert (info.slash == -1);
            info.slash = elementLocation.length();
            elementLocation.append('/');
            elementLocation.append(info.elem).append('[').append(info.elemntPos).append(']');
            info = info.next;
        }
        this.locationInfo = this.tailInfo;
        switch (this.type) {
            case 1: {
                return elementLocation.toString();
            }
            case 2: {
                len = elementLocation.length();
                elementLocation.append("/@").append(this.qname(this.namespaceURI, this.localName));
                break;
            }
            case 13: {
                len = elementLocation.length();
                elementLocation.append("/namespace::").append(this.localName);
                break;
            }
            case 3: {
                len = elementLocation.length();
                elementLocation.append("/text()[").append(this.tailInfo.textCount).append(']');
                break;
            }
            case 8: {
                len = elementLocation.length();
                elementLocation.append("/comment()[").append(this.tailInfo.commentCount).append(']');
                break;
            }
            case 7: {
                len = elementLocation.length();
                elementLocation.append("/processing-instruction('").append(this.localName).append("')[").append(this.tailInfo.piMap.get((Object)this.localName).value).append(']');
                break;
            }
            default: {
                throw new NotImplementedException();
            }
        }
        String location = elementLocation.toString();
        elementLocation.setLength(len);
        return location;
    }

    public String toString() {
        return this.location();
    }

    public EventID getID() {
        if (this.current == null) {
            this.current = new EventID(this.type, this.listenersArray);
        }
        return this.current;
    }

    private void fireEvent() {
        EventID current;
        EventID id = this.current;
        this.current = null;
        EventID firstID = null;
        EventID activeID = null;
        boolean interestedInAttributes = false;
        boolean interestedInNamespaces = false;
        boolean interestedInText = false;
        do {
            if (id.onEvent(this)) continue;
            if (firstID == null) {
                firstID = id;
            } else {
                activeID.previous = id;
            }
            activeID = id;
            interestedInAttributes |= id.interestedInAttributes;
            interestedInNamespaces |= id.interestedInNamespaces;
            interestedInText |= id.interestedInText > 0;
        } while ((id = id.previous) != null);
        if (activeID != null) {
            activeID.previous = null;
        }
        if ((current = this.current) != null && current.axisEntryCount != 0) {
            current.previous = firstID;
            current.listenersAdded();
            interestedInAttributes |= current.interestedInAttributes;
            interestedInNamespaces |= current.interestedInNamespaces;
            interestedInText |= current.interestedInText > 0;
        } else {
            this.current = firstID;
        }
        this.interestedInAttributes = interestedInAttributes;
        this.interestedInNamespaces = interestedInNamespaces;
        this.interestedInText = interestedInText;
    }

    private void fireEndAttributes() {
        EventID id = this.current;
        EventID firstID = null;
        EventID activeID = null;
        boolean interestedInAttributes = false;
        do {
            if (id.onEndAttributes()) continue;
            if (firstID == null) {
                firstID = id;
            } else {
                activeID.previous = id;
            }
            activeID = id;
            interestedInAttributes |= id.interestedInAttributes;
        } while ((id = id.previous) != null);
        if (activeID != null) {
            activeID.previous = null;
        }
        this.current = firstID;
        this.interestedInAttributes = interestedInAttributes;
    }

    private void firePush() {
        EventID id = this.current;
        EventID firstID = null;
        EventID activeID = null;
        boolean interestedInAttributes = false;
        boolean interestedInNamespaces = false;
        boolean interestedInText = false;
        do {
            if (id.push()) continue;
            if (firstID == null) {
                firstID = id;
            } else {
                activeID.previous = id;
            }
            activeID = id;
            interestedInAttributes |= id.interestedInAttributes;
            interestedInNamespaces |= id.interestedInNamespaces;
            interestedInText |= id.interestedInText > 0;
        } while ((id = id.previous) != null);
        if (activeID != null) {
            activeID.previous = null;
        }
        this.current = firstID;
        this.interestedInAttributes = interestedInAttributes;
        this.interestedInNamespaces = interestedInNamespaces;
        this.interestedInText = interestedInText;
    }

    private void firePop() {
        boolean doc;
        EventID id = this.current;
        EventID firstID = null;
        EventID activeID = null;
        boolean interestedInAttributes = false;
        boolean interestedInNamespaces = false;
        boolean interestedInText = false;
        boolean bl = doc = this.tailInfo == null;
        do {
            if (id.pop(doc)) continue;
            if (firstID == null) {
                firstID = id;
            } else {
                activeID.previous = id;
            }
            activeID = id;
            interestedInAttributes |= id.interestedInAttributes;
            interestedInNamespaces |= id.interestedInNamespaces;
            interestedInText |= id.interestedInText > 0;
        } while ((id = id.previous) != null);
        if (activeID != null) {
            activeID.previous = null;
        }
        this.current = firstID;
        this.interestedInAttributes = interestedInAttributes;
        this.interestedInNamespaces = interestedInNamespaces;
        this.interestedInText = interestedInText;
    }

    public NodeItem nodeItem() {
        if (this.nodeItem == null) {
            this.nodeItem = new NodeItem(this);
        }
        return this.nodeItem;
    }

    public void setXMLBuilder(XMLBuilder xmlBuilder) {
        this.xmlBuilder = xmlBuilder;
    }

    private boolean isXMLRequired() {
        if (this.xmlBuilder == null) {
            return false;
        }
        if (this.xmlBuilder.active) {
            return true;
        }
        this.xmlBuilder.active = this.nodeItem != null;
        return this.xmlBuilder.active;
    }

    private void notifyXMLBuilder() {
        if (this.xmlBuilder == null) {
            return;
        }
        if (!this.xmlBuilder.active && this.nodeItem == null) {
            return;
        }
        Object xml = this.xmlBuilder.onEvent(this);
        if (this.nodeItem != null) {
            this.nodeItem.xml = xml;
            this.nodeItem.xmlBuilt = true;
            this.finishedXMLBuild(this.nodeItem);
        }
    }

    @Override
    public void mayHit() {
        ++this.nodeItem.refCount;
    }

    @Override
    public void discard(long order) {
        this.xmlBuilder.discard(order);
    }

    @Override
    public void finished() {
    }

    @Override
    public void finished(Evaluation evaluation) {
        assert (((Expression)evaluation.expression).scope() == 1);
        assert (!this.hasInstantListener((Expression)evaluation.expression) ? evaluation.getResult() != null : evaluation.getResult() == null);
        assert (this.pendingExpressions > 0);
        int id = ((Expression)evaluation.expression).id;
        assert (this.results[id] == null || this.results[id] == evaluation);
        boolean needEvaluation = false;
        this.finished.set(id);
        List<EvaluationListener> listeners = this.listeners[id];
        if (listeners != null) {
            boolean hasPendingInstantResults = this.pendingInstantResults[id] != 0;
            boolean clearListeners = true;
            for (EvaluationListener listener : listeners) {
                if (listener.disposed) continue;
                if (listener instanceof InstantEvaluationListener && hasPendingInstantResults) {
                    clearListeners = false;
                    continue;
                }
                listener.finished(evaluation);
            }
            if (clearListeners) {
                this.listeners[id] = null;
            } else {
                needEvaluation = true;
            }
        }
        if (!needEvaluation) {
            Object object = this.results[id] = ((Expression)evaluation.expression).storeResult ? evaluation.getResult() : null;
        }
        if (--this.pendingExpressions == 0 && this.tailInfo != null) {
            this.tailInfo = null;
            if (this.xmlBuilder == null) {
                throw STOP_PARSING;
            }
            this.stopped = true;
        }
    }

    public void onInstantResult(Expression expression, NodeItem nodeItem) {
        BitSet bitSet = nodeItem.expressions;
        if (bitSet == null) {
            nodeItem.expressions = bitSet = new BitSet();
            bitSet.set(expression.id);
        } else {
            if (bitSet.get(expression.id)) {
                return;
            }
            bitSet.set(expression.id);
        }
        if (this.xmlBuilder == null || nodeItem.xmlBuilt) {
            this.fireInstantResult(expression, nodeItem);
        } else {
            int n = expression.id;
            this.pendingInstantResults[n] = this.pendingInstantResults[n] + 1;
        }
    }

    private void fireInstantResult(Expression expression, NodeItem nodeItem) {
        if (expression.getXPath() == null) {
            return;
        }
        List<EvaluationListener> listeners = this.listeners[expression.id];
        for (EvaluationListener listener : listeners) {
            if (listener.disposed || !(listener instanceof InstantEvaluationListener)) continue;
            ((InstantEvaluationListener)listener).onNodeHit(expression, nodeItem);
        }
    }

    public void finishedXMLBuild(NodeItem nodeItem) {
        nodeItem.xmlBuilt = true;
        BitSet bitSet = nodeItem.expressions;
        if (bitSet == null) {
            return;
        }
        int i = 0;
        while ((i = bitSet.nextSetBit(i)) != -1) {
            List<EvaluationListener> listeners;
            this.fireInstantResult(this.exprList.get(i), nodeItem);
            int n = i;
            this.pendingInstantResults[n] = this.pendingInstantResults[n] - 1;
            if (this.finished.get(i) && this.pendingInstantResults[i] == 0 && (listeners = this.listeners[i]) != null) {
                this.listeners[i] = null;
                for (EvaluationListener listener : listeners) {
                    if (listener.disposed || !(listener instanceof InstantEvaluationListener)) continue;
                    listener.finished((Evaluation)this.results[i]);
                }
                this.results[i] = null;
            }
            ++i;
        }
        return;
    }

    public void setListener(EvaluationListener listener) {
        if (this.listener != null) {
            throw new IllegalStateException("EvaluationListener can be set only once");
        }
        this.listener = listener;
        for (Expression expr : this.exprList) {
            this.addListener(expr, this.listener);
        }
    }

    public EvaluationListener getListener() {
        return this.listener;
    }

    public Evaluation addListener(Expression expr, EvaluationListener evaluationListener) {
        Object value;
        assert (expr.scope() == 1);
        int id = expr.id;
        List<EvaluationListener> listeners = this.listeners[id];
        if (listeners == null) {
            this.listeners[id] = listeners = new ArrayList<EvaluationListener>();
        }
        listeners.add(evaluationListener);
        if (this.supportsInstantResults(expr) && evaluationListener instanceof InstantEvaluationListener) {
            int n = id;
            this.instantListenersCount[n] = this.instantListenersCount[n] + 1;
        }
        if ((value = this.results[id]) instanceof Evaluation) {
            return (Evaluation)value;
        }
        if (value == null) {
            return null;
        }
        throw new IllegalStateException();
    }

    public void removeListener(Expression expr, EvaluationListener evaluationListener) {
        List<EvaluationListener> listeners = this.listeners[expr.id];
        if (listeners != null) {
            if (listeners.remove(evaluationListener) && this.supportsInstantResults(expr) && evaluationListener instanceof InstantEvaluationListener) {
                int n = expr.id;
                this.instantListenersCount[n] = this.instantListenersCount[n] - 1;
            }
        } else {
            evaluationListener.disposed = true;
        }
    }

    private boolean supportsInstantResults(Expression expr) {
        return expr instanceof NodeSet;
    }

    public boolean hasInstantListener(Expression expr) {
        return this.supportsInstantResults(expr) && this.instantListenersCount[expr.id] > 0;
    }

    public Object result(Expression expr) {
        assert (expr.scope() == 1);
        return this.results[expr.id];
    }

    void setData(int type, String namespaceURI, String localName, String qualifiedName, String value) {
        this.nodeItem = null;
        this.type = type;
        this.namespaceURI = namespaceURI;
        this.localName = localName;
        this.qualifiedName = qualifiedName;
        this.value = value;
    }

    private void onEvent(int type, String namespaceURI, String localName, String qualifiedName, String value) {
        this.nodeItem = null;
        ++this.order;
        this.type = type;
        this.namespaceURI = namespaceURI;
        this.localName = localName;
        this.qualifiedName = qualifiedName;
        this.value = value;
        if (!this.stopped && type != 1) {
            this.fireEvent();
        }
    }

    public void onStartDocument() {
        int noOfXPaths;
        if (this.listener != null) {
            for (Expression expr : this.globalExprList) {
                this.listener.finished(new StaticEvaluation<Expression>(expr, -1L, expr.getResult()));
            }
        }
        if ((noOfXPaths = this.exprList.size()) == 0) {
            throw STOP_PARSING;
        }
        this.pendingExpressions = noOfXPaths;
        this.nsContext = new DefaultNamespaceContext();
        this.locationInfo = this.tailInfo = new Info();
        this.tailInfo.lang = "";
        this.tailInfo.slash = 0;
        this.order = 0L;
        this.type = 9;
        this.qualifiedName = "";
        this.localName = "";
        this.namespaceURI = "";
        this.value = "";
        Object[] results = this.results;
        for (int i = noOfXPaths - 1; i >= 0; --i) {
            StaticEvaluation<Expression> eval;
            Expression expression = this.exprList.get(i);
            Object result = expression.getResult(this);
            if (result instanceof Evaluation) {
                results[i] = result;
                eval = (StaticEvaluation<Expression>)result;
                eval.addListener(this);
                if (this.xmlBuilder != null && expression.resultType == DataType.NODESET && eval instanceof NodeSetListener.Support) {
                    ((NodeSetListener.Support)((Object)eval)).setNodeSetListener(this);
                }
                ((Evaluation)eval).start();
                continue;
            }
            if (expression.resultType == DataType.NODESET && this.hasInstantListener(expression)) {
                this.onInstantResult(expression, this.nodeItem);
                eval = new StaticEvaluation<Expression>(expression, this.order, null);
                results[i] = eval;
            } else {
                eval = new StaticEvaluation<Expression>(expression, this.order, result);
            }
            this.finished(eval);
        }
        this.current.listenersAdded();
        this.firePush();
        if (this.isXMLRequired()) {
            this.nodeItem.xml = this.xmlBuilder.doStartDocument(this.nodeItem);
        } else if (this.stopped) {
            throw STOP_PARSING;
        }
    }

    public void onEndDocument() {
        if (!this.stopped) {
            this.pop();
        }
        assert (this.pendingExpressions == 0);
        assert (this.tailInfo == null);
        if (this.xmlBuilder != null) {
            this.xmlBuilder.doEndDocument(this);
        }
    }

    public void onStartElement(String uri, String localName, String qualifiedName, String lang) {
        this.onEvent(1, uri, localName, qualifiedName, null);
        if (!this.stopped) {
            Info info = new Info();
            info.elem = this.qname(uri, localName);
            info.elemntPos = this.tailInfo.updateElementPosition(info.elem);
            info.lang = lang != null ? lang : this.language();
            this.push(info);
            this.fireEvent();
        }
        if (!this.stopped) {
            this.firePush();
        }
        if (this.isXMLRequired()) {
            Object xml = this.xmlBuilder.doStartElement(this, this.nodeItem);
            if (this.nodeItem != null) {
                this.nodeItem.xml = xml;
            }
        } else if (this.stopped) {
            throw STOP_PARSING;
        }
    }

    public void onEndElement() {
        if (!this.stopped) {
            this.pop();
        }
        if (this.xmlBuilder != null && this.xmlBuilder.active && this.xmlBuilder.doEndElement(this) == null && this.stopped) {
            throw STOP_PARSING;
        }
    }

    public void onText() {
        if (this.buff.length() > 0) {
            if (!this.stopped) {
                ++this.tailInfo.textCount;
            }
            if (this.xmlBuilder != null || this.interestedInText) {
                this.onEvent(3, "", "", "", null);
            }
            this.notifyXMLBuilder();
            this.buff.setLength(0);
        }
    }

    public void onComment(char[] ch, int start, int length) {
        if (!this.stopped) {
            ++this.tailInfo.commentCount;
        }
        this.onEvent(8, "", "", "", new String(ch, start, length));
        this.notifyXMLBuilder();
    }

    public void onPI(String target, String data) {
        if (!this.stopped) {
            this.tailInfo.updatePIPosition(target);
        }
        this.onEvent(7, "", target, target, data);
        this.notifyXMLBuilder();
    }

    public void onAttributes(Attributes attrs) {
        if (this.interestedInAttributes) {
            int len = attrs.getLength();
            for (int i = 0; i < len; ++i) {
                this.onEvent(2, attrs.getURI(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getValue(i));
                this.notifyXMLBuilder();
            }
            this.fireEndAttributes();
        } else if (this.xmlBuilder != null && this.xmlBuilder.active) {
            this.xmlBuilder.onAttributes(this, attrs);
        }
    }

    public void onAttributes(XMLStreamReader reader) {
        if (this.interestedInAttributes) {
            int len = reader.getAttributeCount();
            for (int i = 0; i < len; ++i) {
                String prefix = reader.getAttributePrefix(i);
                String localName = reader.getAttributeLocalName(i);
                String qname = prefix.length() == 0 ? localName : prefix + ':' + localName;
                String uri = reader.getAttributeNamespace(i);
                if (uri == null) {
                    uri = "";
                }
                this.onEvent(2, uri, localName, qname, reader.getAttributeValue(i));
                this.notifyXMLBuilder();
            }
            this.fireEndAttributes();
        } else if (this.xmlBuilder != null && this.xmlBuilder.active) {
            this.xmlBuilder.onAttributes(this, reader);
            this.fireEndAttributes();
        }
    }

    public void onNamespaces(MyNamespaceSupport nsSupport) {
        if (this.interestedInNamespaces) {
            Enumeration prefixes = nsSupport.getPrefixes();
            while (prefixes.hasMoreElements()) {
                String prefix = (String)prefixes.nextElement();
                String uri = nsSupport.getURI(prefix);
                this.onEvent(13, "", prefix, prefix, uri);
                this.notifyXMLBuilder();
            }
        } else if (this.xmlBuilder != null && this.xmlBuilder.active) {
            this.xmlBuilder.onNamespaces(this, nsSupport);
        }
    }

    private void push(Info info) {
        info.prev = this.tailInfo;
        this.tailInfo.next = info;
        this.tailInfo = info;
    }

    private void pop() {
        Info curTailInfo = this.tailInfo;
        if (curTailInfo.slash != -1) {
            this.elementLocation.setLength(curTailInfo.slash);
        }
        if (this.locationInfo == curTailInfo) {
            this.locationInfo = curTailInfo.prev;
        }
        this.tailInfo = curTailInfo.prev;
        if (this.tailInfo != null) {
            this.tailInfo.next = null;
        }
        this.firePop();
    }

    private String qname(String uri, String name) {
        String prefix = this.nsContext.getPrefix(uri);
        if (prefix == null) {
            prefix = this.givenNSContext.getPrefix(uri);
            if (prefix != null) {
                this.nsContext.declarePrefix(prefix, uri);
            } else {
                prefix = this.nsContext.declarePrefix(uri);
            }
        }
        if (prefix.length() == 0) {
            return name;
        }
        int prefixLen = prefix.length();
        int nameLen = name.length();
        char[] ch = new char[prefixLen + 1 + nameLen];
        prefix.getChars(0, prefixLen, ch, 0);
        ch[prefixLen] = 58;
        name.getChars(0, name.length(), ch, prefixLen + 1);
        assert (new String(ch).equals(prefix + ':' + name));
        return new String(ch);
    }

    public void appendText(char[] ch, int start, int length) {
        if (this.xmlBuilder != null || this.interestedInText) {
            this.buff.append(ch, start, length);
        } else if (this.buff.length() == 0) {
            this.buff.append('x');
        }
    }

    public Object evaluate(Expression expr) {
        this.evaluation = null;
        switch (expr.scope()) {
            case 0: {
                return expr.getResult();
            }
            case 1: {
                Object value = this.results[expr.id];
                return value instanceof Evaluation ? null : value;
            }
        }
        assert (expr.scope() == 2);
        Object result = expr.getResult(this);
        assert (result != null);
        if (result instanceof Evaluation) {
            this.evaluation = (Evaluation)result;
            return null;
        }
        return result;
    }

    static final class Info {
        Info prev;
        Info next;
        int slash = -1;
        String elem;
        String lang;
        int elemntPos = 1;
        Map<String, IntWrapper> elemMap;
        Map<String, IntWrapper> piMap;
        int textCount;
        int commentCount;

        Info() {
        }

        private static int updatePosition(Map<String, IntWrapper> map, String key) {
            IntWrapper position = map.get(key);
            if (position == null) {
                map.put(key, new IntWrapper());
                return 1;
            }
            return ++position.value;
        }

        public int updateElementPosition(String qname) {
            if (this.elemMap == null) {
                this.elemMap = new HashMap<String, IntWrapper>();
            }
            return Info.updatePosition(this.elemMap, qname);
        }

        public int updatePIPosition(String target) {
            if (this.piMap == null) {
                this.piMap = new HashMap<String, IntWrapper>();
            }
            return Info.updatePosition(this.piMap, target);
        }
    }

    static final class IntWrapper {
        int value = 1;

        IntWrapper() {
        }
    }
}

