/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog.sniff;

import jlibs.xml.sax.dog.sniff.Event;
import jlibs.xml.sax.helpers.MyNamespaceSupport;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public final class SAXHandler
extends DefaultHandler2 {
    final Event event;
    final boolean langInterested;
    private final MyNamespaceSupport nsSupport = new MyNamespaceSupport();

    public SAXHandler(Event event, boolean langInterested) {
        this.event = event;
        this.langInterested = langInterested;
    }

    @Override
    public void startDocument() throws SAXException {
        this.nsSupport.startDocument();
        this.event.onStartDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.nsSupport.startPrefixMapping(prefix, uri);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        this.nsSupport.startElement();
        Event event = this.event;
        event.onText();
        event.onStartElement(uri, localName, qName, this.langInterested ? attrs.getValue("http://www.w3.org/XML/1998/namespace", "lang") : null);
        event.onNamespaces(this.nsSupport);
        event.onAttributes(attrs);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.event.appendText(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.nsSupport.endElement();
        this.event.onText();
        this.event.onEndElement();
    }

    @Override
    public void endDocument() throws SAXException {
        this.event.onEndDocument();
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.event.onText();
        this.event.onPI(target, data);
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.event.onText();
        this.event.onComment(ch, start, length);
    }
}

