/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog.sniff;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import jlibs.xml.sax.dog.NodeItem;
import jlibs.xml.sax.dog.sniff.Event;
import jlibs.xml.sax.helpers.MyNamespaceSupport;
import org.xml.sax.Attributes;

public abstract class XMLBuilder {
    boolean active = false;
    private List<NodeItem> stack = new ArrayList<NodeItem>();

    protected abstract Object onStartDocument();

    Object doStartDocument(NodeItem nodeItem) {
        this.stack.add(nodeItem);
        return this.onStartDocument();
    }

    protected abstract Object onStartElement(Event var1);

    Object doStartElement(Event event, NodeItem nodeItem) {
        this.stack.add(nodeItem);
        return this.onStartElement(event);
    }

    protected abstract Object onEvent(Event var1);

    protected abstract Object onEndElement();

    Object doEndElement(Event event) {
        Object node;
        assert (this.active);
        NodeItem finishedNode = this.stack.remove(this.stack.size() - 1);
        if (finishedNode != null) {
            event.finishedXMLBuild(finishedNode);
        }
        if ((node = this.onEndElement()) == null) {
            this.active = false;
        }
        return node;
    }

    protected abstract void onEndDocument();

    void doEndDocument(Event event) {
        NodeItem finishedNode;
        if (!this.stack.isEmpty() && (finishedNode = this.stack.remove(this.stack.size() - 1)) != null) {
            event.finishedXMLBuild(finishedNode);
        }
        this.stack = null;
        this.onEndDocument();
    }

    public void onAttributes(Event event, Attributes attrs) {
        assert (this.active);
        int len = attrs.getLength();
        for (int i = 0; i < len; ++i) {
            event.setData(2, attrs.getURI(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getValue(i));
            this.onEvent(event);
        }
    }

    public void onAttributes(Event event, XMLStreamReader reader) {
        assert (this.active);
        int len = reader.getAttributeCount();
        for (int i = 0; i < len; ++i) {
            String prefix = reader.getAttributePrefix(i);
            String localName = reader.getAttributeLocalName(i);
            String qname = prefix.length() == 0 ? localName : prefix + ':' + localName;
            String uri = reader.getAttributeNamespace(i);
            if (uri == null) {
                uri = "";
            }
            event.setData(2, uri, localName, qname, reader.getAttributeValue(i));
            this.onEvent(event);
        }
    }

    public void onNamespaces(Event event, MyNamespaceSupport nsSupport) {
        Enumeration prefixes;
        assert (this.active);
        Enumeration enumeration = prefixes = this.hasParent() ? nsSupport.getDeclaredPrefixes() : nsSupport.getPrefixes();
        while (prefixes.hasMoreElements()) {
            String prefix = (String)prefixes.nextElement();
            String uri = nsSupport.getURI(prefix);
            event.setData(13, "", prefix, prefix, uri);
            this.onEvent(event);
        }
    }

    void discard(long order) {
        Iterator<NodeItem> iter = this.stack.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            NodeItem nodeItem = iter.next();
            if (nodeItem == null) continue;
            if (nodeItem.order == order) {
                if (--nodeItem.refCount > 0) {
                    return;
                }
                if (first) {
                    nodeItem.xml = null;
                    while (iter.hasNext()) {
                        nodeItem = iter.next();
                        if (nodeItem == null) continue;
                        if (nodeItem.xml != null) {
                            this.removeFromParent(nodeItem.xml);
                        }
                        return;
                    }
                    this.clearCurNode();
                    this.active = false;
                }
                return;
            }
            first = false;
        }
    }

    protected abstract void clearCurNode();

    protected abstract void removeFromParent(Object var1);

    protected abstract boolean hasParent();
}

