/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.xsd;

import jlibs.core.graph.Navigator;
import jlibs.core.graph.Path;
import jlibs.core.graph.Processor;
import jlibs.core.graph.Visitor;
import jlibs.core.graph.Walker;
import jlibs.core.graph.WalkerUtil;
import jlibs.core.graph.visitors.ReflectionVisitor;
import jlibs.core.graph.walkers.PreorderWalker;
import jlibs.xml.sax.XMLDocument;
import jlibs.xml.xsd.XSNavigator;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSParticle;

public class XSContentModel
extends ReflectionVisitor<Object, Processor<Object>> {
    private StringBuilder buff = new StringBuilder();
    private XMLDocument doc;
    private Processor<XSModelGroup> modelGroupProcessor = new Processor<XSModelGroup>(){

        public boolean preProcess(XSModelGroup modelGroup, Path path) {
            XSContentModel.this.appendCompositor(path);
            XSContentModel.this.buff.append('(');
            return true;
        }

        public void postProcess(XSModelGroup modelGroup, Path path) {
            XSContentModel.this.buff.append(')');
            XSContentModel.this.appendCardinality(path);
        }
    };
    private Processor<XSElementDeclaration> elemProcessor = new Processor<XSElementDeclaration>(){

        public boolean preProcess(XSElementDeclaration elem, Path path) {
            XSContentModel.this.appendCompositor(path);
            String uri = elem.getNamespace() == null ? "" : elem.getNamespace();
            XSContentModel.this.doc.declarePrefix(uri);
            XSContentModel.this.buff.append(XSContentModel.this.doc.toQName(uri, elem.getName()));
            XSContentModel.this.appendCardinality(path);
            return false;
        }

        public void postProcess(XSElementDeclaration elem, Path path) {
        }
    };

    protected Processor<Object> getDefault(Object elem) {
        return null;
    }

    protected Processor process(XSModelGroup modelGroup) {
        return this.modelGroupProcessor;
    }

    protected Processor process(XSElementDeclaration elem) {
        return this.elemProcessor;
    }

    private void appendCompositor(Path path) {
        if (this.buff.length() > 0 && this.buff.charAt(this.buff.length() - 1) != '(') {
            XSModelGroup modelGroup = (XSModelGroup)path.getParentPath(XSModelGroup.class).getElement();
            switch (modelGroup.getCompositor()) {
                case 1: {
                    this.buff.append(" , ");
                    break;
                }
                case 3: {
                    this.buff.append(" ; ");
                    break;
                }
                case 2: {
                    this.buff.append(" | ");
                }
            }
        }
    }

    private void appendCardinality(Path path) {
        if ((path = path.getParentPath(XSParticle.class)) != null) {
            XSParticle particle = (XSParticle)path.getElement();
            if (particle.getMinOccurs() == 0 && particle.getMaxOccursUnbounded()) {
                this.buff.append("*");
            } else if (particle.getMinOccurs() == 1 && particle.getMaxOccursUnbounded()) {
                this.buff.append("+");
            } else if (particle.getMaxOccursUnbounded()) {
                this.buff.append(particle.getMinOccurs()).append("+");
            } else if (particle.getMinOccurs() == 0 && particle.getMaxOccurs() == 1) {
                this.buff.append("?");
            } else if (particle.getMinOccurs() != 1 && particle.getMaxOccurs() != -1) {
                this.buff.append("[").append(particle.getMinOccurs()).append(",").append(particle.getMaxOccurs()).append("]");
            }
        }
    }

    public String toString(XSComplexTypeDefinition complexType, XMLDocument doc) {
        this.buff.setLength(0);
        this.doc = doc;
        WalkerUtil.walk((Walker)new PreorderWalker((Object)complexType, (Navigator)new XSNavigator()), (Visitor)this);
        this.doc = null;
        return this.buff.toString();
    }
}

