/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.xsd;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.DatatypeConverter;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import jlibs.core.graph.Filter;
import jlibs.core.graph.Navigator;
import jlibs.core.graph.Path;
import jlibs.core.graph.Processor;
import jlibs.core.graph.Sequence;
import jlibs.core.graph.Visitor;
import jlibs.core.graph.Walker;
import jlibs.core.graph.WalkerUtil;
import jlibs.core.graph.navigators.FilteredTreeNavigator;
import jlibs.core.graph.sequences.DuplicateSequence;
import jlibs.core.graph.sequences.EmptySequence;
import jlibs.core.graph.sequences.IterableSequence;
import jlibs.core.graph.sequences.RepeatSequence;
import jlibs.core.graph.visitors.ReflectionVisitor;
import jlibs.core.graph.walkers.PreorderWalker;
import jlibs.core.io.IOUtil;
import jlibs.core.lang.ImpossibleException;
import jlibs.core.lang.OS;
import jlibs.core.util.CollectionUtil;
import jlibs.core.util.RandomUtil;
import jlibs.xml.sax.XMLDocument;
import jlibs.xml.xsd.XSContentModel;
import jlibs.xml.xsd.XSNavigator;
import jlibs.xml.xsd.XSParser;
import jlibs.xml.xsd.XSUtil;
import jlibs.xml.xsd.display.XSDisplayFilter;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSFacet;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;
import org.xml.sax.SAXException;

public class XSInstance {
    public int minimumElementsGenerated = 2;
    public int maximumElementsGenerated = 2;
    public int minimumListItemsGenerated = 2;
    public int maximumListItemsGenerated = 2;
    public int maximumRecursionDepth = 1;
    public Boolean generateOptionalElements = Boolean.TRUE;
    public Boolean generateOptionalAttributes = Boolean.TRUE;
    public Boolean generateFixedAttributes = Boolean.TRUE;
    public Boolean generateDefaultAttributes = Boolean.TRUE;
    public boolean generateAllChoices = false;
    public boolean showContentModel = true;
    public SampleValueGenerator sampleValueGenerator;

    private int generateRepeatCount(int minOccurs, int maxOccurs) {
        int max;
        int min;
        if (minOccurs == 0 && maxOccurs == 1) {
            return RandomUtil.randomBoolean((Boolean)this.generateOptionalElements) ? 1 : 0;
        }
        if (maxOccurs == -1) {
            maxOccurs = Math.max(minOccurs, this.maximumElementsGenerated);
        }
        if (this.minimumElementsGenerated > maxOccurs || this.maximumElementsGenerated < minOccurs) {
            min = minOccurs;
            max = maxOccurs;
        } else {
            min = Math.max(minOccurs, this.minimumElementsGenerated);
            max = Math.min(maxOccurs, this.maximumElementsGenerated);
        }
        return min == max ? min : RandomUtil.random((int)min, (int)max);
    }

    public void generate(XSModel xsModel, QName rootElement, XMLDocument doc) {
        this.generate(xsModel, rootElement, doc, null, null);
    }

    public void generate(XSModel xsModel, QName rootElement, XMLDocument doc, String xsiSchemaLocation, String xsiNoNamespaceSchemaLocation) {
        String namespace = rootElement.getNamespaceURI();
        XSElementDeclaration root = xsModel.getElementDeclaration(rootElement.getLocalPart(), namespace);
        if (root == null) {
            throw new IllegalArgumentException("Element " + rootElement + " is not found");
        }
        FilteredTreeNavigator navigator = new FilteredTreeNavigator((Navigator)new XSSampleNavigator(xsModel), (Filter)new XSDisplayFilter(){

            protected boolean process(XSElementDeclaration elem) {
                return !elem.getAbstract();
            }

            @Override
            protected boolean process(XSTypeDefinition type) {
                return type.getTypeCategory() == 15;
            }
        });
        try {
            doc.startDocument();
            doc.declarePrefix("http://www.w3.org/2001/XMLSchema-instance");
            if (!(rootElement.getPrefix() == null || rootElement.getNamespaceURI().isEmpty() || this.showContentModel && rootElement.getPrefix().isEmpty())) {
                doc.declarePrefix(rootElement.getPrefix(), rootElement.getNamespaceURI());
            }
            WalkerUtil.walk((Walker)new PreorderWalker((Object)root, (Navigator)navigator), (Visitor)new XSSampleVisitor(doc, xsiSchemaLocation, xsiNoNamespaceSchemaLocation));
            doc.endDocument();
        }
        catch (SAXException ex) {
            throw new ImpossibleException((Throwable)ex);
        }
    }

    public void loadOptions(Properties options) {
        String value = options.getProperty("minimumElementsGenerated");
        if (value != null) {
            this.minimumElementsGenerated = Integer.parseInt(value);
        }
        if ((value = options.getProperty("maximumElementsGenerated")) != null) {
            this.maximumElementsGenerated = Integer.parseInt(value);
        }
        if ((value = options.getProperty("minimumElementsGenerated")) != null) {
            this.minimumListItemsGenerated = Integer.parseInt(value);
        }
        if ((value = options.getProperty("maximumListItemsGenerated")) != null) {
            this.maximumListItemsGenerated = Integer.parseInt(value);
        }
        if ((value = options.getProperty("maximumRecursionDepth")) != null) {
            this.maximumRecursionDepth = Integer.parseInt(value);
        }
        if ((value = options.getProperty("generateOptionalElements")) != null) {
            Boolean bl = "always".equals(value) ? Boolean.TRUE : (this.generateOptionalElements = "never".equals(value) ? Boolean.FALSE : null);
        }
        if ((value = options.getProperty("generateOptionalAttributes")) != null) {
            Boolean bl = "always".equals(value) ? Boolean.TRUE : (this.generateOptionalAttributes = "never".equals(value) ? Boolean.FALSE : null);
        }
        if ((value = options.getProperty("generateFixedAttributes")) != null) {
            Boolean bl = "always".equals(value) ? Boolean.TRUE : (this.generateFixedAttributes = "never".equals(value) ? Boolean.FALSE : null);
        }
        if ((value = options.getProperty("generateDefaultAttributes")) != null) {
            Boolean bl = "always".equals(value) ? Boolean.TRUE : (this.generateDefaultAttributes = "never".equals(value) ? Boolean.FALSE : null);
        }
        if ((value = options.getProperty("generateAllChoices")) != null) {
            this.generateAllChoices = Boolean.parseBoolean(value);
        }
        if ((value = options.getProperty("showContentModel")) != null) {
            this.showContentModel = Boolean.parseBoolean(value);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Usage:");
            System.err.println("\txsd-instance." + (OS.get().isWindows() ? "bat" : "sh") + " <xsd-file> [root-element]");
            System.err.println("Example:");
            System.err.println("\txsd-instance." + (OS.get().isWindows() ? "bat" : "sh") + " purchase-order.xsd {http://jlibs.org}PurchaseOrder");
            System.exit(1);
        }
        XSModel xsModel = new XSParser().parse(args[0]);
        QName rootElement = null;
        if (args.length > 1) {
            rootElement = QName.valueOf(args[1]);
        } else {
            List<XSElementDeclaration> elements = XSUtil.guessRootElements(xsModel);
            if (elements.size() == 0) {
                System.err.println("no elements found in given xml schema");
                System.exit(1);
            } else if (elements.size() == 1) {
                XSElementDeclaration elem = elements.get(0);
                rootElement = XSUtil.getQName((XSObject)elem);
            } else {
                XSElementDeclaration elem2;
                int i = 1;
                for (XSElementDeclaration elem2 : elements) {
                    System.err.println(i++ + ": " + XSUtil.getQName((XSObject)elem2));
                }
                System.err.print("Select Root Element: ");
                String line = new BufferedReader(new InputStreamReader(System.in)).readLine();
                elem2 = elements.get(Integer.parseInt(line) - 1);
                rootElement = XSUtil.getQName((XSObject)elem2);
            }
        }
        XSInstance xsInstance = new XSInstance();
        InputStream is = ClassLoader.getSystemClassLoader().getResourceAsStream("xsd-instance.properties");
        if (is != null) {
            xsInstance.loadOptions(CollectionUtil.readProperties((InputStream)is, null));
        }
        xsInstance.generate(xsModel, rootElement, new XMLDocument((Result)new StreamResult(System.out), true, 4, null));
        System.out.println();
    }

    public static interface SampleValueGenerator {
        public String generateSampleValue(XSElementDeclaration var1, XSSimpleTypeDefinition var2);

        public String generateSampleValue(XSAttributeDeclaration var1, XSSimpleTypeDefinition var2);
    }

    private class XSSampleVisitor
    extends ReflectionVisitor<Object, Processor<Object>> {
        private XMLDocument doc;
        private String xsiSchemaLocation;
        private String xsiNoNamespaceSchemaLocation;
        private Processor<XSElementDeclaration> elemProcessor = new Processor<XSElementDeclaration>(){

            private boolean isRecursionDepthCrossed(XSElementDeclaration elem, Path path) {
                if (path.getRecursionDepth() > XSInstance.this.maximumRecursionDepth) {
                    return true;
                }
                int typeRecursionDepth = -1;
                while (path != null) {
                    if (path.getElement() == elem.getTypeDefinition()) {
                        ++typeRecursionDepth;
                    }
                    path = path.getParentPath();
                }
                return typeRecursionDepth > XSInstance.this.maximumRecursionDepth;
            }

            public boolean preProcess(XSElementDeclaration elem, Path path) {
                if (this.isRecursionDepthCrossed(elem, path)) {
                    return false;
                }
                try {
                    if (XSInstance.this.showContentModel && elem.getTypeDefinition() instanceof XSComplexTypeDefinition) {
                        XSComplexTypeDefinition complexType = (XSComplexTypeDefinition)elem.getTypeDefinition();
                        switch (complexType.getContentType()) {
                            case 2: 
                            case 3: {
                                int i;
                                String contentModel = new XSContentModel().toString(complexType, XSSampleVisitor.this.doc);
                                boolean showContentModel = false;
                                for (char ch : "?*+|;[".toCharArray()) {
                                    if (contentModel.indexOf(ch) == -1) continue;
                                    showContentModel = true;
                                    break;
                                }
                                if (!showContentModel) break;
                                int depth = 0;
                                while ((path = path.getParentPath(XSElementDeclaration.class)) != null) {
                                    ++depth;
                                }
                                XSSampleVisitor.this.doc.addText("\n");
                                for (i = depth; i > 0; --i) {
                                    XSSampleVisitor.this.doc.addText("   ");
                                }
                                XSSampleVisitor.this.doc.addComment(contentModel);
                                XSSampleVisitor.this.doc.addText("\n");
                                for (i = depth; i > 0; --i) {
                                    XSSampleVisitor.this.doc.addText("   ");
                                }
                                break;
                            }
                        }
                    }
                    XSSampleVisitor.this.doc.startElement(elem.getNamespace(), elem.getName());
                    XSSampleVisitor.this.addXSILocations();
                    return true;
                }
                catch (SAXException ex) {
                    throw new ImpossibleException((Throwable)ex);
                }
            }

            public void postProcess(XSElementDeclaration elem, Path path) {
                if (this.isRecursionDepthCrossed(elem, path)) {
                    return;
                }
                try {
                    switch (elem.getConstraintType()) {
                        case 2: {
                            XSSampleVisitor.this.doc.addText(elem.getValueConstraintValue().getNormalizedValue());
                            break;
                        }
                        case 1: {
                            if (RandomUtil.randomBoolean()) {
                                XSSampleVisitor.this.doc.addText(elem.getValueConstraintValue().getNormalizedValue());
                                break;
                            }
                        }
                        default: {
                            XSSimpleTypeDefinition simpleType = null;
                            if (elem.getTypeDefinition().getTypeCategory() == 16) {
                                simpleType = (XSSimpleTypeDefinition)elem.getTypeDefinition();
                            } else {
                                XSComplexTypeDefinition complexType = (XSComplexTypeDefinition)elem.getTypeDefinition();
                                if (complexType.getContentType() == 1) {
                                    simpleType = complexType.getSimpleType();
                                }
                            }
                            if (simpleType == null) break;
                            String sampleValue = null;
                            if (XSInstance.this.sampleValueGenerator != null) {
                                sampleValue = XSInstance.this.sampleValueGenerator.generateSampleValue(elem, simpleType);
                            }
                            if (sampleValue == null) {
                                sampleValue = XSSampleVisitor.this.generateSampleValue(simpleType, elem.getName());
                            }
                            XSSampleVisitor.this.doc.addText(sampleValue);
                        }
                    }
                    XSSampleVisitor.this.doc.endElement();
                }
                catch (SAXException ex) {
                    throw new ImpossibleException((Throwable)ex);
                }
            }
        };
        private Processor<XSAttributeUse> attrProcessor = new Processor<XSAttributeUse>(){

            public boolean preProcess(XSAttributeUse attr, Path path) {
                try {
                    XSAttributeDeclaration decl = attr.getAttrDeclaration();
                    String sampleValue = null;
                    switch (attr.getConstraintType()) {
                        case 2: {
                            if (!RandomUtil.randomBoolean((Boolean)XSInstance.this.generateFixedAttributes)) break;
                            sampleValue = attr.getValueConstraintValue().getNormalizedValue();
                            break;
                        }
                        case 1: {
                            if (!RandomUtil.randomBoolean((Boolean)XSInstance.this.generateDefaultAttributes)) break;
                            sampleValue = attr.getValueConstraintValue().getNormalizedValue();
                            break;
                        }
                        default: {
                            if (!attr.getRequired() && !RandomUtil.randomBoolean((Boolean)XSInstance.this.generateOptionalAttributes)) break;
                            if (XSInstance.this.sampleValueGenerator != null) {
                                sampleValue = XSInstance.this.sampleValueGenerator.generateSampleValue(decl, decl.getTypeDefinition());
                            }
                            if (sampleValue != null) break;
                            sampleValue = XSSampleVisitor.this.generateSampleValue(decl.getTypeDefinition(), decl.getName());
                        }
                    }
                    if (sampleValue != null) {
                        XSSampleVisitor.this.doc.addAttribute(decl.getNamespace(), decl.getName(), sampleValue);
                    }
                    return false;
                }
                catch (SAXException ex) {
                    throw new ImpossibleException((Throwable)ex);
                }
            }

            public void postProcess(XSAttributeUse elem, Path path) {
            }
        };
        private Processor<XSComplexTypeDefinition> complexTypeProcessor = new Processor<XSComplexTypeDefinition>(){

            public boolean preProcess(XSComplexTypeDefinition complexType, Path path) {
                try {
                    XSElementDeclaration elem = (XSElementDeclaration)path.getParentPath().getElement();
                    XSComplexTypeDefinition elemType = (XSComplexTypeDefinition)elem.getTypeDefinition();
                    if (elemType.getAbstract()) {
                        XSSampleVisitor.this.doc.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", XSSampleVisitor.this.doc.toQName(complexType.getNamespace(), complexType.getName()));
                    }
                    return true;
                }
                catch (SAXException ex) {
                    throw new ImpossibleException((Throwable)ex);
                }
            }

            public void postProcess(XSComplexTypeDefinition complexType, Path path) {
            }
        };
        private Processor<XSWildcard> wildcardProcessor = new Processor<XSWildcard>(){

            public boolean preProcess(XSWildcard wildcard, Path path) {
                try {
                    String uri;
                    block1 : switch (wildcard.getConstraintType()) {
                        case 1: {
                            uri = "anyNS";
                            break;
                        }
                        case 3: {
                            StringList list = wildcard.getNsConstraintList();
                            int rand = RandomUtil.random((int)0, (int)(list.getLength() - 1));
                            uri = list.item(rand);
                            if (uri != null) break;
                            uri = "";
                            break;
                        }
                        case 2: {
                            int i;
                            StringList list = wildcard.getNsConstraintList();
                            ArrayList<String> namespaces = new ArrayList<String>();
                            for (i = 0; i < list.getLength(); ++i) {
                                namespaces.add(list.item(i));
                            }
                            uri = "anyNS";
                            if (!namespaces.contains(uri)) break;
                            i = 1;
                            while (true) {
                                if (!namespaces.contains(uri + i)) {
                                    uri = uri + i;
                                    break block1;
                                }
                                ++i;
                            }
                        }
                        default: {
                            throw new ImpossibleException();
                        }
                    }
                    if (this.isAttribute(wildcard, path)) {
                        XSSampleVisitor.this.doc.addAttribute(uri, "anyAttr", "anyValue");
                    } else {
                        XSSampleVisitor.this.doc.startElement(uri, "anyElement");
                        XSSampleVisitor.this.addXSILocations();
                    }
                    return true;
                }
                catch (SAXException ex) {
                    throw new ImpossibleException((Throwable)ex);
                }
            }

            public void postProcess(XSWildcard wildcard, Path path) {
                try {
                    if (!this.isAttribute(wildcard, path)) {
                        XSSampleVisitor.this.doc.endElement();
                    }
                }
                catch (SAXException ex) {
                    throw new ImpossibleException((Throwable)ex);
                }
            }

            private boolean isAttribute(XSWildcard wildcard, Path path) {
                XSComplexTypeDefinition complexType;
                return path.getParentPath().getElement() instanceof XSComplexTypeDefinition && (complexType = (XSComplexTypeDefinition)path.getParentPath().getElement()).getAttributeWildcard() == wildcard;
            }
        };
        private Map<String, Integer> counters = new HashMap<String, Integer>();
        private static final String XSD_DATE_FORMAT = "yyyy-MM-dd";
        private static final String XSD_TIME_FORMAT = "HH:mm:ss";

        private XSSampleVisitor(XMLDocument doc, String xsiSchemaLocation, String xsiNoNamespaceSchemaLocation) {
            this.doc = doc;
            this.xsiSchemaLocation = xsiSchemaLocation;
            this.xsiNoNamespaceSchemaLocation = xsiNoNamespaceSchemaLocation;
        }

        private void addXSILocations() throws SAXException {
            if (this.doc.getDepth() == 1) {
                if (this.xsiSchemaLocation != null) {
                    this.doc.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", this.xsiSchemaLocation);
                }
                if (this.xsiNoNamespaceSchemaLocation != null) {
                    this.doc.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation", this.xsiNoNamespaceSchemaLocation);
                }
            }
        }

        protected Processor getDefault(Object elem) {
            return null;
        }

        protected Processor process(XSElementDeclaration elem) {
            return this.elemProcessor;
        }

        protected Processor process(XSWildcard wildcard) {
            return this.wildcardProcessor;
        }

        protected Processor process(XSComplexTypeDefinition complexType) {
            return this.complexTypeProcessor;
        }

        protected Processor process(XSAttributeUse attr) {
            return this.attrProcessor;
        }

        private String generateSampleValue(XSSimpleTypeDefinition simpleType, String hint) {
            int n;
            if (simpleType.getBuiltInKind() == 44) {
                int len;
                XSSimpleTypeDefinition itemType = simpleType.getItemType();
                XSFacet facet = this.getFacet(itemType, 1);
                if (facet != null) {
                    len = Integer.parseInt(facet.getLexicalFacetValue());
                } else {
                    int max;
                    int min;
                    int minOccurs = 0;
                    facet = this.getFacet(itemType, 2);
                    if (facet != null) {
                        minOccurs = Integer.parseInt(facet.getLexicalFacetValue());
                    }
                    int maxOccurs = -1;
                    facet = this.getFacet(itemType, 4);
                    if (facet != null) {
                        maxOccurs = Integer.parseInt(facet.getLexicalFacetValue());
                    }
                    if (maxOccurs == -1) {
                        maxOccurs = Math.max(minOccurs, XSInstance.this.maximumListItemsGenerated);
                    }
                    if (XSInstance.this.minimumListItemsGenerated > maxOccurs || XSInstance.this.maximumListItemsGenerated < minOccurs) {
                        min = minOccurs;
                        max = maxOccurs;
                    } else {
                        min = Math.max(minOccurs, XSInstance.this.minimumListItemsGenerated);
                        max = Math.min(maxOccurs, XSInstance.this.maximumListItemsGenerated);
                    }
                    len = min == max ? min : RandomUtil.random((int)min, (int)max);
                }
                List<String> enums = XSUtil.getEnumeratedValues(itemType);
                if (enums.isEmpty()) {
                    StringBuilder buff = new StringBuilder();
                    while (len > 0) {
                        buff.append(" ");
                        buff.append(this.generateSampleValue(itemType, hint));
                        --len;
                    }
                    return buff.toString().trim();
                }
                while (enums.size() < len) {
                    enums.addAll(new ArrayList<String>(enums));
                }
                Collections.shuffle(enums);
                StringBuilder buff = new StringBuilder();
                while (len > 0) {
                    buff.append(" ");
                    buff.append(enums.remove(0));
                    --len;
                }
                return buff.toString().trim();
            }
            if (simpleType.getMemberTypes().getLength() > 0) {
                XSObjectList members = simpleType.getMemberTypes();
                int rand = RandomUtil.random((int)0, (int)(members.getLength() - 1));
                return this.generateSampleValue((XSSimpleTypeDefinition)members.item(rand), hint);
            }
            List<String> enums = XSUtil.getEnumeratedValues(simpleType);
            if (!enums.isEmpty()) {
                return enums.get(RandomUtil.random((int)0, (int)(enums.size() - 1)));
            }
            XSSimpleTypeDefinition builtInType = simpleType;
            while (!"http://www.w3.org/2001/XMLSchema".equals(builtInType.getNamespace())) {
                builtInType = (XSSimpleTypeDefinition)builtInType.getBaseType();
            }
            String name = builtInType.getName().toLowerCase();
            if ("boolean".equals(name)) {
                return RandomUtil.randomBoolean() ? "true" : "false";
            }
            if ("double".equals(name) || "decimal".equals(name) || "float".equals(name) || name.endsWith("integer") || name.endsWith("int") || name.endsWith("long") || name.endsWith("short") || name.endsWith("byte")) {
                return new Range(simpleType).randomNumber();
            }
            if ("date".equals(name)) {
                return new SimpleDateFormat(XSD_DATE_FORMAT).format(new Date());
            }
            if ("time".equals(name)) {
                return new SimpleDateFormat(XSD_TIME_FORMAT).format(new Date());
            }
            if ("datetime".equals(name)) {
                Date date = new Date();
                return new SimpleDateFormat(XSD_DATE_FORMAT).format(date) + 'T' + new SimpleDateFormat(XSD_TIME_FORMAT).format(date);
            }
            Integer count = this.counters.get(hint);
            if (count == null) {
                n = 1;
            } else {
                count = count + 1;
                n = count;
            }
            count = n;
            this.counters.put(hint, count);
            String countStr = count.toString();
            XSFacet lengthFacet = this.getFacet(simpleType, 1);
            XSFacet facet = this.getFacet(simpleType, 2);
            if (facet == null) {
                facet = lengthFacet;
            }
            if (facet != null) {
                int len = Integer.parseInt(facet.getLexicalFacetValue());
                len -= hint.length();
                if ((len -= countStr.length()) > 0) {
                    char[] ch = new char[len];
                    Arrays.fill(ch, '_');
                    hint = hint + new String(ch);
                }
            }
            if ((facet = this.getFacet(simpleType, 4)) == null) {
                facet = lengthFacet;
            }
            if (facet != null) {
                int maxLen;
                int len = maxLen = Integer.parseInt(facet.getLexicalFacetValue());
                len = hint.length() + countStr.length() - len;
                if (len > 0) {
                    if (hint.length() > len) {
                        hint = hint.substring(0, hint.length() - len);
                    } else {
                        hint = hint.substring(0, maxLen);
                        countStr = "";
                    }
                }
            }
            String value = hint + countStr;
            if ("base64binary".equals(name)) {
                return DatatypeConverter.printBase64Binary((byte[])value.getBytes(IOUtil.UTF_8));
            }
            return value;
        }

        private XSFacet getFacet(XSSimpleTypeDefinition simpleType, int kind) {
            XSObjectList facets = simpleType.getFacets();
            for (int i = 0; i < facets.getLength(); ++i) {
                XSFacet facet = (XSFacet)facets.item(i);
                if (facet.getFacetKind() != kind) continue;
                return facet;
            }
            return null;
        }

        class Range {
            String minInclusive;
            String minExclusive;
            String maxInclusive;
            String maxExclusive;
            int totalDigits = -1;
            int fractionDigits = -1;

            Range(XSSimpleTypeDefinition simpleType) {
                XSFacet facet = XSSampleVisitor.this.getFacet(simpleType, 256);
                if (facet != null) {
                    this.minInclusive = facet.getLexicalFacetValue();
                }
                if ((facet = XSSampleVisitor.this.getFacet(simpleType, 128)) != null) {
                    this.minExclusive = facet.getLexicalFacetValue();
                }
                if ((facet = XSSampleVisitor.this.getFacet(simpleType, 32)) != null) {
                    this.maxInclusive = facet.getLexicalFacetValue();
                }
                if ((facet = XSSampleVisitor.this.getFacet(simpleType, 64)) != null) {
                    this.maxExclusive = facet.getLexicalFacetValue();
                }
                if ((facet = XSSampleVisitor.this.getFacet(simpleType, 512)) != null) {
                    this.totalDigits = Integer.parseInt(facet.getLexicalFacetValue());
                }
                if ((facet = XSSampleVisitor.this.getFacet(simpleType, 1024)) != null) {
                    this.fractionDigits = Integer.parseInt(facet.getLexicalFacetValue());
                }
            }

            private String applyDigits(Object obj) {
                String fraction;
                String number;
                String str = String.valueOf(obj);
                int dot = str.indexOf(".");
                if (dot == -1) {
                    number = str;
                    fraction = "";
                } else {
                    number = str.substring(0, dot);
                    fraction = str.substring(dot + 1);
                }
                boolean negative = false;
                if (number.startsWith("-")) {
                    negative = true;
                    number = number.substring(1);
                }
                if (this.totalDigits >= 0 && number.length() > this.totalDigits) {
                    number = number.substring(0, this.totalDigits);
                }
                if (this.fractionDigits >= 0 && fraction.length() > this.fractionDigits) {
                    fraction = fraction.substring(0, this.fractionDigits);
                }
                str = negative ? "-" : "";
                str = str + number;
                if (fraction.length() > 0) {
                    str = str + '.' + fraction;
                }
                return str;
            }

            private String applyExponent(String str) {
                int index = str.indexOf(69);
                if (index == -1) {
                    return str;
                }
                int exponent = Integer.parseInt(str.substring(index + (str.charAt(index + 1) == '+' ? 2 : 1)));
                str = str.substring(0, index);
                boolean negative = false;
                if (str.charAt(0) == '-') {
                    negative = true;
                    str = str.substring(1);
                }
                if (exponent != 0) {
                    String afterDot;
                    String beforeDot;
                    int dot = str.indexOf(46);
                    if (dot == -1) {
                        beforeDot = str;
                        afterDot = "";
                    } else {
                        beforeDot = str.substring(0, dot);
                        afterDot = str.substring(dot + 1);
                    }
                    if (exponent < 0) {
                        while (exponent != 0) {
                            if (beforeDot.length() == 1) {
                                beforeDot = "0" + beforeDot;
                            }
                            afterDot = beforeDot.substring(beforeDot.length() - 1) + afterDot;
                            beforeDot = beforeDot.substring(0, beforeDot.length() - 1);
                            ++exponent;
                        }
                    } else {
                        while (exponent != 0) {
                            if (afterDot.isEmpty()) {
                                afterDot = "0";
                            }
                            beforeDot = beforeDot + afterDot.substring(0, 1);
                            afterDot = afterDot.substring(1);
                            --exponent;
                        }
                    }
                    String string = str = afterDot.isEmpty() ? beforeDot : beforeDot + "." + afterDot;
                }
                if (negative) {
                    str = "-" + str;
                }
                return str;
            }

            public String randomNumber() {
                if (this.fractionDigits == 0) {
                    long min = Long.MIN_VALUE;
                    if (this.minInclusive != null) {
                        min = (long)Double.parseDouble(this.minInclusive);
                    }
                    if (this.minExclusive != null) {
                        min = (long)Double.parseDouble(this.minExclusive) + 1L;
                    }
                    long max = Long.MAX_VALUE;
                    if (this.maxInclusive != null) {
                        max = (long)Double.parseDouble(this.maxInclusive);
                    }
                    if (this.maxExclusive != null) {
                        max = (long)Double.parseDouble(this.maxExclusive) - 1L;
                    }
                    return this.applyDigits(RandomUtil.random((long)min, (long)max));
                }
                double min = Double.MIN_VALUE;
                if (this.minInclusive != null) {
                    min = Double.parseDouble(this.minInclusive);
                }
                if (this.minExclusive != null) {
                    min = Double.parseDouble(this.minExclusive) + 1.0;
                }
                double max = Double.MAX_VALUE;
                if (this.maxInclusive != null) {
                    max = Double.parseDouble(this.maxInclusive);
                }
                if (this.maxExclusive != null) {
                    max = Double.parseDouble(this.maxExclusive) - 1.0;
                }
                return this.applyDigits(RandomUtil.random((double)min, (double)max));
            }
        }
    }

    private class XSSampleNavigator
    extends XSNavigator {
        private XSModel xsModel;

        private XSSampleNavigator(XSModel xsModel) {
            this.xsModel = xsModel;
        }

        @Override
        protected Sequence<XSTerm> process(XSParticle particle) {
            XSModelGroup group;
            XSTerm term = particle.getTerm();
            if (term instanceof XSModelGroup && (group = (XSModelGroup)term).getCompositor() == 2) {
                XSObjectList particles = group.getParticles();
                int count = particles.getLength();
                if (!XSInstance.this.generateAllChoices && !particle.getMaxOccursUnbounded()) {
                    count = Math.min(count, particle.getMaxOccurs());
                }
                ArrayList<XSParticle> list = new ArrayList<XSParticle>(particles.getLength());
                for (int i = 0; i < particles.getLength(); ++i) {
                    list.add((XSParticle)particles.item(i));
                }
                Collections.shuffle(list);
                return new IterableSequence(list.subList(0, count));
            }
            int maxOccurs = particle.getMaxOccursUnbounded() ? -1 : particle.getMaxOccurs();
            int repeatCount = XSInstance.this.generateRepeatCount(particle.getMinOccurs(), maxOccurs);
            return new RepeatSequence(super.process(particle), repeatCount);
        }

        @Override
        protected Sequence<XSParticle> process(XSModelGroup modelGroup) {
            switch (modelGroup.getCompositor()) {
                case 3: {
                    XSObjectList particles = modelGroup.getParticles();
                    ArrayList<XSParticle> list = new ArrayList<XSParticle>(particles.getLength());
                    for (int i = 0; i < particles.getLength(); ++i) {
                        list.add((XSParticle)particles.item(i));
                    }
                    Collections.shuffle(list);
                    return new IterableSequence(list);
                }
            }
            return super.process(modelGroup);
        }

        protected Sequence process(XSElementDeclaration elem) {
            XSComplexTypeDefinition complexType;
            if (elem.getAbstract()) {
                XSObjectList substitutionGroup = this.xsModel.getSubstitutionGroup(elem);
                if (substitutionGroup.getLength() == 0) {
                    return EmptySequence.getInstance();
                }
                int rand = RandomUtil.random((int)0, (int)(substitutionGroup.getLength() - 1));
                return new DuplicateSequence((Object)substitutionGroup.item(rand));
            }
            if (elem.getTypeDefinition() instanceof XSComplexTypeDefinition && (complexType = (XSComplexTypeDefinition)elem.getTypeDefinition()).getAbstract()) {
                List<XSComplexTypeDefinition> subTypes = XSUtil.getSubTypes(this.xsModel, complexType);
                if (subTypes.isEmpty()) {
                    return EmptySequence.getInstance();
                }
                int rand = RandomUtil.random((int)0, (int)(subTypes.size() - 1));
                return new DuplicateSequence((Object)subTypes.get(rand));
            }
            return new DuplicateSequence((Object)elem.getTypeDefinition());
        }
    }
}

