/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.xsd;

import java.util.Arrays;
import jlibs.core.lang.ImpossibleException;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.dom.DOMXSImplementationSourceImpl;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.XSImplementationImpl;
import org.apache.xerces.impl.xs.XSModelImpl;
import org.apache.xerces.impl.xs.util.StringListImpl;
import org.apache.xerces.xs.LSInputList;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class XSParser {
    private XSLoader xsLoader;

    public XSParser() {
        this(null, null);
    }

    public XSParser(LSResourceResolver entityResolver, DOMErrorHandler errorHandler) {
        DOMImplementationRegistry registry;
        System.setProperty("org.w3c.dom.DOMImplementationSourceList", DOMXSImplementationSourceImpl.class.getName());
        try {
            registry = DOMImplementationRegistry.newInstance();
        }
        catch (Exception ex) {
            throw new ImpossibleException((Throwable)ex);
        }
        XSImplementationImpl xsImpl = (XSImplementationImpl)registry.getDOMImplementation("XS-Loader");
        this.xsLoader = xsImpl.createXSLoader(null);
        DOMConfiguration config = this.xsLoader.getConfig();
        config.setParameter("validate", Boolean.TRUE);
        if (entityResolver != null) {
            config.setParameter("resource-resolver", entityResolver);
        }
        if (errorHandler != null) {
            config.setParameter("error-handler", errorHandler);
        }
    }

    public XSModel parse(String uri) {
        XSModel xsModel = this.xsLoader.loadURI(uri);
        if (xsModel == null) {
            throw new RuntimeException("Couldn't load XMLSchema from " + uri);
        }
        return xsModel;
    }

    public XSModel parse(String ... uris) {
        XSModel xsModel = this.xsLoader.loadURIList((StringList)new StringListImpl(uris, uris.length));
        if (xsModel == null) {
            throw new RuntimeException("Couldn't load XMLSchema from " + Arrays.asList(uris));
        }
        return xsModel;
    }

    public XSModel parse(LSInputList inputList) {
        XSModel xsModel = this.xsLoader.loadInputList(inputList);
        if (xsModel == null) {
            throw new RuntimeException("Couldn't load XMLSchema from " + inputList);
        }
        return xsModel;
    }

    public XSModel parseString(String schema, String baseURI) {
        return this.xsLoader.load((LSInput)new DOMInputImpl(null, null, baseURI, schema, null));
    }

    public static XSModel getBuiltInSchema() {
        return new XSModelImpl(new SchemaGrammar[0]);
    }
}

