/*
 * Decompiled with CFR 0.152.
 */
package in.juspay.model;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import in.juspay.exception.APIConnectionException;
import in.juspay.exception.APIException;
import in.juspay.exception.AuthenticationException;
import in.juspay.exception.AuthorizationException;
import in.juspay.exception.InvalidRequestException;
import in.juspay.model.JuspayEnvironment;
import in.juspay.model.RequestOptions;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JuspayEntity {
    private static final Logger log = LogManager.getLogger(JuspayEntity.class);

    private static String serializeParams(Map<String, Object> params) {
        if (params == null || params.size() == 0) {
            return "";
        }
        StringBuilder serializedParams = new StringBuilder();
        try {
            for (String key : params.keySet()) {
                serializedParams.append(key + "=");
                if (params.get(key) != null) {
                    serializedParams.append(URLEncoder.encode(params.get(key).toString(), "UTF-8"));
                }
                serializedParams.append("&");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Encoding exception while trying to construct payload", e);
        }
        if (serializedParams.charAt(serializedParams.length() - 1) == '&') {
            serializedParams.deleteCharAt(serializedParams.length() - 1);
        }
        return serializedParams.toString();
    }

    protected static JsonObject makeServiceCall(String path, Map<String, Object> params, RequestMethod method, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        if (requestOptions == null) {
            requestOptions = RequestOptions.createDefault();
        }
        CloseableHttpClient httpclient = HttpClients.createDefault();
        String encodedKey = new String(Base64.encodeBase64((byte[])requestOptions.getApiKey().getBytes())).replaceAll("\n", "");
        int httpResponseCode = -1;
        String responseString = null;
        try {
            MapMessage mapMessage = new MapMessage();
            if (params != null) {
                for (String key : params.keySet()) {
                    String value = "";
                    if (params.get(key) != null) {
                        value = params.get(key).toString();
                    }
                    mapMessage.put(key, value);
                }
            }
            String url = JuspayEnvironment.getBaseUrl() + path;
            log.info("Executing request: " + (Object)((Object)method) + " " + url);
            log.info("Request parameters: ");
            log.info((Message)mapMessage);
            CloseableHttpResponse response = null;
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(requestOptions.getConnectTimeoutInMilliSeconds()).setConnectTimeout(requestOptions.getConnectTimeoutInMilliSeconds()).setSocketTimeout(requestOptions.getReadTimeoutInMilliSeconds()).build();
            if (method == RequestMethod.POST) {
                HttpPost httpPost = new HttpPost(url);
                httpPost.setConfig(requestConfig);
                httpPost.setHeader("Authorization", String.format("Basic %s", encodedKey));
                httpPost.setHeader("version", "2016-10-27");
                httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
                httpPost.setHeader("Content-Language", "en-US");
                httpPost.setHeader("User-Agent", JuspayEnvironment.SDK_VERSION);
                if (params != null) {
                    ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                    for (String key : params.keySet()) {
                        if (params.get(key) != null) {
                            nvps.add(new BasicNameValuePair(key, params.get(key).toString()));
                            continue;
                        }
                        nvps.add(new BasicNameValuePair(key, ""));
                    }
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
                }
                response = httpclient.execute((HttpUriRequest)httpPost);
            } else if (method == RequestMethod.DELETE) {
                HttpDelete httpDelete = new HttpDelete(url);
                httpDelete.setConfig(requestConfig);
                httpDelete.setHeader("Authorization", String.format("Basic %s", encodedKey));
                httpDelete.setHeader("version", "2016-10-27");
                httpDelete.setHeader("Content-Type", "application/x-www-form-urlencoded");
                httpDelete.setHeader("Content-Language", "en-US");
                httpDelete.setHeader("User-Agent", JuspayEnvironment.SDK_VERSION);
                response = httpclient.execute((HttpUriRequest)httpDelete);
            } else {
                String encodedParams = JuspayEntity.serializeParams(params);
                if (encodedParams != null && !encodedParams.equals("")) {
                    url = url + "?" + encodedParams;
                }
                HttpGet httpGet = new HttpGet(url);
                httpGet.setConfig(requestConfig);
                httpGet.setHeader("Authorization", String.format("Basic %s", encodedKey));
                httpGet.setHeader("version", "2016-10-27");
                httpGet.setHeader("Content-Type", "application/x-www-form-urlencoded");
                httpGet.setHeader("Content-Language", "en-US");
                httpGet.setHeader("User-Agent", JuspayEnvironment.SDK_VERSION);
                response = httpclient.execute((HttpUriRequest)httpGet);
            }
            httpResponseCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                responseString = EntityUtils.toString((HttpEntity)entity);
            }
            log.info("Received HTTP Response Code: " + httpResponseCode);
            log.info("Received response: " + responseString);
        }
        catch (Exception e) {
            log.error("Exception occurred during request execution. Exception is: ", (Throwable)e);
            throw new APIConnectionException(-1, "connection_error", "connection_error", e.getMessage());
        }
        finally {
            try {
                httpclient.close();
            }
            catch (Exception e) {
                log.error("Exception occurred while closing the httpclient. Exception is: ", (Throwable)e);
                throw new APIConnectionException(-1, "connection_error", "connection_error", e.getMessage());
            }
        }
        JsonObject resJson = null;
        try {
            resJson = responseString != null ? new JsonParser().parse(responseString).getAsJsonObject() : null;
        }
        catch (JsonSyntaxException e) {
            log.info("Not able to parse the response into Json. Exception is: ", (Throwable)e);
        }
        if (httpResponseCode >= 200 && httpResponseCode < 300) {
            return resJson;
        }
        String status = null;
        String errorCode = null;
        String errorMessage = null;
        if (resJson != null) {
            if (resJson.has("status")) {
                status = resJson.get("status").getAsString();
            }
            if (resJson.has("error_code")) {
                errorCode = resJson.get("error_code").getAsString();
            }
            if (resJson.has("error_message")) {
                errorMessage = resJson.get("error_message").getAsString();
            }
        }
        switch (httpResponseCode) {
            case 400: 
            case 404: {
                throw new InvalidRequestException(httpResponseCode, status, errorCode, errorMessage);
            }
            case 401: {
                throw new AuthenticationException(httpResponseCode, status, errorCode, errorMessage);
            }
            case 403: {
                throw new AuthorizationException(httpResponseCode, status, errorCode, errorMessage);
            }
        }
        throw new APIException(httpResponseCode, "internal_error", "internal_error", "Something went wrong.");
    }

    protected static JsonObject addInputParamsToResponse(Map<String, Object> params, JsonObject response) {
        JsonObject inputJson = new JsonParser().parse(new GsonBuilder().create().toJson(params)).getAsJsonObject();
        for (Map.Entry entry : inputJson.entrySet()) {
            response.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return response;
    }

    protected static <T> T createEntityFromResponse(JsonElement response, Class<T> entityClass) {
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        Object entity = gson.fromJson(response, entityClass);
        return (T)entity;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum RequestMethod {
        GET,
        POST,
        DELETE;

    }
}

