/*
 * Decompiled with CFR 0.152.
 */
package in.neuw.aws.rolesanywhere.credentials;

import com.fasterxml.jackson.databind.ObjectMapper;
import in.neuw.aws.rolesanywhere.credentials.RolesAnywhereCredentialsProvider;
import in.neuw.aws.rolesanywhere.credentials.models.AwsRolesAnyWhereRequesterDetails;
import in.neuw.aws.rolesanywhere.credentials.models.AwsRolesAnywhereSessionsRequest;
import in.neuw.aws.rolesanywhere.credentials.models.AwsRolesAnywhereSessionsResponse;
import in.neuw.aws.rolesanywhere.credentials.models.CredentialSet;
import in.neuw.aws.rolesanywhere.credentials.models.X509CertificateChain;
import in.neuw.aws.rolesanywhere.props.AwsRolesAnywhereProperties;
import in.neuw.aws.rolesanywhere.utils.AwsX509SigningHelper;
import in.neuw.aws.rolesanywhere.utils.CertAndKeyParserAndLoader;
import java.security.PrivateKey;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IAMRolesAnywhereSessionsCredentialsProvider
extends RolesAnywhereCredentialsProvider
implements ToCopyableBuilder<Builder, IAMRolesAnywhereSessionsCredentialsProvider> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IAMRolesAnywhereSessionsCredentialsProvider.class);
    private final AwsRolesAnywhereSessionsRequest awsRolesAnywhereSessionsRequest;
    private final AwsRolesAnyWhereRequesterDetails requesterDetails;

    private IAMRolesAnywhereSessionsCredentialsProvider(Builder builder) {
        super(builder, "iam-r-aw-thread");
        log.info("setting up the rest client for 'roles anywhere AWS service', with host = {} based on region = {}", (Object)builder.host, (Object)builder.region);
        this.awsRolesAnywhereSessionsRequest = builder.awsRolesAnywhereSessionsRequest;
        this.requesterDetails = builder.requesterDetails;
        this.prefetchCredentials();
    }

    private Instant getInstantFromResponseExpiry(String expiry) {
        return LocalDateTime.parse(expiry, DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'")).atZone(ZoneId.of("UTC")).toInstant();
    }

    @Override
    AwsSessionCredentials getUpdatedCredentials() {
        AwsRolesAnywhereSessionsResponse response = this.refreshCredentials();
        CredentialSet credentials = response.getCredentialSet().get(0);
        log.info("fetched credentials at epoch seconds = {} with expiry epoch seconds = {}", (Object)Instant.now().getEpochSecond(), (Object)this.getInstantFromResponseExpiry(credentials.getCredentials().getExpiration()).getEpochSecond());
        return AwsSessionCredentials.builder().sessionToken(credentials.getCredentials().getSessionToken()).accessKeyId(credentials.getCredentials().getAccessKeyId()).secretAccessKey(credentials.getCredentials().getSecretAccessKey()).expirationTime(this.getInstantFromResponseExpiry(credentials.getCredentials().getExpiration())).build();
    }

    @Override
    String providerName() {
        return "rolesanywhere-provider";
    }

    public AwsRolesAnywhereSessionsResponse refreshCredentials() {
        log.info("re-fetching credentials for 'roles anywhere AWS service'");
        return this.fetchCredentials(this.awsRolesAnywhereSessionsRequest, this.requesterDetails, this.sdkHttpClient, this.objectMapper);
    }

    private AwsRolesAnywhereSessionsResponse fetchCredentials(AwsRolesAnywhereSessionsRequest awsRolesAnywhereSessionsRequest, AwsRolesAnyWhereRequesterDetails requesterDetails, SdkHttpClient sdkHttpClient, ObjectMapper objectMapper) {
        return AwsX509SigningHelper.getIamRolesAnywhereSessions(awsRolesAnywhereSessionsRequest, requesterDetails, sdkHttpClient, objectMapper);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public IAMRolesAnywhereSessionsCredentialsProvider copy(Consumer<? super Builder> modifier) {
        return (IAMRolesAnywhereSessionsCredentialsProvider)super.copy(modifier);
    }

    @NotThreadSafe
    public static final class Builder
    extends RolesAnywhereCredentialsProvider.BaseBuilder<Builder, IAMRolesAnywhereSessionsCredentialsProvider> {
        private final Integer allowedMaxDurationInSeconds = 50400;
        private AwsRolesAnywhereSessionsRequest awsRolesAnywhereSessionsRequest;
        private AwsRolesAnywhereProperties awsRolesAnywhereProperties;
        private String roleArn;
        private String profileArn;
        private String trustAnchorArn;
        private String region;
        private Integer durationSeconds;
        private String roleSessionName;
        private String encodedX509Certificate;
        private String encodedPrivateKey;
        private X509CertificateChain x509CertificateChain;
        private PrivateKey privateKey;
        private Region awsRegion;
        private String host;
        private AwsRolesAnyWhereRequesterDetails requesterDetails;

        public Builder(IAMRolesAnywhereSessionsCredentialsProvider provider) {
            super(IAMRolesAnywhereSessionsCredentialsProvider::new, provider);
            super.objectMapper(new ObjectMapper());
        }

        public Builder(AwsRolesAnywhereProperties awsRolesAnywhereProperties, ObjectMapper objectMapper) {
            super(IAMRolesAnywhereSessionsCredentialsProvider::new);
            this.awsRegion = Region.of((String)awsRolesAnywhereProperties.getRegion());
            this.initRestClient();
            this.awsRolesAnywhereProperties = awsRolesAnywhereProperties;
            this.objectMapper(objectMapper);
            this.region = awsRolesAnywhereProperties.getRegion();
            this.durationSeconds = awsRolesAnywhereProperties.getDurationSeconds();
            this.roleArn = awsRolesAnywhereProperties.getRoleArn();
            this.profileArn = awsRolesAnywhereProperties.getProfileArn();
            this.trustAnchorArn = awsRolesAnywhereProperties.getTrustAnchorArn();
            this.encodedPrivateKey = awsRolesAnywhereProperties.getEncodedPrivateKey();
            this.encodedX509Certificate = awsRolesAnywhereProperties.getEncodedX509Certificate();
            this.x509CertificateChain = CertAndKeyParserAndLoader.resolveCertificateChain(awsRolesAnywhereProperties.getEncodedX509Certificate());
            this.privateKey = CertAndKeyParserAndLoader.extractPrivateKey(this.awsRolesAnywhereProperties.getEncodedPrivateKey());
            this.host = AwsX509SigningHelper.resolveHostBasedOnRegion(this.awsRegion);
        }

        public Builder(ObjectMapper objectMapper) {
            super(IAMRolesAnywhereSessionsCredentialsProvider::new);
            this.initRestClient();
            this.objectMapper(objectMapper);
        }

        public Builder region(String region) {
            this.region = region;
            this.awsRegion = Region.of((String)region);
            this.initRestClient();
            return this;
        }

        public Builder durationSeconds(int durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public Builder trustAnchorArn(String trustAnchorArn) {
            this.trustAnchorArn = trustAnchorArn;
            return this;
        }

        public Builder roleSessionName(String roleSessionName) {
            this.roleSessionName = roleSessionName;
            return this;
        }

        public Builder encodedX509Certificate(String encodedX509Certificate) {
            this.encodedX509Certificate = encodedX509Certificate;
            this.x509CertificateChain = CertAndKeyParserAndLoader.resolveCertificateChain(encodedX509Certificate);
            return this;
        }

        public Builder encodedPrivateKey(String encodedPrivateKey) {
            this.encodedPrivateKey = encodedPrivateKey;
            this.privateKey = CertAndKeyParserAndLoader.extractPrivateKey(encodedPrivateKey);
            return this;
        }

        private void initRequest() {
            this.awsRolesAnywhereSessionsRequest = new AwsRolesAnywhereSessionsRequest().setRoleArn(this.roleArn).setProfileArn(this.profileArn).setTrustAnchorArn(this.trustAnchorArn).setDurationSeconds(this.durationSeconds);
        }

        private void initRestClient() {
            this.sdkHttpClient(ApacheHttpClient.builder().maxConnections(Integer.valueOf(100)).build());
        }

        @Override
        public IAMRolesAnywhereSessionsCredentialsProvider build() {
            this.validateImportantFields();
            this.requesterDetails = AwsRolesAnyWhereRequesterDetails.builder().durationSeconds(this.durationSeconds).certificateChain(this.x509CertificateChain).privateKey(this.privateKey).encodedPrivateKey(this.encodedPrivateKey).encodedX509Certificate(this.encodedX509Certificate).host(this.host).region(this.awsRegion).trustAnchorArn(this.trustAnchorArn).roleArn(this.roleArn).profileArn(this.profileArn).roleSessionName(this.roleSessionName).build();
            this.initRequest();
            return (IAMRolesAnywhereSessionsCredentialsProvider)super.build();
        }

        public void validateImportantFields() {
            if (this.durationSeconds == null) {
                throw new IllegalArgumentException("durationSeconds cannot be null");
            }
            if (this.durationSeconds <= 0 || this.durationSeconds > this.allowedMaxDurationInSeconds) {
                throw new IllegalArgumentException("durationSeconds must be between 0 and " + this.allowedMaxDurationInSeconds + "in seconds");
            }
            if (StringUtils.isBlank((CharSequence)this.region)) {
                throw new IllegalArgumentException("region cannot be blank");
            }
            if (StringUtils.isBlank((CharSequence)this.roleArn)) {
                throw new IllegalArgumentException("roleArn cannot be blank");
            }
            if (StringUtils.isBlank((CharSequence)this.profileArn)) {
                throw new IllegalArgumentException("profileArn cannot be blank");
            }
            if (StringUtils.isBlank((CharSequence)this.trustAnchorArn)) {
                throw new IllegalArgumentException("trustAnchorArn cannot be blank");
            }
            if (StringUtils.isBlank((CharSequence)this.encodedPrivateKey)) {
                throw new IllegalArgumentException("encodedPrivateKey cannot be blank");
            }
            if (StringUtils.isBlank((CharSequence)this.encodedX509Certificate)) {
                throw new IllegalArgumentException("encodedPrivateKey cannot be blank");
            }
        }
    }
}

