/*
 * Decompiled with CFR 0.152.
 */
package in.neuw.aws.rolesanywhere.credentials;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Function;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;
import software.amazon.awssdk.utils.cache.CachedSupplier;
import software.amazon.awssdk.utils.cache.NonBlocking;
import software.amazon.awssdk.utils.cache.RefreshResult;

@ThreadSafe
@SdkPublicApi
public abstract class RolesAnywhereCredentialsProvider
implements AwsCredentialsProvider,
SdkAutoCloseable {
    private static final Logger log = Logger.loggerFor(RolesAnywhereCredentialsProvider.class);
    private static final Duration DEFAULT_STALE_TIME = Duration.ofMinutes(1L);
    private static final Duration DEFAULT_PREFETCH_TIME = Duration.ofMinutes(5L);
    final SdkHttpClient sdkHttpClient;
    final ObjectMapper objectMapper;
    private final CachedSupplier<AwsSessionCredentials> sessionCache;
    private final Duration staleTime;
    private final Duration prefetchTime;
    private final boolean asyncCredentialUpdateEnabled;
    private final boolean prefetch;

    RolesAnywhereCredentialsProvider(BaseBuilder<?, ?> builder, String asyncThreadName) {
        this.sdkHttpClient = (SdkHttpClient)Validate.notNull((Object)builder.sdkHttpClient, (String)"sdkHttpClient must not be null.", (Object[])new Object[0]);
        this.objectMapper = (ObjectMapper)Validate.notNull((Object)builder.objectMapper, (String)"Object Mapper must not be null.", (Object[])new Object[0]);
        this.staleTime = Optional.ofNullable(builder.staleTime).orElse(DEFAULT_STALE_TIME);
        this.prefetchTime = Optional.ofNullable(builder.prefetchTime).orElse(DEFAULT_PREFETCH_TIME);
        this.asyncCredentialUpdateEnabled = builder.asyncCredentialUpdateEnabled;
        this.prefetch = builder.prefetch;
        CachedSupplier.Builder cacheBuilder = CachedSupplier.builder(this::updateSessionCredentials).cachedValueName(this.toString());
        if (this.asyncCredentialUpdateEnabled) {
            cacheBuilder.prefetchStrategy((CachedSupplier.PrefetchStrategy)new NonBlocking(asyncThreadName));
        }
        this.sessionCache = cacheBuilder.build();
    }

    private RefreshResult<AwsSessionCredentials> updateSessionCredentials() {
        AwsSessionCredentials credentials = this.getUpdatedCredentials();
        Instant actualTokenExpiration = (Instant)credentials.expirationTime().orElseThrow(() -> new IllegalStateException("Sourced credentials have no expiration value"));
        return RefreshResult.builder((Object)credentials).staleTime(actualTokenExpiration.minus(this.staleTime)).prefetchTime(actualTokenExpiration.minus(this.prefetchTime)).build();
    }

    public AwsCredentials resolveCredentials() {
        AwsSessionCredentials credentials = (AwsSessionCredentials)this.sessionCache.get();
        credentials.expirationTime().ifPresent(t -> log.info(() -> "Using Role Anywhere credentials with expiration time of " + String.valueOf(t)));
        return credentials;
    }

    public void close() {
        this.sessionCache.close();
    }

    public Duration staleTime() {
        return this.staleTime;
    }

    public Duration prefetchTime() {
        return this.prefetchTime;
    }

    public String toString() {
        return ToString.create((String)this.providerName());
    }

    abstract AwsSessionCredentials getUpdatedCredentials();

    abstract String providerName();

    void prefetchCredentials() {
        if (this.prefetch) {
            log.info(() -> "prefetch was enabled, prefetching the credentials");
            this.sessionCache.get();
        }
    }

    @NotThreadSafe
    @SdkPublicApi
    public static abstract class BaseBuilder<B extends BaseBuilder<B, T>, T extends ToCopyableBuilder<B, T>>
    implements CopyableBuilder<B, T> {
        private final Function<B, T> providerConstructor;
        private boolean asyncCredentialUpdateEnabled;
        private SdkHttpClient sdkHttpClient;
        private ObjectMapper objectMapper;
        private Duration staleTime;
        private Duration prefetchTime = Duration.ofMinutes(5L);
        private boolean prefetch;

        BaseBuilder(Function<B, T> providerConstructor, RolesAnywhereCredentialsProvider provider) {
            this.providerConstructor = providerConstructor;
            this.prefetchTime = provider.prefetchTime;
            this.asyncCredentialUpdateEnabled = provider.asyncCredentialUpdateEnabled;
            this.sdkHttpClient = provider.sdkHttpClient;
            this.staleTime = provider.staleTime;
            this.objectMapper = provider.objectMapper;
        }

        BaseBuilder(Function<B, T> providerConstructor) {
            this.providerConstructor = providerConstructor;
        }

        public B sdkHttpClient(SdkHttpClient sdkHttpClient) {
            this.sdkHttpClient = sdkHttpClient;
            return (B)this;
        }

        public B objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return (B)this;
        }

        public B asyncCredentialUpdateEnabled(Boolean asyncCredentialUpdateEnabled) {
            this.asyncCredentialUpdateEnabled = asyncCredentialUpdateEnabled;
            return (B)this;
        }

        public B staleTime(Duration staleTime) {
            this.staleTime = staleTime;
            return (B)this;
        }

        public B prefetchTime(Duration prefetchTime) {
            this.prefetchTime = prefetchTime;
            return (B)this;
        }

        public B prefetch(boolean prefetch) {
            this.prefetch = prefetch;
            return (B)this;
        }

        public T build() {
            return (T)((ToCopyableBuilder)this.providerConstructor.apply(this));
        }
    }
}

