/*
 * Decompiled with CFR 0.152.
 */
package in.neuw.aws.rolesanywhere.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import in.neuw.aws.rolesanywhere.credentials.models.AwsRolesAnyWhereRequesterDetails;
import in.neuw.aws.rolesanywhere.credentials.models.AwsRolesAnywhereSessionsRequest;
import in.neuw.aws.rolesanywhere.credentials.models.AwsRolesAnywhereSessionsResponse;
import in.neuw.aws.rolesanywhere.credentials.models.X509CertificateChain;
import in.neuw.aws.rolesanywhere.utils.CertAndKeyParserAndLoader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.HttpExecuteResponse;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceEndpointKey;
import software.amazon.awssdk.regions.servicemetadata.RolesanywhereServiceMetadata;
import software.amazon.awssdk.services.iam.model.IamException;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.IoUtils;

public class AwsX509SigningHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AwsX509SigningHelper.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'").withZone(ZoneOffset.UTC);
    private static final String LINE_SEPARATOR = "\n";
    private static final String SEMI_COLON = ";";
    public static final String X_AMZ_X509 = "X-Amz-X509";
    public static final String X_AMZ_X509_CHAIN = "X-Amz-X509-Chain";
    private static final String SHA_256 = "SHA-256";
    public static final String SESSIONS_URI = "/sessions";
    public static final String ROLES_ANYWHERE_SERVICE = "rolesanywhere";
    public static final String AWS4_X509_PREFIX = "AWS4-X509-";
    public static final String AWS4_X509_SUFFIX = "-SHA256";
    public static final String CREDENTIAL_PREFIX = "Credential=";
    public static final String CREDENTIALS_DE_LIMITER = ", ";
    public static final String SIGNED_HEADERS_PREFIX = "SignedHeaders=";
    public static final String SIGNATURE_PREFIX = "Signature=";
    public static final String EMPTY_STRING = "";

    private AwsX509SigningHelper() {
    }

    public static String getDateAndTime(Instant instant) {
        return dateTimeFormatter.format(instant);
    }

    public static String getDate(Instant instant) {
        return AwsX509SigningHelper.getDateAndTime(instant).substring(0, 8);
    }

    public static byte[] hash(String text) {
        MessageDigest digest = MessageDigest.getInstance(SHA_256);
        return digest.digest(text.getBytes(StandardCharsets.UTF_8));
    }

    public static String signedHeaders() {
        return "Content-Type;Host;X-Amz-Date;X-Amz-X509";
    }

    public static String signedHeadersWithChain() {
        return AwsX509SigningHelper.signedHeaders() + ";X-Amz-X509-Chain";
    }

    public static String canonicalRequest(Instant instant, String host, String method, String uri, String body, X509CertificateChain x509CertificateChain) throws NoSuchAlgorithmException, CertificateException {
        String dateAndTime = AwsX509SigningHelper.getDateAndTime(instant);
        String canonicalHeaders = EMPTY_STRING;
        StringBuilder canonicalRequestBuilder = new StringBuilder();
        canonicalRequestBuilder.append(method).append(LINE_SEPARATOR).append(uri).append(LINE_SEPARATOR).append(EMPTY_STRING).append(LINE_SEPARATOR);
        if (x509CertificateChain.getIntermediateCACertificate() == null) {
            canonicalHeaders = AwsX509SigningHelper.buildCanonicalHeaders(host, ContentType.APPLICATION_JSON.getMimeType(), dateAndTime, x509CertificateChain.getBase64EncodedCertificate());
            canonicalRequestBuilder.append(canonicalHeaders).append(LINE_SEPARATOR).append(AwsX509SigningHelper.signedHeaders().toLowerCase()).append(LINE_SEPARATOR);
        } else {
            String chainCerts = CertAndKeyParserAndLoader.convertToBase64PEMString(x509CertificateChain.getIntermediateCACertificate());
            canonicalHeaders = AwsX509SigningHelper.buildCanonicalHeaders(host, ContentType.APPLICATION_JSON.getMimeType(), dateAndTime, CertAndKeyParserAndLoader.convertToBase64PEMString(x509CertificateChain.getLeafCertificate()), chainCerts);
            canonicalRequestBuilder.append(canonicalHeaders).append(LINE_SEPARATOR).append(AwsX509SigningHelper.signedHeadersWithChain().toLowerCase()).append(LINE_SEPARATOR);
        }
        log.debug("canonicalHeaders = {}", (Object)canonicalHeaders);
        log.debug("sessions request = {}", (Object)body);
        canonicalRequestBuilder.append(AwsX509SigningHelper.hashContent(body));
        return canonicalRequestBuilder.toString();
    }

    public static String hashContent(String canonicalRequest) {
        return BinaryUtils.toHex((byte[])AwsX509SigningHelper.hash(canonicalRequest));
    }

    public static SortedMap<String, String> canonicalHeaders(String host, String contentType, String date, String derX509) {
        TreeMap<String, String> headers = new TreeMap<String, String>();
        headers.put("Content-Type".toLowerCase(), contentType);
        headers.put("Host".toLowerCase(), host);
        headers.put("X-Amz-Date".toLowerCase(), date);
        headers.put(X_AMZ_X509.toLowerCase(), derX509);
        return headers;
    }

    public static String buildCanonicalHeaders(String host, String contentType, String date, String derX509) {
        SortedMap<String, String> headers = AwsX509SigningHelper.canonicalHeaders(host, contentType, date, derX509);
        return headers.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + (String)entry.getValue()).collect(Collectors.joining(LINE_SEPARATOR)) + LINE_SEPARATOR;
    }

    public static String buildCanonicalHeaders(String host, String contentType, String date, String derX509, String chainDerX509CommaSeparated) {
        SortedMap<String, String> headers = AwsX509SigningHelper.canonicalHeaders(host, contentType, date, derX509);
        headers.put(X_AMZ_X509_CHAIN.toLowerCase(), chainDerX509CommaSeparated);
        return headers.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + (String)entry.getValue()).collect(Collectors.joining(LINE_SEPARATOR)) + LINE_SEPARATOR;
    }

    public static String resolveHostBasedOnRegion(Region region) {
        return new RolesanywhereServiceMetadata().endpointFor(ServiceEndpointKey.builder().region(region).build()).getPath();
    }

    public static String resolveHostEndpoint(Region region) {
        return "https://" + AwsX509SigningHelper.resolveHostBasedOnRegion(region);
    }

    public static String resolveAwsAlgorithm(PrivateKey key) {
        return AWS4_X509_PREFIX + CertAndKeyParserAndLoader.resolveAndValidateAlgorithm(key) + AWS4_X509_SUFFIX;
    }

    public static String credentialScope(Instant instant, Region region) {
        String credentialScope = AwsX509SigningHelper.getDate(instant) + "/" + region.id() + "/rolesanywhere/aws4_request";
        log.debug("credentialScope: {}", (Object)credentialScope);
        return credentialScope;
    }

    public static String contentToSign(Instant instant, Region region, String algorithm, String canonicalRequest) {
        log.debug("canonicalRequest: \n{}", (Object)canonicalRequest);
        return algorithm + LINE_SEPARATOR + AwsX509SigningHelper.getDateAndTime(instant) + LINE_SEPARATOR + AwsX509SigningHelper.credentialScope(instant, region) + LINE_SEPARATOR + AwsX509SigningHelper.hashContent(canonicalRequest);
    }

    public static String sign(String contentToSign, PrivateKey key) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(CertAndKeyParserAndLoader.resolveSignatureAlgorithm(key));
        signature.initSign(key);
        signature.update(contentToSign.getBytes(StandardCharsets.UTF_8));
        byte[] signatureBytes = signature.sign();
        return BinaryUtils.toHex((byte[])signatureBytes);
    }

    public static String awsSignedAuthHeader(Instant instant, Region region, String contentToSign, String algorithm, String signedHeaders, X509Certificate cert, PrivateKey key) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        String certId = cert.getSerialNumber().toString();
        String credentialPart = certId + "/" + AwsX509SigningHelper.credentialScope(instant, region);
        String signedContent = AwsX509SigningHelper.sign(contentToSign, key);
        return algorithm + " Credential=" + credentialPart + ", SignedHeaders=" + signedHeaders + ", Signature=" + signedContent;
    }

    public static AwsRolesAnywhereSessionsResponse getIamRolesAnywhereSessions(AwsRolesAnywhereSessionsRequest sessionsRequest, AwsRolesAnyWhereRequesterDetails requesterDetails, SdkHttpClient sdkHttpClient, ObjectMapper om) {
        try {
            String request = om.writeValueAsString((Object)sessionsRequest);
            Region awsRegion = requesterDetails.getRegion();
            String host = AwsX509SigningHelper.resolveHostBasedOnRegion(awsRegion);
            X509CertificateChain x509CertificateChain = CertAndKeyParserAndLoader.resolveCertificateChain(requesterDetails.getEncodedX509Certificate());
            log.debug("request: {}", (Object)request);
            Instant instant = Instant.now();
            String canonicalRequest = AwsX509SigningHelper.canonicalRequest(instant, host, SdkHttpMethod.POST.name(), SESSIONS_URI, request, x509CertificateChain);
            String signingAlgorithm = AwsX509SigningHelper.resolveAwsAlgorithm(requesterDetails.getPrivateKey());
            String contentToSign = AwsX509SigningHelper.contentToSign(instant, awsRegion, signingAlgorithm, canonicalRequest);
            HttpExecuteResponse requestSpec = AwsX509SigningHelper.executeHttpRequest(instant, sessionsRequest, sdkHttpClient, requesterDetails, contentToSign, signingAlgorithm);
            log.debug("Status Code is {} for AWS roles anywhere session endpoint", (Object)requestSpec.httpResponse().statusCode());
            return AwsX509SigningHelper.getAwsRolesAnywhereSessionsResponse(om, requestSpec);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException | IamException e) {
            throw IamException.builder().message("Error while trying to connect to AWS ROLES ANYWHERE").build();
        }
    }

    private static AwsRolesAnywhereSessionsResponse getAwsRolesAnywhereSessionsResponse(ObjectMapper om, HttpExecuteResponse requestSpec) throws IOException {
        if (requestSpec.httpResponse().statusCode() == 201 && requestSpec.responseBody().isPresent()) {
            AbortableInputStream content = (AbortableInputStream)requestSpec.responseBody().get();
            String responseBody = IoUtils.toUtf8String((InputStream)content);
            log.info("Response Body from AWS roles anywhere sessions endpoint: {}", (Object)responseBody);
            return (AwsRolesAnywhereSessionsResponse)om.readValue(responseBody, AwsRolesAnywhereSessionsResponse.class);
        }
        log.error("failed response for the AWS ROLES ANYWHERE SESSION endpoint");
        throw IamException.builder().message("failed response for the AWS ROLES ANYWHERE SESSION endpoint").build();
    }

    public static String resolveUri(Region region) {
        return AwsX509SigningHelper.resolveHostEndpoint(region) + SESSIONS_URI;
    }

    private static HttpExecuteResponse executeHttpRequest(Instant instant, AwsRolesAnywhereSessionsRequest sessionsRequest, SdkHttpClient sdkHttpClient, AwsRolesAnyWhereRequesterDetails requesterDetails, String contentToSign, String signingAlgorithm) throws IOException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        String authHeader;
        String jsonBody = OBJECT_MAPPER.writeValueAsString((Object)sessionsRequest);
        ByteArrayInputStream requestBodyStream = new ByteArrayInputStream(jsonBody.getBytes(StandardCharsets.UTF_8));
        Region awsRegion = requesterDetails.getRegion();
        SdkHttpFullRequest.Builder sdkHttpFullRequestBuilder = (SdkHttpFullRequest.Builder)SdkHttpFullRequest.builder().uri(AwsX509SigningHelper.resolveUri(awsRegion)).method(SdkHttpMethod.POST).putHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType()).putHeader(X_AMZ_X509, CertAndKeyParserAndLoader.convertToBase64PEMString(requesterDetails.getCertificateChain().getLeafCertificate())).putHeader("X-Amz-Date", AwsX509SigningHelper.getDateAndTime(instant));
        X509Certificate cert = requesterDetails.getCertificateChain().getLeafCertificate();
        PrivateKey key = requesterDetails.getPrivateKey();
        if (requesterDetails.getCertificateChain().getIntermediateCACertificate() != null) {
            authHeader = AwsX509SigningHelper.awsSignedAuthHeader(instant, requesterDetails.getRegion(), contentToSign, signingAlgorithm, AwsX509SigningHelper.signedHeadersWithChain(), cert, key);
            sdkHttpFullRequestBuilder.putHeader(X_AMZ_X509_CHAIN, CertAndKeyParserAndLoader.convertToBase64PEMString(requesterDetails.getCertificateChain().getIntermediateCACertificate())).putHeader("Authorization", authHeader);
        } else {
            authHeader = AwsX509SigningHelper.awsSignedAuthHeader(instant, requesterDetails.getRegion(), contentToSign, signingAlgorithm, AwsX509SigningHelper.signedHeaders(), cert, key);
            sdkHttpFullRequestBuilder.putHeader("Authorization", authHeader);
        }
        HttpExecuteRequest request = HttpExecuteRequest.builder().request((SdkHttpRequest)sdkHttpFullRequestBuilder.build()).contentStreamProvider(() -> requestBodyStream).build();
        HttpExecuteResponse requestSpec = sdkHttpClient.prepareRequest(request).call();
        log.debug("authHeader: {}", (Object)authHeader);
        return requestSpec;
    }
}

