/*
 * Decompiled with CFR 0.152.
 */
package in.neuw.aws.rolesanywhere.utils;

import in.neuw.aws.rolesanywhere.credentials.models.X509CertificateChain;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.utils.StringUtils;

public class CertAndKeyParserAndLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertAndKeyParserAndLoader.class);
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String EC_OID = "1.2.840.10045.2.1";
    public static final String RSA_OID = "1.2.840.113549.1.1.1";
    public static final String EC = "EC";
    public static final String RSA = "RSA";
    public static final String SHA256_RSA = "SHA256withRSA";
    public static final String SHA256_EC_DSA = "SHA256withECDSA";

    private CertAndKeyParserAndLoader() {
    }

    public static X509Certificate extractCertificate(String base64EncodedCert) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            byte[] decodedCertificate = Base64.getDecoder().decode(base64EncodedCert);
            X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(decodedCertificate));
            log.info("Certificate expires at {}", (Object)cert.getNotAfter());
            return cert;
        }
        catch (CertificateException e) {
            log.error("Error while extracting certificate, {}", (Object)e.getMessage());
            throw SdkException.builder().message("Error while extracting certificate").cause((Throwable)e).build();
        }
    }

    public static List<X509Certificate> extractCertificates(String base64EncodedCert) throws CertificateException, NoSuchProviderException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.getDecoder().decode(base64EncodedCert));
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        for (Certificate certificate : cf.generateCertificates(inputStream)) {
            certificates.add((X509Certificate)certificate);
        }
        return certificates;
    }

    public static boolean possibleChainOfCerts(String base64EncodedCert) {
        String rawCertFile = new String(Base64.getDecoder().decode(base64EncodedCert));
        if (CertAndKeyParserAndLoader.countOccurrencesOfBEGINCERT(rawCertFile) != 1) {
            if (CertAndKeyParserAndLoader.countOccurrencesOfBEGINCERT(rawCertFile) > 1) {
                log.info("possible chain of certificates");
                return true;
            }
            log.error("cert not provided correctly");
            throw SdkException.builder().message("cert not provided correctly").build();
        }
        log.info("only one cert provided");
        return false;
    }

    public static X509CertificateChain resolveCertificateChain(String base64EncodedCert) throws CertificateException, NoSuchProviderException {
        X509CertificateChain x509CertificateChain = new X509CertificateChain();
        x509CertificateChain.setBase64EncodedCertificate(base64EncodedCert);
        if (CertAndKeyParserAndLoader.possibleChainOfCerts(base64EncodedCert)) {
            List<X509Certificate> certs = CertAndKeyParserAndLoader.extractCertificates(base64EncodedCert);
            for (X509Certificate cert : certs) {
                if (CertAndKeyParserAndLoader.isRootCA(cert)) {
                    log.info("root CA expires at, {}", (Object)cert.getNotAfter());
                    x509CertificateChain.setRootCACertificate(cert);
                    continue;
                }
                if (CertAndKeyParserAndLoader.ifX509CertIsCA(cert)) {
                    log.info("intermediate CA expires at, {}", (Object)cert.getNotAfter());
                    x509CertificateChain.setIntermediateCACertificate(cert);
                    continue;
                }
                log.info("leaf cert expires at, {}", (Object)cert.getNotAfter());
                x509CertificateChain.setLeafCertificate(cert);
            }
        } else {
            x509CertificateChain.setLeafCertificate(CertAndKeyParserAndLoader.extractCertificate(base64EncodedCert));
        }
        return x509CertificateChain;
    }

    public static String convertToBase64PEMString(X509Certificate x509Cert) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        StringWriter sw = new StringWriter();
        try (JcaPEMWriter pw = new JcaPEMWriter((Writer)sw);){
            pw.writeObject((Object)x509Cert);
        }
        catch (IOException e) {
            throw SdkException.builder().cause((Throwable)e).build();
        }
        return Base64.getEncoder().encodeToString(sw.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static PrivateKey extractPrivateKey(String base64EncodedPrivateKey) {
        byte[] privateKeyBytes = Base64.getDecoder().decode(base64EncodedPrivateKey);
        try {
            return CertAndKeyParserAndLoader.privateKeyResolver(privateKeyBytes);
        }
        catch (IOException | NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            throw SdkException.builder().cause((Throwable)e).build();
        }
    }

    public static String resolveSignatureAlgorithm(PrivateKey key) {
        if (RSA.equals(key.getAlgorithm())) {
            return SHA256_RSA;
        }
        if (EC.equals(key.getAlgorithm())) {
            return SHA256_EC_DSA;
        }
        throw new IllegalArgumentException("key algorithm not recognized");
    }

    public static String resolveAndValidateAlgorithm(PrivateKey key) {
        if (EC.equals(key.getAlgorithm()) || RSA.equals(key.getAlgorithm())) {
            return key.getAlgorithm();
        }
        throw new IllegalArgumentException("key algorithm not recognized");
    }

    public static String resolveKeyType(ASN1ObjectIdentifier algorithm) {
        String keyType;
        if (algorithm.equals((ASN1Primitive)new ASN1ObjectIdentifier(RSA_OID))) {
            log.info("The key is an RSA private key.");
            keyType = RSA;
        } else if (algorithm.equals((ASN1Primitive)new ASN1ObjectIdentifier(EC_OID))) {
            log.info("The key is an EC private key.");
            keyType = EC;
        } else {
            throw new IllegalArgumentException("Unsupported key algorithm: " + String.valueOf(algorithm));
        }
        return keyType;
    }

    public static PrivateKey privateKeyResolver(byte[] key) throws InvalidKeySpecException, IOException, NoSuchAlgorithmException, NoSuchProviderException {
        PrivateKeyInfo privateKeyInfo;
        String originalFormat;
        Security.addProvider((Provider)new BouncyCastleProvider());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(key);
        PEMParser pemParser = new PEMParser((Reader)new InputStreamReader(byteArrayInputStream));
        Object inputPemObject = pemParser.readObject();
        if (inputPemObject instanceof PEMKeyPair) {
            PEMKeyPair keyPair = (PEMKeyPair)inputPemObject;
            originalFormat = "PKCS#1";
            privateKeyInfo = keyPair.getPrivateKeyInfo();
            log.info("Private key Input format: PKCS#1 (Traditional format)");
        } else if (inputPemObject instanceof PrivateKeyInfo) {
            PrivateKeyInfo instancePrivateKeyInfo = (PrivateKeyInfo)inputPemObject;
            originalFormat = "PKCS#8";
            privateKeyInfo = instancePrivateKeyInfo;
            log.info("Private key Input format: PKCS#8 (Modern format)");
        } else {
            throw new IllegalArgumentException("Unsupported key format: " + inputPemObject.getClass().getName() + ". Supported formats: PKCS#1 (RSA/EC PRIVATE KEY) and PKCS#8 (PRIVATE KEY)");
        }
        byte[] encodedKey = privateKeyInfo.getEncoded();
        ASN1ObjectIdentifier algorithm = privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm();
        String keyType = CertAndKeyParserAndLoader.resolveKeyType(algorithm);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedKey);
        KeyFactory keyFactory = KeyFactory.getInstance(keyType, "BC");
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        log.info("Private key successfully loaded. Original format: {}, Private key algorithm: {}, internal format: {}", new Object[]{originalFormat, privateKey.getAlgorithm(), privateKey.getFormat()});
        return privateKey;
    }

    public static boolean ifX509CertIsCA(X509Certificate cert) {
        return cert.getBasicConstraints() != -1 && cert.getKeyUsage()[5];
    }

    public static boolean isRootCA(X509Certificate cert) {
        try {
            cert.verify(cert.getPublicKey());
            log.info("this is root CA");
            return true;
        }
        catch (InvalidKeyException e) {
            log.error("this is not root CA, invalid key");
        }
        catch (SignatureException e) {
            log.warn("the cert with name = {} is not Root CA signature issue", (Object)cert.getSubjectX500Principal().getName());
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
            log.error("this is not Root CA, exception", e.getCause());
        }
        return false;
    }

    private static int countOccurrencesOfBEGINCERT(String str) {
        int idx;
        if (StringUtils.isBlank((CharSequence)str)) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        while ((idx = str.indexOf(BEGIN_CERT, pos)) != -1) {
            ++count;
            pos = idx + BEGIN_CERT.length();
        }
        return count;
    }
}

