/*
 * Decompiled with CFR 0.152.
 */
package com.olx.assertx.context;

import com.olx.assertx.service.model.RequestKey;
import com.olx.assertx.service.model.RequestType;
import io.restassured.common.mapper.TypeRef;
import io.restassured.response.Response;
import io.restassured.response.ResponseBody;
import java.util.HashMap;
import java.util.Map;

public enum CucumberTestContext {
    CONTEXT;

    private final ThreadLocal<Map<String, Object>> threadLocal = ThreadLocal.withInitial(HashMap::new);

    private Map<String, Object> testContextMap() {
        return this.threadLocal.get();
    }

    public boolean contains(String key) {
        return this.testContextMap().containsKey(key);
    }

    public void set(String key, Object value) {
        this.testContextMap().put(key, value);
    }

    public Object get(String key) {
        return this.testContextMap().get(key);
    }

    public <T> T get(String key, Class<T> clazz) {
        return clazz.cast(this.testContextMap().get(key));
    }

    public void remove(String key) {
        this.testContextMap().remove(key);
    }

    public <T> T getResponse(RequestType type, Class<T> clazz) {
        if (type.equals((Object)RequestType.REST)) {
            return (T)this.fetchResponseBody().as(clazz);
        }
        return null;
    }

    public <T> T getResponse(RequestType type, TypeRef<T> typeRef) {
        if (type.equals((Object)RequestType.REST)) {
            return (T)this.fetchResponseBody().as(typeRef);
        }
        return null;
    }

    private ResponseBody fetchResponseBody() {
        return ((Response)this.testContextMap().get(RequestKey.RESPONSE.toName())).body();
    }
}

