/*
 * Decompiled with CFR 0.152.
 */
package com.olx.assertx.mocks;

import com.olx.assertx.configuration.UserMocksConfiguration;
import com.olx.assertx.mocks.model.BaseService;
import com.olx.assertx.mocks.model.Services;
import com.olx.assertx.utils.PortManager;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface BaseCustomMock {
    public static final Logger LOGGER = LoggerFactory.getLogger(BaseCustomMock.class);

    default public void build(UserMocksConfiguration userMocksConfiguration, Services services) throws IOException {
        if (this.isEnabled()) {
            LOGGER.info("Building {} custom mock", (Object)this.getServiceName());
            this.configure(userMocksConfiguration);
            services.setDynamicAttribute(this.getServiceName(), this.map(PortManager.getInstance().getServicePort(this.getServiceName())));
        }
    }

    default public void configure(UserMocksConfiguration userMocksConfiguration) {
        LOGGER.info("Configure proxy ports for mock={}", (Object)this.getServiceName());
        PortManager.getInstance().addServicePort(this.getServiceName(), this.getServicePort());
        if (userMocksConfiguration.getToxiproxy().isEnabled()) {
            PortManager.getInstance().addProxyPort(this.getServiceName());
        }
    }

    public boolean isEnabled();

    public BaseService map(int var1);

    public String getServiceName();

    public int getServicePort();
}

