/*
 * Decompiled with CFR 0.152.
 */
package com.olx.assertx.mocks;

import com.olx.assertx.configuration.GlobalMocksConfiguration;
import com.olx.assertx.configuration.RouteConfiguration;
import com.olx.assertx.configuration.UserMocksConfiguration;
import com.olx.assertx.mocks.model.MockType;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface BaseJSMock {
    public static final Logger LOGGER = LoggerFactory.getLogger(BaseJSMock.class);
    public static final String TEMPLATE_SERVICE_DEFINITION = "var %s = require('%s');";
    public static final String TEMPLATE_PATH_DEFINITION = "app.%s('%s', %s.%s);";

    default public void configure(RouteConfiguration routeConfiguration, StringBuilder serviceDefinitions, StringBuilder pathDefinitions, String serviceType) {
        LOGGER.info("Configure route of type={} and service={}", (Object)routeConfiguration.getType(), (Object)serviceType);
        String serviceId = routeConfiguration.getType() + StringUtils.capitalize((String)serviceType.split("-")[0]);
        serviceDefinitions.append(String.format(TEMPLATE_SERVICE_DEFINITION, serviceId, "./" + serviceType + "/" + routeConfiguration.getFolderName() + "/" + routeConfiguration.getType())).append("\n");
        routeConfiguration.getEndpoints().forEach(endpointConfiguration -> pathDefinitions.append(String.format(TEMPLATE_PATH_DEFINITION, endpointConfiguration.getMethodType().toString(), endpointConfiguration.getPath(), serviceId, endpointConfiguration.getMethod())).append("\n"));
    }

    default public void build(GlobalMocksConfiguration globalMocksConfiguration, UserMocksConfiguration userMocksConfiguration, StringBuilder serviceDefinitions, StringBuilder pathDefinitions) throws IOException {
        LOGGER.info("Build all JS mock routes");
        for (RouteConfiguration routeConfiguration : this.getRouteConfigurations(globalMocksConfiguration, userMocksConfiguration)) {
            this.configure(routeConfiguration, serviceDefinitions, pathDefinitions, this.getMockType().getServiceName());
            this.load(routeConfiguration);
        }
    }

    public void load(RouteConfiguration var1) throws IOException;

    public List<RouteConfiguration> getRouteConfigurations(GlobalMocksConfiguration var1, UserMocksConfiguration var2);

    public MockType getMockType();
}

