/*
 * Decompiled with CFR 0.152.
 */
package com.olx.assertx.mocks;

import com.olx.assertx.configuration.FrameworkConfiguration;
import com.olx.assertx.configuration.GlobalMocksConfiguration;
import com.olx.assertx.configuration.UserMocksConfiguration;
import com.olx.assertx.mocks.model.BaseService;
import com.olx.assertx.mocks.model.MockType;
import com.olx.assertx.mocks.model.Services;
import com.olx.assertx.utils.FileUtility;
import com.olx.assertx.utils.PortManager;
import java.io.IOException;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface BaseMock {
    public static final Logger LOGGER = LoggerFactory.getLogger(BaseMock.class);
    public static final String PORT_MAPPING_FORMAT = "%s:%s";
    public static final String ENV_FORMAT = "%s=%s";
    public static final String DOCKER_FILENAME = "Dockerfile";
    public static final String DOCKERFILE_TEMPLATE_PATH_FORMAT = "mocks/%s/template/Dockerfile";
    public static final String TARGET_DOCKERFILE_PATH_FORMAT = "it/mocks/%s";
    public static final String DOCKERFILE_PORT_PLACEHOLDER = "${DYNAMIC_PORT}";

    default public void configureAndLoadDockerFile() throws IOException {
        int port = PortManager.getInstance().getServicePort(this.getMockType().getServiceName());
        LOGGER.info("Configure and load docker file for mock={} on port={}", (Object)this.getMockType(), (Object)port);
        FileUtility.generateFileFromTemplate(String.format(DOCKERFILE_TEMPLATE_PATH_FORMAT, this.getMockType().getServiceName()), String.format(TARGET_DOCKERFILE_PATH_FORMAT, this.getMockType().getServiceName()), DOCKER_FILENAME, Collections.singletonMap(DOCKERFILE_PORT_PLACEHOLDER, String.valueOf(port)));
    }

    default public void build(FrameworkConfiguration frameworkConfiguration, UserMocksConfiguration userMocksConfiguration, Services services) throws IOException {
        if (this.isEnabled(userMocksConfiguration)) {
            LOGGER.info("Building {} mock", (Object)this.getMockType());
            this.configure(frameworkConfiguration, userMocksConfiguration);
            this.copyStartupFiles(frameworkConfiguration.getGlobalMocks(), userMocksConfiguration);
            services.setDynamicAttribute(this.getMockType().getServiceName(), this.map(frameworkConfiguration, userMocksConfiguration, this.getMockType().getServiceName()));
        }
    }

    default public void configure(FrameworkConfiguration frameworkConfiguration, UserMocksConfiguration userMocksConfiguration) {
        LOGGER.info("Configure proxy ports for mock={}", (Object)this.getMockType());
        PortManager.getInstance().addServicePort(this.getMockType().getServiceName(), this.getServicePort(frameworkConfiguration, userMocksConfiguration));
        this.addCustomServicePorts(frameworkConfiguration, userMocksConfiguration);
        if (userMocksConfiguration.getToxiproxy().isEnabled() && this.getMockType() != MockType.TOXIPROXY) {
            PortManager.getInstance().addProxyPort(this.getMockType().getServiceName());
            this.addCustomProxyPorts(userMocksConfiguration);
        }
    }

    default public void addCustomServicePorts(FrameworkConfiguration frameworkConfiguration, UserMocksConfiguration userMocksConfiguration) {
    }

    default public void addCustomProxyPorts(UserMocksConfiguration userMocksConfiguration) {
    }

    public boolean isEnabled(UserMocksConfiguration var1);

    public BaseService map(FrameworkConfiguration var1, UserMocksConfiguration var2, String var3);

    public MockType getMockType();

    public String getDockerImage(FrameworkConfiguration var1, UserMocksConfiguration var2);

    public int getServicePort(FrameworkConfiguration var1, UserMocksConfiguration var2);

    public void copyStartupFiles(GlobalMocksConfiguration var1, UserMocksConfiguration var2) throws IOException;
}

