/*
 * Decompiled with CFR 0.152.
 */
package com.olx.assertx.mocks;

import com.olx.assertx.configuration.GlobalMocksConfiguration;
import com.olx.assertx.configuration.RouteConfiguration;
import com.olx.assertx.configuration.UserMocksConfiguration;
import com.olx.assertx.mocks.BaseJSMock;
import com.olx.assertx.mocks.ExternalServicesMock;
import com.olx.assertx.mocks.model.MockType;
import com.olx.assertx.utils.FileUtility;
import com.olx.assertx.utils.Paths;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalMock
extends ExternalServicesMock
implements BaseJSMock {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalMock.class);

    @Override
    public MockType getMockType() {
        return MockType.GLOBAL;
    }

    @Override
    public void load(RouteConfiguration routeConfiguration) throws IOException {
        String destPath = Paths.ES_FOLDER + "/" + this.getMockType().getServiceName() + "/" + routeConfiguration.getFolderName();
        LOGGER.info("Load route={} for mock={} at path={}", new Object[]{routeConfiguration.getType(), this.getMockType(), destPath});
        FileUtility.copyJarDir(routeConfiguration.getResourcePath() + "/" + routeConfiguration.getFolderName(), destPath, routeConfiguration.getFileNames());
    }

    @Override
    public List<RouteConfiguration> getRouteConfigurations(GlobalMocksConfiguration globalMocksConfiguration, UserMocksConfiguration userMocksConfiguration) {
        LOGGER.info("Get route configurations for mock={}", (Object)this.getMockType());
        Map<String, RouteConfiguration> globalServiceRoutes = this.loadRoutes(globalMocksConfiguration.getRoutes());
        ArrayList<RouteConfiguration> routeConfigurations = new ArrayList<RouteConfiguration>();
        for (String route : userMocksConfiguration.getExternalServices().getGlobal()) {
            if (!globalServiceRoutes.containsKey(route)) continue;
            routeConfigurations.add(globalServiceRoutes.get(route));
        }
        return routeConfigurations;
    }

    private Map<String, RouteConfiguration> loadRoutes(List<RouteConfiguration> routeConfigurationList) {
        HashMap<String, RouteConfiguration> routesMap = new HashMap<String, RouteConfiguration>();
        for (RouteConfiguration route : routeConfigurationList) {
            routesMap.put(route.getType(), route);
        }
        return routesMap;
    }
}

