/*
 * Decompiled with CFR 0.152.
 */
package com.olx.assertx.mocks;

import com.olx.assertx.configuration.FrameworkConfiguration;
import com.olx.assertx.configuration.GlobalMocksConfiguration;
import com.olx.assertx.configuration.UserMocksConfiguration;
import com.olx.assertx.mocks.BaseMock;
import com.olx.assertx.mocks.model.LocalStack;
import com.olx.assertx.mocks.model.MockType;
import com.olx.assertx.utils.FileUtility;
import com.olx.assertx.utils.PortManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalStackMock
implements BaseMock {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalStackMock.class);
    private static final String VOLUME_DATA_PATH_FORMAT = "./%s/data:/%s";
    private static final String DATA_FILE_FORMAT = "docker-entrypoint-initaws.d";
    private static final String DEFAULT_HOSTNAME = "0.0.0.0";

    @Override
    public boolean isEnabled(UserMocksConfiguration userMocksConfiguration) {
        return userMocksConfiguration.getLocalstack().isEnabled();
    }

    @Override
    public LocalStack map(FrameworkConfiguration frameworkConfiguration, UserMocksConfiguration userMocksConfiguration, String serviceName) {
        int port = PortManager.getInstance().getServicePort(serviceName);
        LOGGER.info("Map {} mock on port={}", (Object)this.getMockType(), (Object)port);
        return LocalStack.builder().image(this.getDockerImage(frameworkConfiguration, userMocksConfiguration)).containerName(serviceName).environment(Arrays.asList(String.format("%s=%s", "SERVICES", this.getAWSServices(frameworkConfiguration, userMocksConfiguration)), String.format("%s=%s", "DEFAULT_REGION", this.getAWSRegion(frameworkConfiguration, userMocksConfiguration)), String.format("%s=%s", "HOSTNAME", DEFAULT_HOSTNAME))).volumes(this.getVolumes(userMocksConfiguration)).ports(Arrays.asList(String.format("%s:%s", port, port))).build();
    }

    @Override
    public MockType getMockType() {
        return MockType.LOCALSTACK;
    }

    @Override
    public String getDockerImage(FrameworkConfiguration frameworkConfiguration, UserMocksConfiguration userMocksConfiguration) {
        if (userMocksConfiguration.getLocalstack().getImage() != null) {
            return userMocksConfiguration.getLocalstack().getImage();
        }
        return frameworkConfiguration.getServiceDefaults().getLocalstack().getImage();
    }

    @Override
    public int getServicePort(FrameworkConfiguration frameworkConfiguration, UserMocksConfiguration userMocksConfiguration) {
        if (userMocksConfiguration.getLocalstack().getPort() > 0) {
            return userMocksConfiguration.getLocalstack().getPort();
        }
        return frameworkConfiguration.getServiceDefaults().getLocalstack().getPort();
    }

    @Override
    public void copyStartupFiles(GlobalMocksConfiguration globalMocksConfiguration, UserMocksConfiguration userMocksConfiguration) throws IOException {
        LOGGER.info("Copy startup files for mock={}", (Object)this.getMockType());
        if (!StringUtils.isEmpty((CharSequence)userMocksConfiguration.getLocalstack().getDataDir())) {
            FileUtility.copyDir(userMocksConfiguration.getLocalstack().getDataDir(), String.format("it/mocks/%s", this.getMockType().getServiceName()) + "/data");
        }
    }

    private String getAWSServices(FrameworkConfiguration frameworkConfiguration, UserMocksConfiguration userMocksConfiguration) {
        if (!userMocksConfiguration.getLocalstack().getServices().isEmpty()) {
            return StringUtils.join(userMocksConfiguration.getLocalstack().getServices(), (String)",");
        }
        return StringUtils.join(frameworkConfiguration.getServiceDefaults().getLocalstack().getServices(), (String)",");
    }

    private String getAWSRegion(FrameworkConfiguration frameworkConfiguration, UserMocksConfiguration userMocksConfiguration) {
        if (StringUtils.isNotBlank((CharSequence)userMocksConfiguration.getLocalstack().getRegion())) {
            return userMocksConfiguration.getLocalstack().getRegion();
        }
        return frameworkConfiguration.getServiceDefaults().getLocalstack().getRegion();
    }

    private List<String> getVolumes(UserMocksConfiguration userMocksConfiguration) {
        ArrayList<String> volumes = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)userMocksConfiguration.getLocalstack().getDataDir())) {
            volumes.add(String.format(VOLUME_DATA_PATH_FORMAT, this.getMockType().getServiceName(), DATA_FILE_FORMAT));
        }
        return volumes;
    }
}

