/*
 * Decompiled with CFR 0.152.
 */
package com.olx.assertx.mocks;

import com.olx.assertx.configuration.FrameworkConfiguration;
import com.olx.assertx.configuration.GlobalMocksConfiguration;
import com.olx.assertx.configuration.UserMocksConfiguration;
import com.olx.assertx.mocks.BaseMock;
import com.olx.assertx.mocks.model.BaseService;
import com.olx.assertx.mocks.model.Healthcheck;
import com.olx.assertx.mocks.model.MockType;
import com.olx.assertx.mocks.model.Mysql;
import com.olx.assertx.mocks.model.Networks;
import com.olx.assertx.mocks.model.Service1Net;
import com.olx.assertx.utils.FileUtility;
import com.olx.assertx.utils.PortManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlMock
implements BaseMock {
    private static final Logger LOGGER = LoggerFactory.getLogger(MysqlMock.class);
    private static final String VOLUME_DATA_PATH_FORMAT = "./%s/data:/%s";
    private static final String DATA_FILE_FORMAT = "docker-entrypoint-initdb.d";
    private static final String DEFAULT_DB_NAME = "test";
    private static final String DEFAULT_DB_PASS = "1234";

    @Override
    public boolean isEnabled(UserMocksConfiguration userMocksConfiguration) {
        return userMocksConfiguration.getMysql().isEnabled();
    }

    @Override
    public BaseService map(FrameworkConfiguration frameworkConfiguration, UserMocksConfiguration userMocksConfiguration, String serviceName) {
        int port = PortManager.getInstance().getServicePort(serviceName);
        LOGGER.info("Map {} mock on port={}", (Object)this.getMockType(), (Object)port);
        String database = StringUtils.isEmpty((CharSequence)userMocksConfiguration.getMysql().getDb()) ? DEFAULT_DB_NAME : userMocksConfiguration.getMysql().getDb();
        ArrayList<String> volumes = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)userMocksConfiguration.getMysql().getDataDir())) {
            volumes.add(String.format(VOLUME_DATA_PATH_FORMAT, this.getMockType().getServiceName(), DATA_FILE_FORMAT));
        }
        return Mysql.builder().image(this.getDockerImage(frameworkConfiguration, userMocksConfiguration)).containerName(serviceName).environment(Arrays.asList(String.format("%s=%s", "MYSQL_DATABASE", database), String.format("%s=%s", "MYSQL_ROOT_PASSWORD", DEFAULT_DB_PASS), String.format("%s=%s", "MYSQL_TCP_PORT", port))).ports(Collections.singletonList(String.format("%s:%s", port, port))).networks(Networks.builder().service1NetName(Service1Net.builder().build()).build()).volumes(volumes).healthcheck(Healthcheck.builder().test(List.of("CMD", "mysqladmin", "ping", "-h", "localhost")).interval("2s").retries(10).timeout("20s").build()).build();
    }

    @Override
    public MockType getMockType() {
        return MockType.MYSQL;
    }

    @Override
    public String getDockerImage(FrameworkConfiguration frameworkConfiguration, UserMocksConfiguration userMocksConfiguration) {
        if (userMocksConfiguration.getMysql().getImage() != null) {
            return userMocksConfiguration.getMysql().getImage();
        }
        return frameworkConfiguration.getServiceDefaults().getMysql().getImage();
    }

    @Override
    public int getServicePort(FrameworkConfiguration frameworkConfiguration, UserMocksConfiguration userMocksConfiguration) {
        if (userMocksConfiguration.getMysql().getPort() > 0) {
            return userMocksConfiguration.getMysql().getPort();
        }
        return frameworkConfiguration.getServiceDefaults().getMysql().getPort();
    }

    @Override
    public void copyStartupFiles(GlobalMocksConfiguration globalMocksConfiguration, UserMocksConfiguration userMocksConfiguration) throws IOException {
        LOGGER.info("Copy startup files for mock={}", (Object)this.getMockType());
        if (!StringUtils.isEmpty((CharSequence)userMocksConfiguration.getMysql().getDataDir())) {
            FileUtility.copyDir(userMocksConfiguration.getMysql().getDataDir(), String.format("it/mocks/%s", this.getMockType().getServiceName()) + "/data");
        }
    }
}

