/*
 * Decompiled with CFR 0.152.
 */
package com.olx.assertx.mocks;

import com.olx.assertx.configuration.FrameworkConfiguration;
import com.olx.assertx.configuration.GlobalMocksConfiguration;
import com.olx.assertx.configuration.UserMocksConfiguration;
import com.olx.assertx.configuration.VolumeConfiguration;
import com.olx.assertx.mocks.BaseMock;
import com.olx.assertx.mocks.model.BaseService;
import com.olx.assertx.mocks.model.Healthcheck;
import com.olx.assertx.mocks.model.MockType;
import com.olx.assertx.mocks.model.Networks;
import com.olx.assertx.mocks.model.OpenSearch;
import com.olx.assertx.mocks.model.Service1Net;
import com.olx.assertx.utils.FileUtility;
import com.olx.assertx.utils.PortManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class OpenSearchMock
implements BaseMock {
    @Override
    public boolean isEnabled(UserMocksConfiguration userMocksConfiguration) {
        return userMocksConfiguration.getOpensearch().isEnabled();
    }

    @Override
    public BaseService map(FrameworkConfiguration frameworkConfiguration, UserMocksConfiguration userMocksConfiguration, String serviceName) {
        int port = PortManager.getInstance().getServicePort(serviceName);
        LOGGER.info("Map {} mock on port={}", (Object)this.getMockType(), (Object)port);
        ArrayList<String> volumes = new ArrayList<String>();
        for (VolumeConfiguration volumeConfig : userMocksConfiguration.getOpensearch().getVolumes()) {
            String srcPath = "./" + this.getMockType().getServiceName() + "/" + volumeConfig.getDestFolder();
            String destPath = volumeConfig.getDestPath() + "/" + volumeConfig.getDestFolder();
            volumes.add(srcPath + ":" + destPath);
        }
        ArrayList<String> ports = new ArrayList<String>();
        ports.add(port + ":" + port);
        for (Integer extraPort : userMocksConfiguration.getOpensearch().getExtraPorts()) {
            ports.add(extraPort + ":" + extraPort);
        }
        return OpenSearch.builder().image(this.getDockerImage(frameworkConfiguration, userMocksConfiguration)).containerName(serviceName).ports(ports).networks(Networks.builder().service1NetName(Service1Net.builder().build()).build()).environment(List.of("discovery.type=single-node", "bootstrap.memory_lock=true", "OPENSEARCH_JAVA_OPTS=-Xms512m -Xmx512m", "DISABLE_INSTALL_DEMO_CONFIG=true", "DISABLE_SECURITY_PLUGIN=true")).volumes(volumes).healthcheck(Healthcheck.builder().test(List.of("CMD-SHELL", "curl -f -X GET 'localhost:" + port + "/_cluster/health?wait_for_status=green&timeout=1s' || exit 1")).interval("10s").timeout("5s").retries(3).build()).build();
    }

    @Override
    public MockType getMockType() {
        return MockType.OPENSEARCH;
    }

    @Override
    public String getDockerImage(FrameworkConfiguration frameworkConfiguration, UserMocksConfiguration userMocksConfiguration) {
        if (userMocksConfiguration.getOpensearch().getImage() != null) {
            return userMocksConfiguration.getOpensearch().getImage();
        }
        return frameworkConfiguration.getServiceDefaults().getOpensearch().getImage();
    }

    @Override
    public int getServicePort(FrameworkConfiguration frameworkConfiguration, UserMocksConfiguration userMocksConfiguration) {
        if (userMocksConfiguration.getOpensearch().getPort() > 0) {
            return userMocksConfiguration.getOpensearch().getPort();
        }
        return frameworkConfiguration.getServiceDefaults().getOpensearch().getPort();
    }

    @Override
    public void copyStartupFiles(GlobalMocksConfiguration globalMocksConfiguration, UserMocksConfiguration userMocksConfiguration) throws IOException {
        LOGGER.info("Copy startup files for mock={}", (Object)this.getMockType().getServiceName());
        for (VolumeConfiguration volumeConfig : userMocksConfiguration.getOpensearch().getVolumes()) {
            String srcPath = volumeConfig.getSrcPath();
            String destPath = "it/mocks/" + this.getMockType().getServiceName() + "/" + volumeConfig.getDestFolder();
            if (StringUtils.isEmpty((CharSequence)srcPath)) continue;
            FileUtility.copyDir(srcPath, destPath);
        }
    }
}

