/*
 * Decompiled with CFR 0.152.
 */
package com.olx.assertx.mocks;

import com.olx.assertx.configuration.FrameworkConfiguration;
import com.olx.assertx.configuration.GlobalMocksConfiguration;
import com.olx.assertx.configuration.UserMocksConfiguration;
import com.olx.assertx.mocks.BaseMock;
import com.olx.assertx.mocks.model.BaseService;
import com.olx.assertx.mocks.model.Healthcheck;
import com.olx.assertx.mocks.model.MockType;
import com.olx.assertx.mocks.model.Networks;
import com.olx.assertx.mocks.model.PostgreSql;
import com.olx.assertx.mocks.model.Service1Net;
import com.olx.assertx.utils.FileUtility;
import com.olx.assertx.utils.PortManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSqlMock
implements BaseMock {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgreSqlMock.class);
    private static final String VOLUME_DATA_PATH_FORMAT = "./%s/data:/%s";
    private static final String DATA_FILE_FORMAT = "docker-entrypoint-initdb.d";
    private static final String DEFAULT_DB_NAME = "test";
    private static final String DEFAULT_DB_USER = "postgres";
    private static final String DEFAULT_DB_PASS = "postgres";

    @Override
    public boolean isEnabled(UserMocksConfiguration userMocksConfiguration) {
        return userMocksConfiguration.getPostgresql().isEnabled();
    }

    @Override
    public BaseService map(FrameworkConfiguration frameworkConfiguration, UserMocksConfiguration userMocksConfiguration, String serviceName) {
        int port = PortManager.getInstance().getServicePort(serviceName);
        LOGGER.info("Map {} mock on port={}", (Object)this.getMockType(), (Object)port);
        ArrayList<String> volumes = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)userMocksConfiguration.getPostgresql().getDataDir())) {
            volumes.add(String.format(VOLUME_DATA_PATH_FORMAT, this.getMockType().getServiceName(), DATA_FILE_FORMAT));
        }
        return PostgreSql.builder().image(this.getDockerImage(frameworkConfiguration, userMocksConfiguration)).containerName(serviceName).environment(Arrays.asList(String.format("%s=%s", "POSTGRES_DB", DEFAULT_DB_NAME), String.format("%s=%s", "POSTGRES_USER", "postgres"), String.format("%s=%s", "POSTGRES_PASSWORD", "postgres"))).ports(Collections.singletonList(String.format("%s:%s", port, frameworkConfiguration.getServiceDefaults().getPostgresql().getPort()))).networks(Networks.builder().service1NetName(Service1Net.builder().build()).build()).volumes(volumes).healthcheck(Healthcheck.builder().test(List.of("CMD", "pg_isready", "-U", "postgres", "-d", DEFAULT_DB_NAME)).interval("2s").retries(10).timeout("20s").build()).build();
    }

    @Override
    public MockType getMockType() {
        return MockType.POSTGRESQL;
    }

    @Override
    public String getDockerImage(FrameworkConfiguration frameworkConfiguration, UserMocksConfiguration userMocksConfiguration) {
        if (userMocksConfiguration.getPostgresql().getImage() != null) {
            return userMocksConfiguration.getPostgresql().getImage();
        }
        return frameworkConfiguration.getServiceDefaults().getPostgresql().getImage();
    }

    @Override
    public int getServicePort(FrameworkConfiguration frameworkConfiguration, UserMocksConfiguration userMocksConfiguration) {
        if (userMocksConfiguration.getPostgresql().getPort() > 0) {
            return userMocksConfiguration.getPostgresql().getPort();
        }
        return frameworkConfiguration.getServiceDefaults().getPostgresql().getPort();
    }

    @Override
    public void copyStartupFiles(GlobalMocksConfiguration globalMocksConfiguration, UserMocksConfiguration userMocksConfiguration) throws IOException {
        LOGGER.info("Copy startup files for mock={}", (Object)this.getMockType());
        if (!StringUtils.isEmpty((CharSequence)userMocksConfiguration.getPostgresql().getDataDir())) {
            FileUtility.copyDir(userMocksConfiguration.getPostgresql().getDataDir(), String.format("it/mocks/%s", this.getMockType().getServiceName()) + "/data");
        }
    }
}

