/*
 * Decompiled with CFR 0.152.
 */
package com.olx.assertx.mocks;

import com.olx.assertx.configuration.FrameworkConfiguration;
import com.olx.assertx.configuration.GlobalMocksConfiguration;
import com.olx.assertx.configuration.RouteConfiguration;
import com.olx.assertx.configuration.UserMocksConfiguration;
import com.olx.assertx.mocks.BaseMock;
import com.olx.assertx.mocks.model.BaseService;
import com.olx.assertx.mocks.model.Healthcheck;
import com.olx.assertx.mocks.model.MockType;
import com.olx.assertx.mocks.model.Networks;
import com.olx.assertx.mocks.model.Service1Net;
import com.olx.assertx.mocks.model.ToxiProxy;
import com.olx.assertx.mocks.model.ToxiProxyConfigurations;
import com.olx.assertx.utils.FileUtility;
import com.olx.assertx.utils.Paths;
import com.olx.assertx.utils.PortManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToxiProxyMock
implements BaseMock {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToxiProxyMock.class);
    private static final String CONFIG_FILE = "config.json";

    @Override
    public boolean isEnabled(UserMocksConfiguration userMocksConfiguration) {
        return userMocksConfiguration.getToxiproxy().isEnabled();
    }

    @Override
    public BaseService map(FrameworkConfiguration frameworkConfiguration, UserMocksConfiguration userMocksConfiguration, String serviceName) {
        int toxiProxyPort = PortManager.getInstance().getServicePort(serviceName);
        LOGGER.info("Map {} mock on port={}", (Object)this.getMockType(), (Object)toxiProxyPort);
        ArrayList<String> allPortMappings = new ArrayList<String>();
        allPortMappings.add(String.format("%s:%s", toxiProxyPort, toxiProxyPort));
        allPortMappings.addAll(this.getExternalServicesPortMappings());
        return ToxiProxy.builder().build(serviceName).containerName(serviceName).restart("always").ports(allPortMappings).networks(Networks.builder().service1NetName(Service1Net.builder().build()).build()).healthcheck(Healthcheck.builder().test(List.of("CMD", "nc", "-vz", "localhost", String.valueOf(toxiProxyPort))).interval("2s").retries(3).timeout("5s").build()).build();
    }

    @Override
    public MockType getMockType() {
        return MockType.TOXIPROXY;
    }

    @Override
    public String getDockerImage(FrameworkConfiguration frameworkConfiguration, UserMocksConfiguration userMocksConfiguration) {
        return null;
    }

    @Override
    public int getServicePort(FrameworkConfiguration frameworkConfiguration, UserMocksConfiguration userMocksConfiguration) {
        if (userMocksConfiguration.getToxiproxy().getPort() > 0) {
            return userMocksConfiguration.getToxiproxy().getPort();
        }
        return frameworkConfiguration.getServiceDefaults().getToxiproxy().getPort();
    }

    @Override
    public void copyStartupFiles(GlobalMocksConfiguration globalMocksConfiguration, UserMocksConfiguration userMocksConfiguration) throws IOException {
        LOGGER.info("Copy startup files for mock={}", (Object)this.getMockType());
        this.configureAndLoadDockerFile();
        LOGGER.info("Build ToxiProxy config={} at path={}", (Object)CONFIG_FILE, (Object)Paths.TOXI_PROXY_FOLDER);
        Set externalServices = userMocksConfiguration.getExternalServices().getUserSpecified().getRoutes().stream().map(RouteConfiguration::getType).collect(Collectors.toSet());
        externalServices.addAll(userMocksConfiguration.getExternalServices().getGlobal());
        List toxiProxyConfig = PortManager.getInstance().getToxiProxyPortMap().keySet().stream().map(service -> ToxiProxyConfigurations.builder().name((String)service).listen(String.format("%s:%s", "0.0.0.0", PortManager.getInstance().getToxiProxyPortMap().get(service))).upstream(externalServices.contains(service) ? String.format("%s:%s", "0.0.0.0", PortManager.getInstance().getToxiProxyPortMap().get(MockType.EXTERNAL_SERVICES.getServiceName())) : String.format("%s:%s", service, PortManager.getInstance().getServicePort((String)service))).build()).collect(Collectors.toList());
        FileUtility.writeFile(Paths.TOXI_PROXY_FOLDER, CONFIG_FILE, toxiProxyConfig);
    }

    private List<String> getExternalServicesPortMappings() {
        LOGGER.info("Get port mappings for all external services");
        return PortManager.getInstance().getToxiProxyPortMap().keySet().stream().map(service -> {
            int proxyPort = PortManager.getInstance().getToxiProxyPortMap().get(service);
            return String.format("%s:%s", proxyPort, proxyPort);
        }).collect(Collectors.toList());
    }
}

