/*
 * Decompiled with CFR 0.152.
 */
package com.olx.assertx.mocks;

import com.olx.assertx.configuration.GlobalMocksConfiguration;
import com.olx.assertx.configuration.RouteConfiguration;
import com.olx.assertx.configuration.UserMocksConfiguration;
import com.olx.assertx.mocks.BaseJSMock;
import com.olx.assertx.mocks.ExternalServicesMock;
import com.olx.assertx.mocks.model.MockType;
import com.olx.assertx.utils.FileUtility;
import com.olx.assertx.utils.Paths;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSpecifiedMock
extends ExternalServicesMock
implements BaseJSMock {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserSpecifiedMock.class);

    @Override
    public MockType getMockType() {
        return MockType.USER_SPECIFIED;
    }

    @Override
    public void load(RouteConfiguration routeConfiguration) throws IOException {
        String destPath = Paths.ES_FOLDER + "/" + this.getMockType().getServiceName() + "/" + routeConfiguration.getFolderName();
        LOGGER.info("Load route={} for mock={} at path={}", new Object[]{routeConfiguration.getType(), this.getMockType(), destPath});
        FileUtility.copyDir(routeConfiguration.getResourcePath() + "/" + routeConfiguration.getFolderName(), destPath);
    }

    @Override
    public List<RouteConfiguration> getRouteConfigurations(GlobalMocksConfiguration globalMocksConfiguration, UserMocksConfiguration userMocksConfiguration) {
        return userMocksConfiguration.getExternalServices().getUserSpecified().getRoutes();
    }
}

