/*
 * Decompiled with CFR 0.152.
 */
package com.olx.assertx.mocks.builder;

import com.olx.assertx.configuration.FrameworkConfiguration;
import com.olx.assertx.configuration.UserMocksConfiguration;
import com.olx.assertx.mocks.BaseCustomMock;
import com.olx.assertx.mocks.BaseMock;
import com.olx.assertx.mocks.factory.MockFactory;
import com.olx.assertx.mocks.model.DockerCompose;
import com.olx.assertx.mocks.model.MockType;
import com.olx.assertx.mocks.model.Networks;
import com.olx.assertx.mocks.model.Service1Net;
import com.olx.assertx.mocks.model.Services;
import com.olx.assertx.utils.FileUtility;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerComposeBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerComposeBuilder.class);
    public static final String DOCKER_COMPOSE_FILENAME = "docker-compose.json";

    public static void build(UserMocksConfiguration userMocksConfiguration, FrameworkConfiguration frameworkConfiguration) throws IOException {
        LOGGER.info("Building docker compose");
        FileUtility.deleteDirectory("it");
        Services services = new Services();
        for (MockType mockType : frameworkConfiguration.getAvailableMocks()) {
            BaseMock mock = MockFactory.getMock(mockType);
            mock.build(frameworkConfiguration, userMocksConfiguration, services);
        }
        for (String customMockClass : userMocksConfiguration.getCustom()) {
            try {
                BaseCustomMock baseCustomMock = (BaseCustomMock)Class.forName(customMockClass).getConstructor(new Class[0]).newInstance(new Object[0]);
                baseCustomMock.build(userMocksConfiguration, services);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                LOGGER.error("Unable to load mock={} due to exception={}", (Object)customMockClass, (Object)ex);
                return;
            }
        }
        BaseMock mock = MockFactory.getMock(MockType.TOXIPROXY);
        mock.build(frameworkConfiguration, userMocksConfiguration, services);
        DockerCompose dockerCompose = DockerCompose.builder().services(services).networks(Networks.builder().service1NetName(Service1Net.builder().build()).build()).build();
        LOGGER.info("Write {} file to path={}", (Object)DOCKER_COMPOSE_FILENAME, (Object)"it/mocks");
        FileUtility.writeFile("it/mocks", DOCKER_COMPOSE_FILENAME, dockerCompose);
    }
}

