/*
 * Decompiled with CFR 0.152.
 */
package com.olx.assertx.mocks.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.olx.assertx.mocks.model.BaseService;
import com.olx.assertx.mocks.model.Healthcheck;
import com.olx.assertx.mocks.model.Networks;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"build", "container_name", "ports", "networks", "healthcheck", "environment"})
public class ExternalServices
extends BaseService {
    private String build;

    public ExternalServices(String containerName, List<String> ports, List<String> environment, Networks networks, Healthcheck healthcheck, String build) {
        super(containerName, ports, environment, networks, healthcheck);
        this.build = build;
    }

    public static ExternalServicesBuilder builder() {
        return new ExternalServicesBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExternalServices)) {
            return false;
        }
        ExternalServices other = (ExternalServices)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$build = this.getBuild();
        String other$build = other.getBuild();
        return !(this$build == null ? other$build != null : !this$build.equals(other$build));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExternalServices;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $build = this.getBuild();
        result = result * 59 + ($build == null ? 43 : $build.hashCode());
        return result;
    }

    public String getBuild() {
        return this.build;
    }

    public void setBuild(String build) {
        this.build = build;
    }

    public static class ExternalServicesBuilder {
        private String containerName;
        private List<String> ports;
        private List<String> environment;
        private Networks networks;
        private Healthcheck healthcheck;
        private String build;

        ExternalServicesBuilder() {
        }

        public ExternalServicesBuilder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public ExternalServicesBuilder ports(List<String> ports) {
            this.ports = ports;
            return this;
        }

        public ExternalServicesBuilder environment(List<String> environment) {
            this.environment = environment;
            return this;
        }

        public ExternalServicesBuilder networks(Networks networks) {
            this.networks = networks;
            return this;
        }

        public ExternalServicesBuilder healthcheck(Healthcheck healthcheck) {
            this.healthcheck = healthcheck;
            return this;
        }

        public ExternalServicesBuilder build(String build) {
            this.build = build;
            return this;
        }

        public ExternalServices build() {
            return new ExternalServices(this.containerName, this.ports, this.environment, this.networks, this.healthcheck, this.build);
        }

        public String toString() {
            return "ExternalServices.ExternalServicesBuilder(containerName=" + this.containerName + ", ports=" + String.valueOf(this.ports) + ", environment=" + String.valueOf(this.environment) + ", networks=" + String.valueOf(this.networks) + ", healthcheck=" + String.valueOf(this.healthcheck) + ", build=" + this.build + ")";
        }
    }
}

