/*
 * Decompiled with CFR 0.152.
 */
package com.olx.assertx.mocks.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.olx.assertx.mocks.model.BaseService;
import com.olx.assertx.mocks.model.Healthcheck;
import com.olx.assertx.mocks.model.Networks;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"image", "container_name", "environment", "ports", "healthcheck", "volumes", "networks"})
public class LocalStack
extends BaseService {
    private String image;
    private List<String> volumes;

    public LocalStack(String containerName, List<String> ports, List<String> environment, Networks networks, Healthcheck healthcheck, String image, List<String> volumes) {
        super(containerName, ports, environment, networks, healthcheck);
        this.image = image;
        this.volumes = volumes;
    }

    public static LocalStackBuilder builder() {
        return new LocalStackBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalStack)) {
            return false;
        }
        LocalStack other = (LocalStack)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        List<String> this$volumes = this.getVolumes();
        List<String> other$volumes = other.getVolumes();
        return !(this$volumes == null ? other$volumes != null : !((Object)this$volumes).equals(other$volumes));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LocalStack;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        List<String> $volumes = this.getVolumes();
        result = result * 59 + ($volumes == null ? 43 : ((Object)$volumes).hashCode());
        return result;
    }

    public String getImage() {
        return this.image;
    }

    public List<String> getVolumes() {
        return this.volumes;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setVolumes(List<String> volumes) {
        this.volumes = volumes;
    }

    public static class LocalStackBuilder {
        private String containerName;
        private List<String> ports;
        private List<String> environment;
        private Networks networks;
        private Healthcheck healthcheck;
        private String image;
        private List<String> volumes;

        LocalStackBuilder() {
        }

        public LocalStackBuilder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public LocalStackBuilder ports(List<String> ports) {
            this.ports = ports;
            return this;
        }

        public LocalStackBuilder environment(List<String> environment) {
            this.environment = environment;
            return this;
        }

        public LocalStackBuilder networks(Networks networks) {
            this.networks = networks;
            return this;
        }

        public LocalStackBuilder healthcheck(Healthcheck healthcheck) {
            this.healthcheck = healthcheck;
            return this;
        }

        public LocalStackBuilder image(String image) {
            this.image = image;
            return this;
        }

        public LocalStackBuilder volumes(List<String> volumes) {
            this.volumes = volumes;
            return this;
        }

        public LocalStack build() {
            return new LocalStack(this.containerName, this.ports, this.environment, this.networks, this.healthcheck, this.image, this.volumes);
        }

        public String toString() {
            return "LocalStack.LocalStackBuilder(containerName=" + this.containerName + ", ports=" + String.valueOf(this.ports) + ", environment=" + String.valueOf(this.environment) + ", networks=" + String.valueOf(this.networks) + ", healthcheck=" + String.valueOf(this.healthcheck) + ", image=" + this.image + ", volumes=" + String.valueOf(this.volumes) + ")";
        }
    }
}

