/*
 * Decompiled with CFR 0.152.
 */
package com.olx.assertx.mocks.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.olx.assertx.mocks.model.BaseService;
import com.olx.assertx.mocks.model.Healthcheck;
import com.olx.assertx.mocks.model.Networks;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"image", "container_name", "ports", "environment", "healthcheck", "volumes", "networks"})
public class OpenSearch
extends BaseService {
    private String image;
    private List<String> volumes;

    public OpenSearch(String containerName, List<String> ports, List<String> environment, Networks networks, Healthcheck healthcheck, String image, List<String> volumes) {
        super(containerName, ports, environment, networks, healthcheck);
        this.image = image;
        this.volumes = volumes;
    }

    public static OpenSearchBuilder builder() {
        return new OpenSearchBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSearch)) {
            return false;
        }
        OpenSearch other = (OpenSearch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        List<String> this$volumes = this.getVolumes();
        List<String> other$volumes = other.getVolumes();
        return !(this$volumes == null ? other$volumes != null : !((Object)this$volumes).equals(other$volumes));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OpenSearch;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        List<String> $volumes = this.getVolumes();
        result = result * 59 + ($volumes == null ? 43 : ((Object)$volumes).hashCode());
        return result;
    }

    public String getImage() {
        return this.image;
    }

    public List<String> getVolumes() {
        return this.volumes;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setVolumes(List<String> volumes) {
        this.volumes = volumes;
    }

    public static class OpenSearchBuilder {
        private String containerName;
        private List<String> ports;
        private List<String> environment;
        private Networks networks;
        private Healthcheck healthcheck;
        private String image;
        private List<String> volumes;

        OpenSearchBuilder() {
        }

        public OpenSearchBuilder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public OpenSearchBuilder ports(List<String> ports) {
            this.ports = ports;
            return this;
        }

        public OpenSearchBuilder environment(List<String> environment) {
            this.environment = environment;
            return this;
        }

        public OpenSearchBuilder networks(Networks networks) {
            this.networks = networks;
            return this;
        }

        public OpenSearchBuilder healthcheck(Healthcheck healthcheck) {
            this.healthcheck = healthcheck;
            return this;
        }

        public OpenSearchBuilder image(String image) {
            this.image = image;
            return this;
        }

        public OpenSearchBuilder volumes(List<String> volumes) {
            this.volumes = volumes;
            return this;
        }

        public OpenSearch build() {
            return new OpenSearch(this.containerName, this.ports, this.environment, this.networks, this.healthcheck, this.image, this.volumes);
        }

        public String toString() {
            return "OpenSearch.OpenSearchBuilder(containerName=" + this.containerName + ", ports=" + String.valueOf(this.ports) + ", environment=" + String.valueOf(this.environment) + ", networks=" + String.valueOf(this.networks) + ", healthcheck=" + String.valueOf(this.healthcheck) + ", image=" + this.image + ", volumes=" + String.valueOf(this.volumes) + ")";
        }
    }
}

