/*
 * Decompiled with CFR 0.152.
 */
package com.olx.assertx.mocks.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.olx.assertx.mocks.model.BaseService;
import com.olx.assertx.mocks.model.Healthcheck;
import com.olx.assertx.mocks.model.Networks;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"image", "container_name", "ports", "environment", "healthcheck", "volumes", "networks"})
public class PostgreSql
extends BaseService {
    private String image;
    private List<String> volumes;

    public PostgreSql(String containerName, List<String> ports, List<String> environment, Networks networks, Healthcheck healthcheck, String image, List<String> volumes) {
        super(containerName, ports, environment, networks, healthcheck);
        this.image = image;
        this.volumes = volumes;
    }

    public static PostgreSqlBuilder builder() {
        return new PostgreSqlBuilder();
    }

    public String getImage() {
        return this.image;
    }

    public List<String> getVolumes() {
        return this.volumes;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setVolumes(List<String> volumes) {
        this.volumes = volumes;
    }

    public static class PostgreSqlBuilder {
        private String containerName;
        private List<String> ports;
        private List<String> environment;
        private Networks networks;
        private Healthcheck healthcheck;
        private String image;
        private List<String> volumes;

        PostgreSqlBuilder() {
        }

        public PostgreSqlBuilder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public PostgreSqlBuilder ports(List<String> ports) {
            this.ports = ports;
            return this;
        }

        public PostgreSqlBuilder environment(List<String> environment) {
            this.environment = environment;
            return this;
        }

        public PostgreSqlBuilder networks(Networks networks) {
            this.networks = networks;
            return this;
        }

        public PostgreSqlBuilder healthcheck(Healthcheck healthcheck) {
            this.healthcheck = healthcheck;
            return this;
        }

        public PostgreSqlBuilder image(String image) {
            this.image = image;
            return this;
        }

        public PostgreSqlBuilder volumes(List<String> volumes) {
            this.volumes = volumes;
            return this;
        }

        public PostgreSql build() {
            return new PostgreSql(this.containerName, this.ports, this.environment, this.networks, this.healthcheck, this.image, this.volumes);
        }

        public String toString() {
            return "PostgreSql.PostgreSqlBuilder(containerName=" + this.containerName + ", ports=" + String.valueOf(this.ports) + ", environment=" + String.valueOf(this.environment) + ", networks=" + String.valueOf(this.networks) + ", healthcheck=" + String.valueOf(this.healthcheck) + ", image=" + this.image + ", volumes=" + String.valueOf(this.volumes) + ")";
        }
    }
}

