/*
 * Decompiled with CFR 0.152.
 */
package com.olx.assertx.mocks.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.olx.assertx.mocks.model.BaseService;
import com.olx.assertx.mocks.model.Healthcheck;
import com.olx.assertx.mocks.model.Networks;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"image", "container_name", "user", "ports", "environment", "healthcheck", "networks"})
public class Redis
extends BaseService {
    private String image;
    private String user;
    private List<String> volumes;
    private List<String> command;

    public Redis(String containerName, List<String> ports, List<String> environment, Networks networks, Healthcheck healthcheck, String image, String user, List<String> volumes, List<String> command) {
        super(containerName, ports, environment, networks, healthcheck);
        this.image = image;
        this.user = user;
        this.volumes = volumes;
        this.command = command;
    }

    public static RedisBuilder builder() {
        return new RedisBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Redis)) {
            return false;
        }
        Redis other = (Redis)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        List<String> this$volumes = this.getVolumes();
        List<String> other$volumes = other.getVolumes();
        if (this$volumes == null ? other$volumes != null : !((Object)this$volumes).equals(other$volumes)) {
            return false;
        }
        List<String> this$command = this.getCommand();
        List<String> other$command = other.getCommand();
        return !(this$command == null ? other$command != null : !((Object)this$command).equals(other$command));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Redis;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        List<String> $volumes = this.getVolumes();
        result = result * 59 + ($volumes == null ? 43 : ((Object)$volumes).hashCode());
        List<String> $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : ((Object)$command).hashCode());
        return result;
    }

    public String getImage() {
        return this.image;
    }

    public String getUser() {
        return this.user;
    }

    public List<String> getVolumes() {
        return this.volumes;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setVolumes(List<String> volumes) {
        this.volumes = volumes;
    }

    public void setCommand(List<String> command) {
        this.command = command;
    }

    public static class RedisBuilder {
        private String containerName;
        private List<String> ports;
        private List<String> environment;
        private Networks networks;
        private Healthcheck healthcheck;
        private String image;
        private String user;
        private List<String> volumes;
        private List<String> command;

        RedisBuilder() {
        }

        public RedisBuilder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public RedisBuilder ports(List<String> ports) {
            this.ports = ports;
            return this;
        }

        public RedisBuilder environment(List<String> environment) {
            this.environment = environment;
            return this;
        }

        public RedisBuilder networks(Networks networks) {
            this.networks = networks;
            return this;
        }

        public RedisBuilder healthcheck(Healthcheck healthcheck) {
            this.healthcheck = healthcheck;
            return this;
        }

        public RedisBuilder image(String image) {
            this.image = image;
            return this;
        }

        public RedisBuilder user(String user) {
            this.user = user;
            return this;
        }

        public RedisBuilder volumes(List<String> volumes) {
            this.volumes = volumes;
            return this;
        }

        public RedisBuilder command(List<String> command) {
            this.command = command;
            return this;
        }

        public Redis build() {
            return new Redis(this.containerName, this.ports, this.environment, this.networks, this.healthcheck, this.image, this.user, this.volumes, this.command);
        }

        public String toString() {
            return "Redis.RedisBuilder(containerName=" + this.containerName + ", ports=" + String.valueOf(this.ports) + ", environment=" + String.valueOf(this.environment) + ", networks=" + String.valueOf(this.networks) + ", healthcheck=" + String.valueOf(this.healthcheck) + ", image=" + this.image + ", user=" + this.user + ", volumes=" + String.valueOf(this.volumes) + ", command=" + String.valueOf(this.command) + ")";
        }
    }
}

