/*
 * Decompiled with CFR 0.152.
 */
package com.olx.assertx.mocks.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.olx.assertx.mocks.model.BaseService;
import com.olx.assertx.mocks.model.Healthcheck;
import com.olx.assertx.mocks.model.Networks;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"image", "container_name", "ports", "environment", "entrypoint", "volumes", "healthcheck", "networks"})
public class Solr
extends BaseService {
    String image;
    List<String> entrypoint;
    List<String> volumes;

    public Solr(String containerName, List<String> ports, List<String> environment, Networks networks, Healthcheck healthcheck, String image, List<String> entrypoint, List<String> volumes) {
        super(containerName, ports, environment, networks, healthcheck);
        this.image = image;
        this.entrypoint = entrypoint;
        this.volumes = volumes;
    }

    public static SolrBuilder builder() {
        return new SolrBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Solr)) {
            return false;
        }
        Solr other = (Solr)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        List<String> this$entrypoint = this.getEntrypoint();
        List<String> other$entrypoint = other.getEntrypoint();
        if (this$entrypoint == null ? other$entrypoint != null : !((Object)this$entrypoint).equals(other$entrypoint)) {
            return false;
        }
        List<String> this$volumes = this.getVolumes();
        List<String> other$volumes = other.getVolumes();
        return !(this$volumes == null ? other$volumes != null : !((Object)this$volumes).equals(other$volumes));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Solr;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        List<String> $entrypoint = this.getEntrypoint();
        result = result * 59 + ($entrypoint == null ? 43 : ((Object)$entrypoint).hashCode());
        List<String> $volumes = this.getVolumes();
        result = result * 59 + ($volumes == null ? 43 : ((Object)$volumes).hashCode());
        return result;
    }

    public String getImage() {
        return this.image;
    }

    public List<String> getEntrypoint() {
        return this.entrypoint;
    }

    public List<String> getVolumes() {
        return this.volumes;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setEntrypoint(List<String> entrypoint) {
        this.entrypoint = entrypoint;
    }

    public void setVolumes(List<String> volumes) {
        this.volumes = volumes;
    }

    public static class SolrBuilder {
        private String containerName;
        private List<String> ports;
        private List<String> environment;
        private Networks networks;
        private Healthcheck healthcheck;
        private String image;
        private List<String> entrypoint;
        private List<String> volumes;

        SolrBuilder() {
        }

        public SolrBuilder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public SolrBuilder ports(List<String> ports) {
            this.ports = ports;
            return this;
        }

        public SolrBuilder environment(List<String> environment) {
            this.environment = environment;
            return this;
        }

        public SolrBuilder networks(Networks networks) {
            this.networks = networks;
            return this;
        }

        public SolrBuilder healthcheck(Healthcheck healthcheck) {
            this.healthcheck = healthcheck;
            return this;
        }

        public SolrBuilder image(String image) {
            this.image = image;
            return this;
        }

        public SolrBuilder entrypoint(List<String> entrypoint) {
            this.entrypoint = entrypoint;
            return this;
        }

        public SolrBuilder volumes(List<String> volumes) {
            this.volumes = volumes;
            return this;
        }

        public Solr build() {
            return new Solr(this.containerName, this.ports, this.environment, this.networks, this.healthcheck, this.image, this.entrypoint, this.volumes);
        }

        public String toString() {
            return "Solr.SolrBuilder(containerName=" + this.containerName + ", ports=" + String.valueOf(this.ports) + ", environment=" + String.valueOf(this.environment) + ", networks=" + String.valueOf(this.networks) + ", healthcheck=" + String.valueOf(this.healthcheck) + ", image=" + this.image + ", entrypoint=" + String.valueOf(this.entrypoint) + ", volumes=" + String.valueOf(this.volumes) + ")";
        }
    }
}

