/*
 * Decompiled with CFR 0.152.
 */
package com.olx.assertx.mocks.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.olx.assertx.mocks.model.BaseService;
import com.olx.assertx.mocks.model.Healthcheck;
import com.olx.assertx.mocks.model.Networks;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"build", "container_name", "ports", "healthcheck", "networks", "environment", "restart"})
public class ToxiProxy
extends BaseService {
    private String build;
    private String restart;

    public ToxiProxy(String containerName, List<String> ports, List<String> environment, Networks networks, Healthcheck healthcheck, String build, String restart) {
        super(containerName, ports, environment, networks, healthcheck);
        this.build = build;
        this.restart = restart;
    }

    public static ToxiProxyBuilder builder() {
        return new ToxiProxyBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ToxiProxy)) {
            return false;
        }
        ToxiProxy other = (ToxiProxy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$build = this.getBuild();
        String other$build = other.getBuild();
        if (this$build == null ? other$build != null : !this$build.equals(other$build)) {
            return false;
        }
        String this$restart = this.getRestart();
        String other$restart = other.getRestart();
        return !(this$restart == null ? other$restart != null : !this$restart.equals(other$restart));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ToxiProxy;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $build = this.getBuild();
        result = result * 59 + ($build == null ? 43 : $build.hashCode());
        String $restart = this.getRestart();
        result = result * 59 + ($restart == null ? 43 : $restart.hashCode());
        return result;
    }

    public String getBuild() {
        return this.build;
    }

    public String getRestart() {
        return this.restart;
    }

    public void setBuild(String build) {
        this.build = build;
    }

    public void setRestart(String restart) {
        this.restart = restart;
    }

    public static class ToxiProxyBuilder {
        private String containerName;
        private List<String> ports;
        private List<String> environment;
        private Networks networks;
        private Healthcheck healthcheck;
        private String build;
        private String restart;

        ToxiProxyBuilder() {
        }

        public ToxiProxyBuilder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public ToxiProxyBuilder ports(List<String> ports) {
            this.ports = ports;
            return this;
        }

        public ToxiProxyBuilder environment(List<String> environment) {
            this.environment = environment;
            return this;
        }

        public ToxiProxyBuilder networks(Networks networks) {
            this.networks = networks;
            return this;
        }

        public ToxiProxyBuilder healthcheck(Healthcheck healthcheck) {
            this.healthcheck = healthcheck;
            return this;
        }

        public ToxiProxyBuilder build(String build) {
            this.build = build;
            return this;
        }

        public ToxiProxyBuilder restart(String restart) {
            this.restart = restart;
            return this;
        }

        public ToxiProxy build() {
            return new ToxiProxy(this.containerName, this.ports, this.environment, this.networks, this.healthcheck, this.build, this.restart);
        }

        public String toString() {
            return "ToxiProxy.ToxiProxyBuilder(containerName=" + this.containerName + ", ports=" + String.valueOf(this.ports) + ", environment=" + String.valueOf(this.environment) + ", networks=" + String.valueOf(this.networks) + ", healthcheck=" + String.valueOf(this.healthcheck) + ", build=" + this.build + ", restart=" + this.restart + ")";
        }
    }
}

