/*
 * Decompiled with CFR 0.152.
 */
package com.olx.assertx.mocks.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.olx.assertx.mocks.model.BaseService;
import com.olx.assertx.mocks.model.Healthcheck;
import com.olx.assertx.mocks.model.Networks;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"image", "container_name", "ports", "environment", "healthcheck", "networks"})
public class Zookeeper
extends BaseService {
    String image;

    public Zookeeper(String containerName, List<String> ports, List<String> environment, Networks networks, Healthcheck healthcheck, String image) {
        super(containerName, ports, environment, networks, healthcheck);
        this.image = image;
    }

    public static ZookeeperBuilder builder() {
        return new ZookeeperBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Zookeeper)) {
            return false;
        }
        Zookeeper other = (Zookeeper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        return !(this$image == null ? other$image != null : !this$image.equals(other$image));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Zookeeper;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        return result;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public static class ZookeeperBuilder {
        private String containerName;
        private List<String> ports;
        private List<String> environment;
        private Networks networks;
        private Healthcheck healthcheck;
        private String image;

        ZookeeperBuilder() {
        }

        public ZookeeperBuilder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public ZookeeperBuilder ports(List<String> ports) {
            this.ports = ports;
            return this;
        }

        public ZookeeperBuilder environment(List<String> environment) {
            this.environment = environment;
            return this;
        }

        public ZookeeperBuilder networks(Networks networks) {
            this.networks = networks;
            return this;
        }

        public ZookeeperBuilder healthcheck(Healthcheck healthcheck) {
            this.healthcheck = healthcheck;
            return this;
        }

        public ZookeeperBuilder image(String image) {
            this.image = image;
            return this;
        }

        public Zookeeper build() {
            return new Zookeeper(this.containerName, this.ports, this.environment, this.networks, this.healthcheck, this.image);
        }

        public String toString() {
            return "Zookeeper.ZookeeperBuilder(containerName=" + this.containerName + ", ports=" + String.valueOf(this.ports) + ", environment=" + String.valueOf(this.environment) + ", networks=" + String.valueOf(this.networks) + ", healthcheck=" + String.valueOf(this.healthcheck) + ", image=" + this.image + ")";
        }
    }
}

