/*
 * Decompiled with CFR 0.152.
 */
package com.olx.assertx.stepdefinitions.initialisation;

import com.olx.assertx.service.model.RequestKey;
import com.olx.assertx.stepdefinitions.BaseStepDefinition;
import io.cucumber.datatable.DataTable;
import io.cucumber.java.en.Given;
import java.util.List;
import org.junit.Assert;

public class CommonStepInitialisation
extends BaseStepDefinition {
    @Given(value="^I have (.*) host$")
    public void setBaseURL(String host) {
        this.testContext().set(RequestKey.HOST.toName(), host);
    }

    @Given(value="^I have (.*) API$")
    public void setAPIPath(String apiPath) {
        this.testContext().set(RequestKey.API_PATH.toName(), apiPath);
    }

    @Given(value="^I have following query parameters$")
    public void setQueryParameters(DataTable dataTable) {
        List values = dataTable.asMaps(String.class, String.class);
        Assert.assertNotEquals((String)"Empty query parameters table!", (long)0L, (long)values.size());
        this.testContext().set(RequestKey.QUERY_PARAMS.toName(), values.get(0));
    }

    @Given(value="^I have following headers$")
    public void setHeaders(DataTable dataTable) {
        List values = dataTable.asMaps(String.class, String.class);
        Assert.assertNotEquals((String)"Empty headers table!", (long)0L, (long)values.size());
        this.testContext().set(RequestKey.HEADERS.toName(), values.get(0));
    }

    @Given(value="^I have a request body in (.*)$")
    public void setRequestBody(String requestBody) {
        this.testContext().set(RequestKey.PAYLOAD.toName(), this.testContext().get(requestBody, String.class));
    }

    @Given(value="^I have following multipart file specifications$")
    public void setMultipartFileSpecs(DataTable dataTable) {
        List values = dataTable.asMaps(String.class, String.class);
        Assert.assertNotEquals((String)"Empty specifications table!", (long)0L, (long)values.size());
        this.testContext().set(RequestKey.MULTIPART_SPECS.toName(), values.get(0));
    }
}

