/*
 * Decompiled with CFR 0.152.
 */
package com.olx.assertx.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtility {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtility.class);
    private static final String FILE_PATH_FORMAT = "%s/%s";
    private static final String NEW_LINE_CHAR = "\n";

    private static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        return objectMapper;
    }

    public static void copyDir(String srcPath, String destPath) throws IOException {
        LOGGER.debug("Copy directory with source path={} and destination path={}", (Object)srcPath, (Object)destPath);
        File srcDir = Paths.get(srcPath, new String[0]).toFile();
        File destDir = Paths.get(destPath, new String[0]).toFile();
        if (!srcDir.toString().equals(destDir.toString())) {
            FileUtils.copyDirectory((File)srcDir, (File)destDir);
        }
    }

    public static void copyJarDir(String srcPath, String destPath, List<String> fileNames) throws IOException {
        LOGGER.debug("Copy jar directory with source path={}, destination path={} and files={}", new Object[]{srcPath, destPath, fileNames});
        File srcDir = new File(Objects.requireNonNull(FileUtility.class.getClassLoader().getResource(srcPath)).getFile());
        File destDir = Paths.get(destPath, new String[0]).toFile();
        if (!srcDir.toString().equals(destDir.toString())) {
            for (String fileName : fileNames) {
                FileUtility.copyFile(srcPath + "/" + fileName, destPath, fileName);
            }
        }
    }

    public static void copyFile(String templateFilePath, String destFilePath, String fileName) throws IOException {
        FileUtility.generateFileFromTemplate(templateFilePath, destFilePath, fileName, new HashMap<String, String>());
    }

    public static void generateFileFromTemplate(String templateFilePath, String destFilePath, String fileName, Map<String, String> templateVariables) throws IOException {
        LOGGER.debug("Copy file from source path={} to destination path={} with template variables={}", new Object[]{templateFilePath, destFilePath, templateVariables});
        Files.createDirectories(Paths.get(destFilePath, new String[0]), new FileAttribute[0]);
        try (FileWriter writer = new FileWriter(String.format(FILE_PATH_FORMAT, destFilePath, fileName));){
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(FileUtility.class.getClassLoader().getResourceAsStream(templateFilePath))));){
                String line;
                while ((line = reader.readLine()) != null) {
                    for (String key : templateVariables.keySet()) {
                        line = line.replace(key, templateVariables.get(key));
                    }
                    writer.write(line + NEW_LINE_CHAR);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error writing file having destination path={}, exception={}", (Object)destFilePath, (Object)e.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error generating file having destination path={}, exception={}", (Object)destFilePath, (Object)e.getMessage());
        }
    }

    public static void deleteDirectory(String directoryPath) throws IOException {
        LOGGER.debug("Delete directory with path={}", (Object)directoryPath);
        File directory = new File(Paths.get(directoryPath, new String[0]).toString());
        FileUtils.deleteDirectory((File)directory);
    }

    public static void writeFile(String destFilePath, String fileName, Object object) throws IOException {
        LOGGER.debug("Write object of type={} to file={} at path={}", new Object[]{object.getClass(), fileName, destFilePath});
        Files.createDirectories(Paths.get(destFilePath, new String[0]), new FileAttribute[0]);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(String.format(FILE_PATH_FORMAT, destFilePath, fileName)));){
            writer.write(FileUtility.getObjectMapper().writeValueAsString(object));
        }
    }

    public static List<String> getFilteredFileList(String filesDirectoryPath, String[] fileExtension, boolean recursive) {
        Collection filteredFiles = FileUtils.listFiles((File)new File(filesDirectoryPath), (String[])fileExtension, (boolean)recursive);
        ArrayList<String> filePaths = new ArrayList<String>(filteredFiles.size());
        filteredFiles.forEach(file -> filePaths.add(file.getAbsolutePath()));
        return filePaths;
    }
}

