/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.test;

import in.specmatic.core.CommandHook;
import in.specmatic.core.Configuration;
import in.specmatic.core.Feature;
import in.specmatic.core.FeatureKt;
import in.specmatic.core.Hook;
import in.specmatic.core.HookName;
import in.specmatic.core.HttpRequest;
import in.specmatic.core.HttpRequestPattern;
import in.specmatic.core.HttpResponse;
import in.specmatic.core.HttpResponsePattern;
import in.specmatic.core.Result;
import in.specmatic.core.Scenario;
import in.specmatic.core.Suggestions;
import in.specmatic.core.TestConfig;
import in.specmatic.core.TestConfigKt;
import in.specmatic.core.WorkingDirectory;
import in.specmatic.core.log.LogStrategy;
import in.specmatic.core.log.LoggingKt;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.pattern.Examples;
import in.specmatic.core.pattern.GrammarKt;
import in.specmatic.core.pattern.Row;
import in.specmatic.core.utilities.ContractPathData;
import in.specmatic.core.utilities.Utilities;
import in.specmatic.core.value.JSONArrayValue;
import in.specmatic.core.value.JSONObjectValue;
import in.specmatic.core.value.Value;
import in.specmatic.test.API;
import in.specmatic.test.ContractTest;
import in.specmatic.test.HTTPTestTargetInvoker;
import in.specmatic.test.HttpClient;
import in.specmatic.test.ResultAssert;
import in.specmatic.test.SpecmaticJUnitSupportKt;
import in.specmatic.test.TargetBaseURL;
import in.specmatic.test.TargetHostAndPort;
import in.specmatic.test.TestReport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.opentest4j.TestAbortedException;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J.\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000e2\u0006\u0010\u0017\u001a\u00020\tH\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u000e2\u0006\u0010\u0011\u001a\u00020\tH\u0002\u00a8\u0006\u001a"}, d2={"Lin/specmatic/test/SpecmaticJUnitSupport;", "", "()V", "contractTest", "", "Lorg/junit/jupiter/api/DynamicTest;", "getEnvConfig", "Lin/specmatic/core/value/JSONObjectValue;", "envName", "", "loadExceptionAsTestError", "e", "", "loadTestScenarios", "", "Lin/specmatic/test/ContractTest;", "path", "suggestionsPath", "suggestionsData", "config", "Lin/specmatic/core/TestConfig;", "suggestionsFromCommandLine", "Lin/specmatic/core/Scenario;", "suggestions", "suggestionsFromFile", "Companion", "junit5-support"})
public class SpecmaticJUnitSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String CONTRACT_PATHS = "contractPaths";
    @NotNull
    public static final String WORKING_DIRECTORY = "workingDirectory";
    @NotNull
    public static final String CONFIG_FILE_NAME = "manifestFile";
    @NotNull
    public static final String TIMEOUT = "timeout";
    @NotNull
    private static final String DEFAULT_TIMEOUT = "60";
    @NotNull
    public static final String INLINE_SUGGESTIONS = "suggestions";
    @NotNull
    public static final String SUGGESTIONS_PATH = "suggestionsPath";
    @NotNull
    public static final String HOST = "host";
    @NotNull
    public static final String PORT = "port";
    @NotNull
    public static final String TEST_BASE_URL = "testBaseURL";
    @NotNull
    public static final String ENV_NAME = "environment";
    @NotNull
    public static final String VARIABLES_FILE_NAME = "variablesFileName";
    @NotNull
    public static final String FILTER_NAME = "filterName";
    @NotNull
    public static final String FILTER_NOT_NAME = "filterNotName";
    @NotNull
    public static final String ENDPOINTS_API = "endpointsAPI";
    @NotNull
    private static final List<String> testsNames = new ArrayList();
    @NotNull
    private static final List<Result.Success> partialSuccesses = new ArrayList();
    @NotNull
    private static final TestReport testReport = new TestReport(null, null, 3, null);

    private final JSONObjectValue getEnvConfig(String envName) {
        CharSequence charSequence = envName;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return new JSONObjectValue(null, 1, null);
        }
        File configFile = new File(Configuration.Companion.getGlobalConfigFileName());
        if (!configFile.exists()) {
            throw new ContractException("Environment name " + envName + " was specified but config file (usually named specmatic.json) does not exist in the project root. Either avoid setting envName, or provide specmatic.json with the environment settings.", null, null, null, false, 30, null);
        }
        JSONObjectValue config = Utilities.loadConfigJSON((File)configFile);
        Value value = config.findFirstChildByPath("environments." + envName);
        if (value == null) {
            return new JSONObjectValue(null, 1, null);
        }
        Value envConfig = value;
        if (!(envConfig instanceof JSONObjectValue)) {
            throw new ContractException("The environment config must be a JSON object.", null, null, null, false, 30, null);
        }
        return (JSONObjectValue)envConfig;
    }

    private final Collection<DynamicTest> loadExceptionAsTestError(Throwable e) {
        return CollectionsKt.listOf((Object)DynamicTest.dynamicTest((String)"Load Error", () -> SpecmaticJUnitSupport.loadExceptionAsTestError$lambda$0(e)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TestFactory
    @NotNull
    public final Collection<DynamicTest> contractTest() {
        void $this$mapTo$iv$iv;
        List testScenarios;
        Collection collection;
        TestConfig testConfig;
        String string;
        String suggestionsPath;
        String string2;
        String suggestionsData;
        String contractPaths = System.getProperty(CONTRACT_PATHS);
        String givenWorkingDirectory = System.getProperty(WORKING_DIRECTORY);
        String givenConfigFile = System.getProperty(CONFIG_FILE_NAME);
        String filterName = System.getProperty(FILTER_NAME);
        String filterNotName = System.getProperty(FILTER_NOT_NAME);
        String string3 = System.getProperty(TIMEOUT, DEFAULT_TIMEOUT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProperty(TIMEOUT, DEFAULT_TIMEOUT)");
        int timeout = Integer.parseInt(string3);
        String string4 = System.getProperty(INLINE_SUGGESTIONS);
        if (string4 == null) {
            string4 = suggestionsData = "";
        }
        if ((string2 = System.getProperty(SUGGESTIONS_PATH)) == null) {
            string2 = suggestionsPath = "";
        }
        if ((string = givenWorkingDirectory) == null) {
            string = ".specmatic";
        }
        WorkingDirectory workingDirectory = new WorkingDirectory(string);
        JSONObjectValue envConfig = this.getEnvConfig(System.getProperty(ENV_NAME));
        try {
            testConfig = TestConfigKt.loadTestConfig((JSONObjectValue)envConfig).withVariablesFromFilePath(System.getProperty(VARIABLES_FILE_NAME));
        }
        catch (Throwable e) {
            return this.loadExceptionAsTestError(e);
        }
        TestConfig testConfig2 = testConfig;
        try {
            List list;
            Object list$iv$iv;
            if (contractPaths != null) {
                void $this$flatMapTo$iv$iv;
                String[] stringArray = new String[]{","};
                Iterable $this$flatMap$iv = StringsKt.split$default((CharSequence)contractPaths, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    Iterator it = (String)element$iv$iv;
                    boolean bl = false;
                    list$iv$iv = this.loadTestScenarios((String)((Object)it), suggestionsPath, suggestionsData, testConfig2);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                void $this$flatMapTo$iv$iv;
                String it;
                Iterable $this$mapTo$iv$iv2;
                String string5 = givenConfigFile;
                if (string5 == null) {
                    string5 = Configuration.Companion.getGlobalConfigFileName();
                }
                String configFile = string5;
                Utilities.exitIfDoesNotExist((String)"config file", (String)configFile);
                Utilities.createIfDoesNotExist((String)workingDirectory.getPath());
                Iterable $this$map$iv = Utilities.contractTestPathsFrom((String)configFile, (String)workingDirectory.getPath());
                boolean $i$f$map = false;
                Iterable $i$f$flatMapTo = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    list$iv$iv = (ContractPathData)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getPath());
                }
                List contractFilePaths = (List)destination$iv$iv;
                Iterable $this$flatMap$iv = contractFilePaths;
                boolean $i$f$flatMap = false;
                $this$mapTo$iv$iv2 = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo2 = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean bl = false;
                    list$iv$iv = this.loadTestScenarios(it, "", "", testConfig2);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list = (List)destination$iv$iv;
            }
            testScenarios = list;
            testScenarios = SpecmaticJUnitSupportKt.selectTestsToRun(testScenarios, filterName, filterNotName);
        }
        catch (ContractException e) {
            Collection<DynamicTest> contractFilePaths = this.loadExceptionAsTestError(e);
            return contractFilePaths;
        }
        catch (Throwable e) {
            Collection<DynamicTest> contractFilePaths = this.loadExceptionAsTestError(e);
            return contractFilePaths;
        }
        finally {
            workingDirectory.delete();
        }
        List testScenarios2 = testScenarios;
        String testBaseURL = System.getProperty(TEST_BASE_URL);
        HTTPTestTargetInvoker invoker = testBaseURL == null ? (HTTPTestTargetInvoker)new TargetHostAndPort(System.getProperty(HOST), System.getProperty(PORT)) : (HTTPTestTargetInvoker)new TargetBaseURL(testBaseURL);
        Ref.BooleanRef checkedAPIs = new Ref.BooleanRef();
        Iterable $this$map$iv = testScenarios2;
        boolean $i$f$map = false;
        Iterable $i$f$flatMap = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void testScenario;
            ContractTest element$iv$iv = (ContractTest)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DynamicTest.dynamicTest((String)testScenario.testDescription(), () -> SpecmaticJUnitSupport.contractTest$lambda$5$lambda$4(checkedAPIs, (ContractTest)testScenario, invoker, timeout)));
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private final List<ContractTest> loadTestScenarios(String path, String suggestionsPath, String suggestionsData, TestConfig config) {
        File contractFile = new File(path);
        String string = contractFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contractFile.path");
        Feature feature = Feature.copy$default((Feature)FeatureKt.parseContractFileToFeature((String)string, (Hook)((Hook)new CommandHook(HookName.test_load_contract))), null, null, null, (Map)config.getVariables(), (Map)config.getBaseURLs(), null, (boolean)false, (int)103, null);
        List<Scenario> suggestions = ((CharSequence)suggestionsPath).length() > 0 ? this.suggestionsFromFile(suggestionsPath) : (((CharSequence)suggestionsData).length() > 0 ? this.suggestionsFromCommandLine(suggestionsData) : CollectionsKt.emptyList());
        return feature.generateContractTests((List)suggestions);
    }

    private final List<Scenario> suggestionsFromFile(String suggestionsPath) {
        return Suggestions.Companion.fromFile(suggestionsPath).getScenarios();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Scenario> suggestionsFromCommandLine(String suggestions) {
        void $this$mapTo$iv$iv;
        Object object;
        Iterable $this$mapValuesTo$iv$iv;
        Value suggestionsValue = GrammarKt.parsedValue((String)suggestions);
        if (!(suggestionsValue instanceof JSONObjectValue)) {
            throw new ContractException("Suggestions must be a json value with scenario name as the key, and json array with 1 or more json objects containing suggestions", null, null, null, false, 30, null);
        }
        Map $this$mapValues$iv = ((JSONObjectValue)suggestionsValue).getJsonObject();
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Object destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Examples examples;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = map2;
            boolean bl2 = false;
            Value exampleData = (Value)entry2.getValue();
            if (!(exampleData instanceof JSONArrayValue)) {
                throw new ContractException("The value of a scenario must be a list of examples", null, null, null, false, 30, null);
            }
            if (((JSONArrayValue)exampleData).getList().isEmpty()) {
                examples = new Examples(null, null, 3, null);
            } else {
                Map row;
                Collection collection;
                Iterable $this$mapTo$iv$iv2;
                List columns = SpecmaticJUnitSupportKt.access$columnsFromExamples((JSONArrayValue)exampleData);
                Iterable $this$map$iv = ((JSONArrayValue)exampleData).getList();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    Value value = (Value)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl3 = false;
                    collection.add(SpecmaticJUnitSupportKt.access$asJSONObjectValue((Value)row, "Each value in the list of suggestions must be a json object containing column name as key and sample value as the value"));
                }
                $this$map$iv = (List)destination$iv$iv2;
                $i$f$map = false;
                $this$mapTo$iv$iv2 = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void $this$mapTo$iv$iv3;
                    void $this$map$iv2;
                    row = (Map)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl4 = false;
                    Iterable iterable2 = columns;
                    List list = columns;
                    boolean $i$f$map2 = false;
                    void var32_34 = $this$map$iv2;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                        void it;
                        String string = (String)item$iv$iv2;
                        Collection collection2 = destination$iv$iv3;
                        boolean bl5 = false;
                        collection2.add(((Value)MapsKt.getValue((Map)row, (Object)it)).toStringLiteral());
                    }
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n = 28;
                    String string = null;
                    Map map3 = null;
                    Map map4 = null;
                    List list2 = (List)destination$iv$iv3;
                    List list3 = list;
                    collection.add(new Row(list3, list2, map4, map3, string, n, defaultConstructorMarker));
                }
                List rows = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2));
                examples = new Examples(columns, rows);
            }
            Examples examples2 = examples;
            object.put(k, examples2);
        }
        Iterable $this$map$iv = destination$iv$iv.entrySet();
        boolean $i$f$map = false;
        $this$mapValuesTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map.Entry entry = (Map.Entry)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            String name = (String)entry.getKey();
            Examples examples = (Examples)entry.getValue();
            object.add(new Scenario(name, new HttpRequestPattern(null, null, null, null, null, null, null, 127, null), new HttpResponsePattern(null, 0, null, 7, null), MapsKt.emptyMap(), CollectionsKt.listOf((Object)examples), MapsKt.emptyMap(), MapsKt.emptyMap(), null, false, null, null, false, false, null, null, false, 65280, null));
        }
        return (List)destination$iv$iv;
    }

    private static final void loadExceptionAsTestError$lambda$0(Throwable $e) {
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        testsNames.add("Load Error");
        LogStrategy.DefaultImpls.log$default((LogStrategy)LoggingKt.getLogger(), (Throwable)$e, null, (int)2, null);
        ResultAssert.Companion.assertThat((Result)new Result.Failure(Utilities.exceptionCauseMessage((Throwable)$e), null, null, null, 14, null)).isSuccess();
    }

    private static final void contractTest$lambda$5$lambda$4(Ref.BooleanRef $checkedAPIs, ContractTest $testScenario, HTTPTestTargetInvoker $invoker, int $timeout) {
        Intrinsics.checkNotNullParameter((Object)$checkedAPIs, (String)"$checkedAPIs");
        Intrinsics.checkNotNullParameter((Object)$testScenario, (String)"$testScenario");
        Intrinsics.checkNotNullParameter((Object)$invoker, (String)"$invoker");
        if (!$checkedAPIs.element) {
            $checkedAPIs.element = true;
            try {
                Companion.queryActuator();
            }
            catch (Throwable exception) {
                LoggingKt.getLogger().log(exception, "Failed to query actuator with error");
            }
        }
        testsNames.add($testScenario.testDescription());
        try {
            Result result = $invoker.execute($testScenario, $timeout);
            testReport.addTestReportRecords($testScenario.testResultRecord(result));
            if (result instanceof Result.Success && result.isPartialSuccess()) {
                partialSuccesses.add((Result.Success)result);
            }
            if (result.shouldBeIgnored()) {
                String message = "Test FAILED, ignoring since the scenario is tagged @WIP" + System.lineSeparator() + StringsKt.prependIndent((String)Result.toReport$default((Result)result, null, (int)1, null).toText(), (String)"  ");
                throw new TestAbortedException(message);
            }
            ResultAssert.Companion.assertThat(result).isSuccess();
        }
        catch (Throwable e) {
            testReport.addTestReportRecords($testScenario.testResultRecord((Result)new Result.Failure(Utilities.exceptionCauseMessage((Throwable)e), null, null, null, 14, null)));
            throw e;
        }
    }

    @AfterAll
    @JvmStatic
    public static final void report() {
        Companion.report();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u001fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017\u00a8\u0006!"}, d2={"Lin/specmatic/test/SpecmaticJUnitSupport$Companion;", "", "()V", "CONFIG_FILE_NAME", "", "CONTRACT_PATHS", "DEFAULT_TIMEOUT", "ENDPOINTS_API", "ENV_NAME", "FILTER_NAME", "FILTER_NOT_NAME", "HOST", "INLINE_SUGGESTIONS", "PORT", "SUGGESTIONS_PATH", "TEST_BASE_URL", "TIMEOUT", "VARIABLES_FILE_NAME", "WORKING_DIRECTORY", "partialSuccesses", "", "Lin/specmatic/core/Result$Success;", "getPartialSuccesses", "()Ljava/util/List;", "testReport", "Lin/specmatic/test/TestReport;", "getTestReport", "()Lin/specmatic/test/TestReport;", "testsNames", "getTestsNames", "queryActuator", "", "report", "junit5-support"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getTestsNames() {
            return testsNames;
        }

        @NotNull
        public final List<Result.Success> getPartialSuccesses() {
            return partialSuccesses;
        }

        @NotNull
        public final TestReport getTestReport() {
            return testReport;
        }

        @AfterAll
        @JvmStatic
        public final void report() {
            this.getTestReport().printReport();
        }

        /*
         * WARNING - void declaration
         */
        public final void queryActuator() {
            String endpointsAPI = System.getProperty(SpecmaticJUnitSupport.ENDPOINTS_API);
            if (endpointsAPI != null) {
                void $this$flatMapTo$iv$iv;
                HttpRequest request = new HttpRequest("GET", null, null, null, null, null, null, 126, null);
                HttpResponse response = new HttpClient(endpointsAPI, 0, LoggingKt.getIgnoreLog(), null, 10, null).execute(request);
                LoggingKt.getLogger().debug(HttpResponse.toLogString$default((HttpResponse)response, null, (int)1, null));
                Value value = response.getBody();
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type in.specmatic.core.value.JSONObjectValue");
                JSONObjectValue endpointData = (JSONObjectValue)value;
                Iterable $this$flatMap$iv = endpointData.getJSONObject("contexts").entrySet();
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    void $this$flatMapTo$iv$iv2;
                    void $this$flatMap$iv2;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    JSONObjectValue it;
                    void $this$mapTo$iv$iv;
                    Map.Entry it2 = (Map.Entry)element$iv$iv;
                    boolean bl = false;
                    Object v = it2.getValue();
                    Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type in.specmatic.core.value.JSONObjectValue");
                    Value value2 = ((JSONObjectValue)v).findFirstChildByPath("mappings.dispatcherServlets.dispatcherServlet");
                    Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type in.specmatic.core.value.JSONArrayValue");
                    JSONArrayValue mappings = (JSONArrayValue)value2;
                    Iterable $this$map$iv = mappings.getList();
                    boolean $i$f$map = false;
                    Iterable iterable2 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        Value value3 = (Value)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type in.specmatic.core.value.JSONObjectValue");
                        collection.add((JSONObjectValue)it);
                    }
                    $this$map$iv = (List)destination$iv$iv2;
                    boolean $i$f$filter = false;
                    $this$mapTo$iv$iv = $this$filter$iv;
                    destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                        String string;
                        it = (JSONObjectValue)element$iv$iv2;
                        boolean bl3 = false;
                        Value value4 = it.findFirstChildByPath("details.handlerMethod.className");
                        boolean bl4 = value4 != null && (string = value4.toStringLiteral()) != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"springframework", (boolean)false, (int)2, null) : false;
                        if (!(!bl4)) continue;
                        destination$iv$iv2.add(element$iv$iv2);
                    }
                    $this$filter$iv = (List)destination$iv$iv2;
                    boolean $i$f$flatMap2 = false;
                    $this$filterTo$iv$iv = $this$flatMap$iv2;
                    destination$iv$iv2 = new ArrayList();
                    boolean $i$f$flatMapTo2 = false;
                    for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                        List list;
                        it = (JSONObjectValue)element$iv$iv2;
                        boolean bl5 = false;
                        JSONArrayValue methods = (JSONArrayValue)it.findFirstChildByPath("details.requestMappingConditions.methods");
                        JSONArrayValue paths = (JSONArrayValue)it.findFirstChildByPath("details.requestMappingConditions.patterns");
                        if (methods != null && paths != null) {
                            void $this$flatMapTo$iv$iv3;
                            Iterable $this$flatMap$iv3 = methods.getList();
                            boolean $i$f$flatMap3 = false;
                            Iterable iterable3 = $this$flatMap$iv3;
                            Collection destination$iv$iv3 = new ArrayList();
                            boolean $i$f$flatMapTo3 = false;
                            for (Object element$iv$iv3 : $this$flatMapTo$iv$iv3) {
                                void $this$mapTo$iv$iv2;
                                Value method = (Value)element$iv$iv3;
                                boolean bl6 = false;
                                Iterable $this$map$iv2 = paths.getList();
                                boolean $i$f$map2 = false;
                                Iterable iterable4 = $this$map$iv2;
                                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                                boolean $i$f$mapTo2 = false;
                                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                                    void path;
                                    Value value5 = (Value)item$iv$iv;
                                    Collection collection = destination$iv$iv4;
                                    boolean bl7 = false;
                                    collection.add(new API(method.toStringLiteral(), path.toStringLiteral()));
                                }
                                Iterable list$iv$iv = (List)destination$iv$iv4;
                                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                            }
                            list = (List)destination$iv$iv3;
                        } else {
                            list = CollectionsKt.emptyList();
                        }
                        Iterable list$iv$iv = list;
                        CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List apis = (List)destination$iv$iv;
                this.getTestReport().addAPIs(apis);
            } else {
                LoggingKt.getLogger().log("Endpoints API not found, cannot calculate actual coverage");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

