/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.git;

import in.specmatic.core.Configuration;
import in.specmatic.core.azure.AuthCredentials;
import in.specmatic.core.azure.NoGitAuthCredentials;
import in.specmatic.core.git.GitCommand;
import in.specmatic.core.git.NonZeroExitError;
import in.specmatic.core.log.LoggingKt;
import in.specmatic.core.utilities.ExternalCommand;
import in.specmatic.core.utilities.Utilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\u0000H\u0016J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0000H\u0016J!\u0010\u0015\u001a\u00020\u00032\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0017\"\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0015\u001a\u00020\u00032\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019H\u0002J+\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u001f\u0010\u001c\u001a\u00020\u00032\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0017\"\u00020\u0003\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010 \u001a\u00020\u0003H\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0003H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019H\u0016J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\u0006\u0010%\u001a\u00020\u0003J\b\u0010&\u001a\u00020\u0003H\u0016J\b\u0010'\u001a\u00020\u0003H\u0016J\u0010\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020\u0003H\u0016J\u0006\u0010*\u001a\u00020\u0000J\u0010\u0010+\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\b\u0010,\u001a\u00020\u0000H\u0016J\b\u0010-\u001a\u00020\u0000H\u0016J\b\u0010.\u001a\u00020\u0000H\u0016J\u001c\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0003002\u0006\u0010\"\u001a\u00020\u0003H\u0016J\b\u00101\u001a\u00020\u0000H\u0016J\b\u00102\u001a\u00020\u0000H\u0016J\b\u00103\u001a\u000204H\u0016J\u0018\u00105\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u00106\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0016J\b\u00107\u001a\u00020\u0003H\u0016J\b\u00108\u001a\u00020\u001eH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u00069"}, d2={"Lin/specmatic/core/git/SystemGit;", "Lin/specmatic/core/git/GitCommand;", "workingDirectory", "", "prefix", "authCredentials", "Lin/specmatic/core/azure/AuthCredentials;", "(Ljava/lang/String;Ljava/lang/String;Lin/specmatic/core/azure/AuthCredentials;)V", "getAuthCredentials", "()Lin/specmatic/core/azure/AuthCredentials;", "getWorkingDirectory", "()Ljava/lang/String;", "add", "relativePath", "checkout", "branchName", "clone", "gitRepositoryURI", "cloneDirectory", "Ljava/io/File;", "commit", "execute", "command", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "executeCommandWithWorkingDirectory", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "executeWithAuth", "exists", "", "treeish", "fetch", "fileIsInGitDir", "newerContractPath", "getChangedFiles", "getChangesFromMainBranch", "mainBranch", "getCurrentBranch", "gitRoot", "inGitRootOf", "contractPath", "init", "merge", "mergeAbort", "pull", "push", "relativeGitPath", "Lkotlin/Pair;", "resetHard", "resetMixed", "revisionsBehindCount", "", "shallowClone", "show", "statusPorcelain", "workingDirectoryIsGitRepo", "core"})
public final class SystemGit
implements GitCommand {
    @NotNull
    private final String workingDirectory;
    @NotNull
    private final String prefix;
    @NotNull
    private final AuthCredentials authCredentials;

    public SystemGit(@NotNull String workingDirectory, @NotNull String prefix2, @NotNull AuthCredentials authCredentials) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)authCredentials, (String)"authCredentials");
        this.workingDirectory = workingDirectory;
        this.prefix = prefix2;
        this.authCredentials = authCredentials;
    }

    public /* synthetic */ SystemGit(String string, String string2, AuthCredentials authCredentials, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = ".";
        }
        if ((n & 2) != 0) {
            string2 = "- ";
        }
        if ((n & 4) != 0) {
            authCredentials = NoGitAuthCredentials.INSTANCE;
        }
        this(string, string2, authCredentials);
    }

    @Override
    @NotNull
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    @NotNull
    public final AuthCredentials getAuthCredentials() {
        return this.authCredentials;
    }

    @NotNull
    public final String executeWithAuth(String ... command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        List gitExecutable = CollectionsKt.listOf((Object)Configuration.Companion.getGitCommand());
        List<String> auth = this.authCredentials.gitCommandAuthHeaders();
        return this.execute(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)gitExecutable, (Iterable)auth), (Iterable)ArraysKt.toList((Object[])command)));
    }

    private final String execute(List<String> command) {
        Collection $this$toTypedArray$iv = CollectionsKt.toList((Iterable)command);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return this.executeCommandWithWorkingDirectory(this.prefix, this.getWorkingDirectory(), thisCollection$iv.toArray(new String[0]));
    }

    private final String execute(String ... command) {
        Collection $this$toTypedArray$iv = ArraysKt.toList((Object[])command);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return this.executeCommandWithWorkingDirectory(this.prefix, this.getWorkingDirectory(), thisCollection$iv.toArray(new String[0]));
    }

    private final String executeCommandWithWorkingDirectory(String prefix2, String workingDirectory, String[] command) {
        LoggingKt.getLogger().debug(prefix2 + "Executing: " + ArraysKt.joinToString$default((Object[])command, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        Collection $this$toTypedArray$iv = CollectionsKt.listOf((Object)"GIT_SSL_NO_VERIFY=true");
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new ExternalCommand(command, workingDirectory, thisCollection$iv.toArray(new String[0])).executeAsSeparateProcess();
    }

    @NotNull
    public final SystemGit init() {
        SystemGit systemGit;
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "init"};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit add() {
        SystemGit systemGit;
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "add", "."};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit add(@NotNull String relativePath) {
        SystemGit systemGit;
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "add", relativePath};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit commit() {
        SystemGit systemGit;
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "commit", "-m", "Updated contract"};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit push() {
        SystemGit systemGit;
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "push"};
        this.executeWithAuth(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit pull() {
        SystemGit systemGit;
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "pull"};
        this.executeWithAuth(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit resetHard() {
        SystemGit systemGit;
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "reset", "--hard", "HEAD"};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit resetMixed() {
        SystemGit systemGit;
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "reset", "--mixed", "HEAD"};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit mergeAbort() {
        SystemGit systemGit;
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "merge", "--aborg"};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit checkout(@NotNull String branchName) {
        SystemGit systemGit;
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "checkout", branchName};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit merge(@NotNull String branchName) {
        SystemGit systemGit;
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "merge", branchName};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit clone(@NotNull String gitRepositoryURI, @NotNull File cloneDirectory) {
        SystemGit systemGit;
        Intrinsics.checkNotNullParameter((Object)gitRepositoryURI, (String)"gitRepositoryURI");
        Intrinsics.checkNotNullParameter((Object)cloneDirectory, (String)"cloneDirectory");
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[3];
        stringArray[0] = "clone";
        stringArray[1] = gitRepositoryURI;
        Intrinsics.checkNotNullExpressionValue((Object)cloneDirectory.getAbsolutePath(), (String)"cloneDirectory.absolutePath");
        this.executeWithAuth(stringArray);
        return systemGit;
    }

    @Override
    public boolean exists(@NotNull String treeish, @NotNull String relativePath) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)treeish, (String)"treeish");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        try {
            this.show(treeish, relativePath);
            bl = true;
        }
        catch (NonZeroExitError e) {
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public String getCurrentBranch() {
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "git", "diff", "--name-only", "master"};
        return this.execute(stringArray);
    }

    @Override
    @NotNull
    public String statusPorcelain() {
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "status", "--porcelain"};
        return this.execute(stringArray);
    }

    @Override
    @NotNull
    public String fetch() {
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "fetch"};
        return this.execute(stringArray);
    }

    @Override
    public int revisionsBehindCount() {
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "rev-list", "--count", "HEAD..@{u}"};
        return Integer.parseInt(((Object)StringsKt.trim((CharSequence)this.execute(stringArray))).toString());
    }

    @Override
    @NotNull
    public SystemGit shallowClone(@NotNull String gitRepositoryURI, @NotNull File cloneDirectory) {
        SystemGit systemGit;
        Intrinsics.checkNotNullParameter((Object)gitRepositoryURI, (String)"gitRepositoryURI");
        Intrinsics.checkNotNullParameter((Object)cloneDirectory, (String)"cloneDirectory");
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[5];
        stringArray[0] = "clone";
        stringArray[1] = "--depth";
        stringArray[2] = "1";
        stringArray[3] = gitRepositoryURI;
        Intrinsics.checkNotNullExpressionValue((Object)cloneDirectory.getAbsolutePath(), (String)"cloneDirectory.absolutePath");
        this.executeWithAuth(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public String gitRoot() {
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "rev-parse", "--show-toplevel"};
        return ((Object)StringsKt.trim((CharSequence)this.execute(stringArray))).toString();
    }

    @Override
    @NotNull
    public String show(@NotNull String treeish, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)treeish, (String)"treeish");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "show", treeish + ':' + relativePath};
        return this.execute(stringArray);
    }

    @Override
    public boolean workingDirectoryIsGitRepo() {
        boolean bl;
        try {
            String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "rev-parse", "--is-inside-work-tree"};
            bl = Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)this.execute(stringArray))).toString(), (Object)"true");
        }
        catch (Throwable e) {
            boolean bl2;
            boolean it = bl2 = false;
            boolean bl3 = false;
            LoggingKt.getLogger().debug("This must not be a git dir, got error " + e.getClass().getName() + ": " + Utilities.exceptionCauseMessage(e));
            bl = bl2;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getChangedFiles() {
        void $this$mapTo$iv$iv;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "status", "--porcelain=1"};
        String result2 = ((Object)StringsKt.trim((CharSequence)this.execute(stringArray))).toString();
        if (((CharSequence)result2).length() == 0) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = StringsKt.lines((CharSequence)result2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{" "};
            collection.add((String)StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString(), (String[])stringArray2, (boolean)false, (int)2, (int)2, null).get(1));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public Pair<SystemGit, String> relativeGitPath(@NotNull String newerContractPath) {
        Intrinsics.checkNotNullParameter((Object)newerContractPath, (String)"newerContractPath");
        String string = new File(newerContractPath).getAbsoluteFile().getParent();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(newerContractPath).absoluteFile.parent");
        File gitRoot = new File(new SystemGit(string, null, null, 6, null).gitRoot());
        String string2 = gitRoot.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"gitRoot.absolutePath");
        SystemGit git = new SystemGit(string2, null, null, 6, null);
        File file = new File(newerContractPath).getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"File(newerContractPath).absoluteFile");
        File file2 = gitRoot.getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"gitRoot.absoluteFile");
        String relativeContractPath = FilesKt.relativeTo((File)file, (File)file2).getPath();
        return new Pair((Object)git, (Object)relativeContractPath);
    }

    @Override
    public boolean fileIsInGitDir(@NotNull String newerContractPath) {
        Intrinsics.checkNotNullParameter((Object)newerContractPath, (String)"newerContractPath");
        String parentDir = new File(newerContractPath).getAbsoluteFile().getParentFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)parentDir, (String)"parentDir");
        return new SystemGit(parentDir, null, null, 6, null).workingDirectoryIsGitRepo();
    }

    @Override
    @NotNull
    public GitCommand inGitRootOf(@NotNull String contractPath) {
        Intrinsics.checkNotNullParameter((Object)contractPath, (String)"contractPath");
        String string = new File(contractPath).getParentFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(contractPath).parentFile.absolutePath");
        return new SystemGit(string, null, null, 6, null);
    }

    @NotNull
    public final List<String> getChangesFromMainBranch(@NotNull String mainBranch) {
        Intrinsics.checkNotNullParameter((Object)mainBranch, (String)"mainBranch");
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "diff", "--name-only", mainBranch};
        CharSequence charSequence = this.execute(stringArray);
        stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)System.lineSeparator(), (String)"lineSeparator()");
        return StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
    }

    public SystemGit() {
        this(null, null, null, 7, null);
    }
}

