/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.log;

import in.specmatic.core.HttpRequest;
import in.specmatic.core.HttpResponse;
import in.specmatic.core.log.CurrentDate;
import in.specmatic.core.log.LogMessage;
import in.specmatic.core.value.JSONObjectValue;
import in.specmatic.core.value.StringValue;
import in.specmatic.stub.HttpStubResponse;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BA\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0005J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\bJ\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020\u001eJ\u0006\u0010%\u001a\u00020\u0003J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u0003H\u0016R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\r\"\u0004\b\u001b\u0010\u000fR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\r\u00a8\u0006)"}, d2={"Lin/specmatic/core/log/HttpLogMessage;", "Lin/specmatic/core/log/LogMessage;", "requestTime", "", "request", "Lin/specmatic/core/HttpRequest;", "responseTime", "response", "Lin/specmatic/core/HttpResponse;", "contractPath", "targetServer", "(Ljava/lang/String;Lin/specmatic/core/HttpRequest;Ljava/lang/String;Lin/specmatic/core/HttpResponse;Ljava/lang/String;Ljava/lang/String;)V", "getContractPath", "()Ljava/lang/String;", "setContractPath", "(Ljava/lang/String;)V", "getRequest", "()Lin/specmatic/core/HttpRequest;", "setRequest", "(Lin/specmatic/core/HttpRequest;)V", "getRequestTime", "setRequestTime", "getResponse", "()Lin/specmatic/core/HttpResponse;", "setResponse", "(Lin/specmatic/core/HttpResponse;)V", "getResponseTime", "setResponseTime", "getTargetServer", "addRequest", "", "httpRequest", "addResponse", "httpResponse", "stubResponse", "Lin/specmatic/stub/HttpStubResponse;", "logStartRequestTime", "target", "toJSONObject", "Lin/specmatic/core/value/JSONObjectValue;", "toLogString", "core"})
public final class HttpLogMessage
implements LogMessage {
    @NotNull
    private String requestTime;
    @NotNull
    private HttpRequest request;
    @NotNull
    private String responseTime;
    @NotNull
    private HttpResponse response;
    @NotNull
    private String contractPath;
    @NotNull
    private final String targetServer;

    public HttpLogMessage(@NotNull String requestTime, @NotNull HttpRequest request, @NotNull String responseTime, @NotNull HttpResponse response, @NotNull String contractPath, @NotNull String targetServer) {
        Intrinsics.checkNotNullParameter((Object)requestTime, (String)"requestTime");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)responseTime, (String)"responseTime");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)contractPath, (String)"contractPath");
        Intrinsics.checkNotNullParameter((Object)targetServer, (String)"targetServer");
        this.requestTime = requestTime;
        this.request = request;
        this.responseTime = responseTime;
        this.response = response;
        this.contractPath = contractPath;
        this.targetServer = targetServer;
    }

    public /* synthetic */ HttpLogMessage(String string, HttpRequest httpRequest, String string2, HttpResponse httpResponse, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            httpRequest = new HttpRequest(null, null, null, null, null, null, null, 127, null);
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            httpResponse = HttpResponse.Companion.getOK();
        }
        if ((n & 0x10) != 0) {
            string3 = "";
        }
        if ((n & 0x20) != 0) {
            string4 = "";
        }
        this(string, httpRequest, string2, httpResponse, string3, string4);
    }

    @NotNull
    public final String getRequestTime() {
        return this.requestTime;
    }

    public final void setRequestTime(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.requestTime = string;
    }

    @NotNull
    public final HttpRequest getRequest() {
        return this.request;
    }

    public final void setRequest(@NotNull HttpRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"<set-?>");
        this.request = httpRequest;
    }

    @NotNull
    public final String getResponseTime() {
        return this.responseTime;
    }

    public final void setResponseTime(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.responseTime = string;
    }

    @NotNull
    public final HttpResponse getResponse() {
        return this.response;
    }

    public final void setResponse(@NotNull HttpResponse httpResponse) {
        Intrinsics.checkNotNullParameter((Object)httpResponse, (String)"<set-?>");
        this.response = httpResponse;
    }

    @NotNull
    public final String getContractPath() {
        return this.contractPath;
    }

    public final void setContractPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.contractPath = string;
    }

    @NotNull
    public final String getTargetServer() {
        return this.targetServer;
    }

    public final void addRequest(@NotNull HttpRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        this.requestTime = new CurrentDate(null, 1, null).toLogString();
        this.request = httpRequest;
    }

    public final void addRequest(@NotNull HttpRequest httpRequest, @NotNull String requestTime) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        Intrinsics.checkNotNullParameter((Object)requestTime, (String)"requestTime");
        this.requestTime = requestTime;
        this.request = httpRequest;
    }

    public final void addResponse(@NotNull HttpResponse httpResponse) {
        Intrinsics.checkNotNullParameter((Object)httpResponse, (String)"httpResponse");
        this.responseTime = new CurrentDate(null, 1, null).toLogString();
        this.response = httpResponse;
    }

    @NotNull
    public final String target() {
        return !StringsKt.isBlank((CharSequence)this.targetServer) ? "to " + this.targetServer + ' ' : "";
    }

    @Override
    @NotNull
    public String toLogString() {
        List list;
        String linePrefix = "  ";
        Object[] objectArray = new String[]{"", "--------------------"};
        List messagePrefix = CollectionsKt.listOf((Object[])objectArray);
        if (!StringsKt.isBlank((CharSequence)this.contractPath)) {
            Object[] objectArray2 = new String[]{linePrefix + "Contract matched: " + this.contractPath, ""};
            list = CollectionsKt.listOf((Object[])objectArray2);
        } else {
            list = CollectionsKt.emptyList();
        }
        List contractPathLines = list;
        Object[] objectArray3 = new String[]{linePrefix + "Request " + this.target() + "at " + this.requestTime, this.request.toLogString(linePrefix + linePrefix), "", linePrefix + "Response at " + this.responseTime, this.response.toLogString(linePrefix + linePrefix)};
        List mainMessage = CollectionsKt.listOf((Object[])objectArray3);
        List messageSuffix = CollectionsKt.listOf((Object)"");
        Iterable iterable = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)messagePrefix, (Iterable)contractPathLines), (Iterable)mainMessage), (Iterable)messageSuffix);
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator()");
        return CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
    }

    @Override
    @NotNull
    public JSONObjectValue toJSONObject() {
        Map log = new LinkedHashMap();
        log.put("requestTime", new StringValue(this.requestTime));
        log.put("http-request", this.request.toJSON());
        log.put("http-response", this.response.toJSON());
        log.put("responseTime", new StringValue(this.responseTime));
        log.put("contractMatched", new StringValue(this.contractPath));
        return new JSONObjectValue(MapsKt.toMap((Map)log));
    }

    public final void addResponse(@NotNull HttpStubResponse stubResponse2) {
        Intrinsics.checkNotNullParameter((Object)stubResponse2, (String)"stubResponse");
        this.addResponse(stubResponse2.getResponse());
        this.contractPath = stubResponse2.getContractPath();
    }

    public final void logStartRequestTime() {
        this.requestTime = new CurrentDate(null, 1, null).toLogString();
    }

    public HttpLogMessage() {
        this(null, null, null, null, null, null, 63, null);
    }
}

