/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.utilities;

import in.specmatic.core.pattern.GrammarKt;
import in.specmatic.core.utilities.URIUtils;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\n\u001a\u00020\u0005J\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t2\b\u0010\f\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\r"}, d2={"Lin/specmatic/core/utilities/URIUtils;", "", "()V", "getNameAndType", "", "", "placeHolder", "(Ljava/lang/String;)[Ljava/lang/String;", "parsePathParams", "", "rawPath", "parseQuery", "query", "core"})
public final class URIUtils {
    @NotNull
    public static final URIUtils INSTANCE = new URIUtils();

    private URIUtils() {
    }

    @NotNull
    public final Map<String, String> parseQuery(@Nullable String query2) {
        if (query2 == null) {
            return MapsKt.emptyMap();
        }
        CharSequence charSequence = query2;
        Regex regex = new Regex("&");
        int n = 0;
        Collection $this$toTypedArray$iv = regex.split(charSequence, n);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] pairs = thisCollection$iv.toArray(new String[0]);
        HashMap queryParams = new HashMap();
        for (String pair : pairs) {
            String string;
            String string2;
            int idx = StringsKt.indexOf$default((CharSequence)pair, (String)"=", (int)0, (boolean)false, (int)6, null);
            if (idx < 0) {
                throw new Exception("a part of the query string does not seem to be a key-value pair: " + pair);
            }
            Map map = queryParams;
            String string3 = pair.substring(0, idx);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Intrinsics.checkNotNullExpressionValue((Object)URLDecoder.decode(string3, StandardCharsets.UTF_8.toString()), (String)"decode(pair.substring(0,\u2026harsets.UTF_8.toString())");
            String string4 = pair.substring(idx + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            Intrinsics.checkNotNullExpressionValue((Object)URLDecoder.decode(string4, StandardCharsets.UTF_8.toString()), (String)"decode(pair.substring(id\u2026harsets.UTF_8.toString())");
            map.put(string2, string);
        }
        return queryParams;
    }

    @NotNull
    public final Map<String, String> parsePathParams(@NotNull String rawPath) {
        Intrinsics.checkNotNullParameter((Object)rawPath, (String)"rawPath");
        CharSequence charSequence = rawPath;
        Regex regex = new Regex("/");
        int n = 0;
        Collection $this$toTypedArray$iv = regex.split(charSequence, n);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] pathParts = thisCollection$iv.toArray(new String[0]);
        HashMap pathParams = new HashMap();
        for (String pathPart : Arrays.stream(pathParts).filter(arg_0 -> URIUtils.parsePathParams$lambda$0(parsePathParams.1.INSTANCE, arg_0)).collect(Collectors.toList())) {
            Intrinsics.checkNotNullExpressionValue((Object)pathPart, (String)"pathPart");
            String[] nameAndType = this.getNameAndType(pathPart);
            ((Map)pathParams).put(nameAndType[0], '(' + nameAndType[1] + ')');
        }
        return pathParams;
    }

    private final String[] getNameAndType(String placeHolder) {
        CharSequence charSequence = GrammarKt.withoutPatternDelimiters(placeHolder);
        Regex regex = new Regex(":");
        int n = 0;
        Collection $this$toTypedArray$iv = regex.split(charSequence, n);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    private static final boolean parsePathParams$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

