/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.utilities;

import in.specmatic.core.Configuration;
import in.specmatic.core.HttpRequestKt;
import in.specmatic.core.Resolver;
import in.specmatic.core.Source;
import in.specmatic.core.SourceProvider;
import in.specmatic.core.SpecmaticConfigJson;
import in.specmatic.core.SpecmaticConfigKt;
import in.specmatic.core.git.GitCommand;
import in.specmatic.core.git.SystemGit;
import in.specmatic.core.log.LogStrategy;
import in.specmatic.core.log.LoggingKt;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.pattern.GrammarKt;
import in.specmatic.core.pattern.NullPattern;
import in.specmatic.core.pattern.NumberPattern;
import in.specmatic.core.utilities.ContractPathData;
import in.specmatic.core.utilities.ContractSource;
import in.specmatic.core.utilities.ContractsSelectorPredicate;
import in.specmatic.core.utilities.GitMonoRepo;
import in.specmatic.core.utilities.GitRepo;
import in.specmatic.core.utilities.Utilities;
import in.specmatic.core.value.JSONArrayValue;
import in.specmatic.core.value.JSONObjectValue;
import in.specmatic.core.value.StringValue;
import in.specmatic.core.value.Value;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportHttp;
import org.eclipse.jgit.transport.sshd.SshdSessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u009c\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f\u001a\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0001\u001a\u000e\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019\u001a\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\f\u001a\u0016\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u0001\u001a\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0001\u001a\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0001\u001a\u0012\u0010%\u001a\u00020&2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u0001\u001a\u0006\u0010(\u001a\u00020\u0001\u001a\u0018\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0001H\u0000\u001a\u000e\u0010/\u001a\u00020-2\u0006\u00100\u001a\u000201\u001a\u0014\u00102\u001a\b\u0012\u0004\u0012\u0002030\f2\u0006\u00104\u001a\u000205\u001a\u0014\u00102\u001a\b\u0012\u0004\u0012\u0002030\f2\u0006\u00106\u001a\u00020-\u001a\u0014\u00102\u001a\b\u0012\u0004\u0012\u0002030\f2\u0006\u0010\u000e\u001a\u00020\u0001\u001a\u000e\u00107\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u0006\u00108\u001a\u000209\u001a\u000e\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u0001\u001a\u000e\u0010=\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u0001\u001a\u000e\u0010>\u001a\u00020;2\u0006\u0010?\u001a\u00020;\u001a\u000e\u0010>\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n\u001a\u001a\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\f\u001a\u0010\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020DH\u0000\u001a\u0010\u0010F\u001a\u00020D2\u0006\u0010E\u001a\u00020DH\u0000\u001a&\u0010G\u001a\u00020\u00012\u0006\u0010H\u001a\u00020I2\u0014\b\u0002\u0010J\u001a\u000e\u0012\u0004\u0012\u00020L\u0012\u0004\u0012\u00020\u00150KH\u0002\u001a\u000e\u0010G\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\n\u0010M\u001a\u00020\u0001*\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0002\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"contractDirectory", "", "contractFilePath", "getContractFilePath", "()Ljava/lang/String;", "currentDirectory", "defaultContractFilePath", "containsTextContent", "", "node", "Lorg/w3c/dom/Node;", "contractFilePathsFrom", "", "Lin/specmatic/core/utilities/ContractPathData;", "configFilePath", "workingDirectory", "selector", "Lin/specmatic/core/utilities/ContractsSelectorPredicate;", "contractStubPaths", "contractTestPathsFrom", "createIfDoesNotExist", "", "workingDirectoryPath", "exceptionCauseMessage", "e", "", "exceptionMessageStack", "messages", "exitIfDoesNotExist", "label", "filePath", "exitWithMessage", "", "message", "getSystemGit", "Lin/specmatic/core/git/GitCommand;", "path", "getTransportCallingCallback", "Lorg/eclipse/jgit/api/TransportConfigCallback;", "bearerToken", "gitRootDir", "isEmptyText", "it", "jsonArray", "source", "Lin/specmatic/core/value/JSONObjectValue;", "key", "loadConfigJSON", "configFile", "Ljava/io/File;", "loadSources", "Lin/specmatic/core/utilities/ContractSource;", "specmaticConfigJson", "Lin/specmatic/core/SpecmaticConfigJson;", "configJson", "messageStringFrom", "newXMLBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "parseXML", "Lorg/w3c/dom/Document;", "xmlData", "readFile", "removeIrrelevantNodes", "document", "strings", "list", "Lin/specmatic/core/value/Value;", "withNullPattern", "Lin/specmatic/core/Resolver;", "resolver", "withNumberType", "xmlToString", "domSource", "Ljavax/xml/transform/dom/DOMSource;", "configureTransformer", "Lkotlin/Function1;", "Ljavax/xml/transform/Transformer;", "capitalizeFirstChar", "core"})
@JvmName(name="Utilities")
public final class Utilities {
    @NotNull
    private static final String currentDirectory = "./";
    @NotNull
    private static final String contractDirectory = "contract";
    @NotNull
    private static final String defaultContractFilePath = "contract/service.contract";

    @NotNull
    public static final Void exitWithMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        LoggingKt.getLogger().log(message);
        System.exit(1);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    @NotNull
    public static final String messageStringFrom(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        List<String> messageStack = Utilities.exceptionMessageStack(e, CollectionsKt.emptyList());
        return ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)messageStack, (CharSequence)"; ", null, null, (int)0, null, (Function1)messageStringFrom.1.INSTANCE, (int)30, null))).toString();
    }

    @NotNull
    public static final String exceptionCauseMessage(@NotNull Throwable e) {
        String string;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e instanceof ContractException) {
            string = ((ContractException)e).report();
        } else {
            CharSequence charSequence;
            CharSequence charSequence2 = Utilities.messageStringFrom(e);
            if (charSequence2.length() == 0) {
                boolean bl = false;
                charSequence = "Exception class=" + e.getClass().getName();
            } else {
                charSequence = charSequence2;
            }
            string = (String)charSequence;
        }
        return string;
    }

    @NotNull
    public static final List<String> exceptionMessageStack(@NotNull Throwable e, @NotNull List<String> messages) {
        String message;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        String string = e.getLocalizedMessage();
        if (string == null) {
            string = e.getMessage();
        }
        List<String> newMessages = (message = string) != null ? CollectionsKt.plus((Collection)messages, (Object)message) : messages;
        Throwable cause = e.getCause();
        return cause == null ? newMessages : Utilities.exceptionMessageStack(cause, newMessages);
    }

    @NotNull
    public static final String readFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return ((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)new File(filePath), null, (int)1, null))).toString();
    }

    @NotNull
    public static final Document parseXML(@NotNull String xmlData) {
        Intrinsics.checkNotNullParameter((Object)xmlData, (String)"xmlData");
        DocumentBuilder builder = Utilities.newXMLBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xmlData)));
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"builder.parse(InputSource(StringReader(xmlData)))");
        return Utilities.removeIrrelevantNodes(document);
    }

    @NotNull
    public static final DocumentBuilder newXMLBuilder() {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        builder.setErrorHandler(null);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
        return builder;
    }

    @NotNull
    public static final Document removeIrrelevantNodes(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Element element = document.getDocumentElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"document.documentElement");
        Utilities.removeIrrelevantNodes(element);
        return document;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Node removeIrrelevantNodes(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node.hasChildNodes() && !Utilities.containsTextContent(node)) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)node.getChildNodes().getLength());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void i;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(node.getChildNodes().item((int)i));
            }
            List childNodes = (List)destination$iv$iv;
            Iterable $this$forEach$iv = childNodes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Node it = (Node)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (Utilities.isEmptyText(it, node) || it.getNodeType() == 8) {
                    node.removeChild(it);
                    continue;
                }
                if (!it.hasChildNodes()) continue;
                Utilities.removeIrrelevantNodes(it);
            }
        }
        return node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isEmptyText(Node it, Node node) {
        if (it.getNodeType() != 3) return false;
        if (node.getNodeType() != 1) return false;
        String string = it.getTextContent();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.textContent");
        if (!StringsKt.isBlank((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString())) return false;
        return true;
    }

    private static final boolean containsTextContent(Node node) {
        return node.getChildNodes().getLength() == 1 && node.getFirstChild().getNodeType() == 3 && node.getNodeType() == 1;
    }

    @NotNull
    public static final String xmlToString(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return Utilities.xmlToString$default(new DOMSource(node), null, 2, null);
    }

    private static final String xmlToString(DOMSource domSource, Function1<? super Transformer, Unit> configureTransformer) {
        StringWriter writer = new StringWriter();
        StreamResult result2 = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        Intrinsics.checkNotNullExpressionValue((Object)transformer, (String)"transformer");
        configureTransformer.invoke((Object)transformer);
        transformer.transform(domSource, result2);
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writer.toString()");
        return string;
    }

    static /* synthetic */ String xmlToString$default(DOMSource dOMSource, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = xmlToString.1.INSTANCE;
        }
        return Utilities.xmlToString(dOMSource, (Function1<? super Transformer, Unit>)function1);
    }

    @NotNull
    public static final String getContractFilePath() {
        return "./contract/service.contract";
    }

    @NotNull
    public static final TransportConfigCallback getTransportCallingCallback(@Nullable String bearerToken) {
        return arg_0 -> Utilities.getTransportCallingCallback$lambda$3(bearerToken, arg_0);
    }

    public static /* synthetic */ TransportConfigCallback getTransportCallingCallback$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return Utilities.getTransportCallingCallback(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> strings(@NotNull List<? extends Value> list) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Value value2 = (Value)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (!(it instanceof StringValue)) {
                Utilities.exitWithMessage("All members of the paths array must be strings, but found one (" + it.toStringLiteral() + ") which was not");
                throw new KotlinNothingValueException();
            }
            collection.add(((StringValue)it).getString());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<ContractSource> loadSources(@NotNull String configFilePath) {
        Intrinsics.checkNotNullParameter((Object)configFilePath, (String)"configFilePath");
        return Utilities.loadSources(SpecmaticConfigKt.loadSpecmaticJsonConfig(configFilePath));
    }

    @NotNull
    public static final JSONObjectValue loadConfigJSON(@NotNull File configFile) {
        Value value2;
        Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
        try {
            value2 = GrammarKt.parsedJSON$default(FilesKt.readText$default((File)configFile, null, (int)1, null), null, 2, null);
        }
        catch (Throwable e) {
            throw new ContractException("Error reading the " + Configuration.Companion.getGlobalConfigFileName() + ": " + Utilities.exceptionCauseMessage(e), null, e, null, false, 26, null);
        }
        Value configJson = value2;
        if (!(configJson instanceof JSONObjectValue)) {
            throw new ContractException("The contents of " + Configuration.Companion.getGlobalConfigFileName() + " must be a json object", null, null, null, false, 30, null);
        }
        return (JSONObjectValue)configJson;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ContractSource> loadSources(@NotNull SpecmaticConfigJson specmaticConfigJson) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)specmaticConfigJson, (String)"specmaticConfigJson");
        Iterable $this$map$iv = specmaticConfigJson.getSources();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            List testPaths;
            List stubPaths;
            void source;
            Source source2 = (Source)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (WhenMappings.$EnumSwitchMapping$0[source.getProvider().ordinal()] == 1) {
                List list;
                List list2 = source.getStub();
                if (list2 == null) {
                    list2 = stubPaths = CollectionsKt.emptyList();
                }
                if ((list = source.getTest()) == null) {
                    list = testPaths = CollectionsKt.emptyList();
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(source.getRepository() == null ? (ContractSource)new GitMonoRepo(testPaths, stubPaths) : (ContractSource)new GitRepo(source.getRepository(), testPaths, stubPaths));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ContractSource> loadSources(@NotNull JSONObjectValue configJson) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)configJson, (String)"configJson");
        Value sources = configJson.getJsonObject().getOrDefault("sources", null);
        if (!(sources instanceof JSONArrayValue)) {
            throw new ContractException("The \"sources\" key must hold a list of sources.", null, null, null, false, 30, null);
        }
        Iterable $this$map$iv = ((JSONArrayValue)sources).getList();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            List<String> testPaths;
            List<String> stubPaths;
            String repositoryURL;
            void source;
            Value value2 = (Value)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (!(source instanceof JSONObjectValue)) {
                throw new ContractException("Every element of the sources json array must be a json object, but got this: " + source.toStringLiteral(), null, null, null, false, 30, null);
            }
            if (Intrinsics.areEqual((Object)HttpRequestKt.nativeString(((JSONObjectValue)source).getJsonObject(), "provider"), (Object)"git")) {
                repositoryURL = HttpRequestKt.nativeString(((JSONObjectValue)source).getJsonObject(), "repository");
                stubPaths = Utilities.jsonArray((JSONObjectValue)source, "stub");
                testPaths = Utilities.jsonArray((JSONObjectValue)source, "test");
            } else {
                throw new ContractException("Provider " + HttpRequestKt.nativeString(((JSONObjectValue)source).getJsonObject(), "provider") + " not recognised in " + Configuration.Companion.getGlobalConfigFileName(), null, null, null, false, 30, null);
            }
            collection.add(repositoryURL == null ? (ContractSource)new GitMonoRepo(testPaths, stubPaths) : (ContractSource)new GitRepo(repositoryURL, testPaths, stubPaths));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> jsonArray(@NotNull JSONObjectValue source, @NotNull String key2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Value value2 = source.getJsonObject().get(key2);
        if (value2 instanceof JSONArrayValue) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((JSONArrayValue)value2).getList();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Value value3 = (Value)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toStringLiteral());
            }
            list = (List)destination$iv$iv;
        } else if (value2 == null) {
            list = CollectionsKt.emptyList();
        } else {
            throw new ContractException("Expected " + key2 + " to be an array", null, null, null, false, 30, null);
        }
        return list;
    }

    public static final void createIfDoesNotExist(@NotNull String workingDirectoryPath) {
        Intrinsics.checkNotNullParameter((Object)workingDirectoryPath, (String)"workingDirectoryPath");
        File workingDirectory = new File(workingDirectoryPath);
        if (!workingDirectory.exists()) {
            try {
                workingDirectory.mkdirs();
            }
            catch (Throwable e) {
                Utilities.exitWithMessage(Utilities.exceptionCauseMessage(e));
                throw new KotlinNothingValueException();
            }
        }
    }

    public static final void exitIfDoesNotExist(@NotNull String label, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (!new File(filePath).exists()) {
            Utilities.exitWithMessage(Utilities.capitalizeFirstChar(label) + ' ' + filePath + " does not exist");
            throw new KotlinNothingValueException();
        }
    }

    @NotNull
    public static final List<ContractPathData> contractStubPaths() {
        return Utilities.contractFilePathsFrom(Configuration.Companion.getGlobalConfigFileName(), ".specmatic", Utilities::contractStubPaths$lambda$8);
    }

    @NotNull
    public static final List<ContractPathData> contractTestPathsFrom(@NotNull String configFilePath, @NotNull String workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)configFilePath, (String)"configFilePath");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        return Utilities.contractFilePathsFrom(configFilePath, workingDirectory, Utilities::contractTestPathsFrom$lambda$9);
    }

    @NotNull
    public static final String gitRootDir() {
        String gitRoot = new SystemGit(null, null, null, 7, null).gitRoot();
        String string = gitRoot.substring(StringsKt.lastIndexOf$default((CharSequence)gitRoot, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ContractPathData> contractFilePathsFrom(@NotNull String configFilePath, @NotNull String workingDirectory, @NotNull ContractsSelectorPredicate selector) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)configFilePath, (String)"configFilePath");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        LoggingKt.getLogger().log("Loading config file " + configFilePath);
        List<ContractSource> sources = Utilities.loadSources(configFilePath);
        Iterable $this$flatMap$iv = sources;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ContractSource it = (ContractSource)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.loadContracts(selector, workingDirectory, configFilePath);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List contractPathData = (List)destination$iv$iv;
        LoggingKt.getLogger().debug("Contract file paths in " + configFilePath + ':');
        LogStrategy logStrategy = LoggingKt.getLogger();
        Iterable iterable2 = contractPathData;
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator()");
        logStrategy.debug(StringsKt.prependIndent((String)CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)string, null, null, (int)0, null, (Function1)contractFilePathsFrom.1.INSTANCE, (int)30, null), (String)"  "));
        return contractPathData;
    }

    @NotNull
    public static final GitCommand getSystemGit(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return new SystemGit(path2, null, null, 6, null);
    }

    @NotNull
    public static final Resolver withNullPattern(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return Resolver.copy$default(resolver, null, false, MapsKt.plus(resolver.getNewPatterns(), (Pair)TuplesKt.to((Object)"(empty)", (Object)NullPattern.INSTANCE)), null, null, null, false, null, null, false, null, 2043, null);
    }

    @NotNull
    public static final Resolver withNumberType(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return Resolver.copy$default(resolver, null, false, MapsKt.plus(resolver.getNewPatterns(), (Pair)TuplesKt.to((Object)"(number)", (Object)new NumberPattern(null, null, null, 7, null))), null, null, null, false, null, null, false, null, 2043, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String capitalizeFirstChar(@NotNull String $this$capitalizeFirstChar) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$capitalizeFirstChar, (String)"<this>");
        String string2 = $this$capitalizeFirstChar;
        if (((CharSequence)string2).length() > 0) {
            void it;
            char c = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            String string3 = String.valueOf((char)it);
            Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type java.lang.String");
            String string4 = string3.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string4);
            String string5 = string2;
            int n = 1;
            String string6 = string5.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
            string = stringBuilder2.append(string6).toString();
        } else {
            string = string2;
        }
        return string;
    }

    private static final void getTransportCallingCallback$lambda$3(String $bearerToken, Transport transport) {
        if (transport instanceof SshTransport) {
            ((SshTransport)transport).setSshSessionFactory((SshSessionFactory)new SshdSessionFactory());
        } else if ($bearerToken != null && transport instanceof TransportHttp) {
            LoggingKt.getLogger().debug("Setting Authorization header");
            ((TransportHttp)transport).setAdditionalHeaders(MapsKt.mapOf((Pair)TuplesKt.to((Object)"Authorization", (Object)("Bearer " + $bearerToken))));
        }
    }

    private static final List contractStubPaths$lambda$8(ContractSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return source.getStubContracts();
    }

    private static final List contractTestPathsFrom$lambda$9(ContractSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return source.getTestContracts();
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SourceProvider.values().length];
            try {
                nArray[SourceProvider.git.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

