/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core;

import in.specmatic.core.Feature;
import in.specmatic.core.FeatureKt;
import in.specmatic.core.Result;
import in.specmatic.core.Results;
import in.specmatic.core.Scenario;
import in.specmatic.core.ScenarioKt;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.pattern.KafkaMessagePattern;
import in.specmatic.stub.HttpStub;
import in.specmatic.test.HttpClient;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J\t\u0010\u0015\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lin/specmatic/core/Contract;", "", "contract", "Lin/specmatic/core/Feature;", "(Lin/specmatic/core/Feature;)V", "getContract", "()Lin/specmatic/core/Feature;", "component1", "copy", "equals", "", "other", "hashCode", "", "samples", "", "fake", "Lin/specmatic/stub/HttpStub;", "endPoint", "", "test", "toString", "Companion", "core"})
public final class Contract {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Feature contract;

    public Contract(@NotNull Feature contract) {
        Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
        this.contract = contract;
    }

    @NotNull
    public final Feature getContract() {
        return this.contract;
    }

    public final void test(@NotNull String endPoint) {
        Intrinsics.checkNotNullParameter((Object)endPoint, (String)"endPoint");
        Feature contractBehaviour = this.contract;
        Results results2 = Feature.executeTests$default(contractBehaviour, new HttpClient(endPoint, 0, null, null, 14, null), null, 2, null);
        if (results2.hasFailures()) {
            throw new ContractException(results2.report("Match not found"), null, null, null, false, 30, null);
        }
    }

    public final void test(@NotNull HttpStub fake) {
        Intrinsics.checkNotNullParameter((Object)fake, (String)"fake");
        this.test(fake.getEndPoint());
    }

    public final void samples(@NotNull HttpStub fake) {
        Intrinsics.checkNotNullParameter((Object)fake, (String)"fake");
        this.samples(fake.getEndPoint());
    }

    /*
     * WARNING - void declaration
     */
    public final void samples(@NotNull String endPoint) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)endPoint, (String)"endPoint");
        Feature contractBehaviour = this.contract;
        HttpClient httpClient = new HttpClient(endPoint, 0, null, null, 14, null);
        Iterable iterable = contractBehaviour.generateContractTestScenarios(CollectionsKt.emptyList());
        Results initial$iv = new Results(null, 1, null);
        boolean $i$f$fold = false;
        Results accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            Results results2;
            void scenario;
            Scenario scenario2 = (Scenario)element$iv;
            Results results3 = accumulator$iv;
            boolean bl = false;
            KafkaMessagePattern kafkaMessagePattern = scenario.getKafkaMessagePattern();
            if (kafkaMessagePattern == null) {
                results2 = new Results(CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)results3.getResults(), (Object)ScenarioKt.executeTest((Scenario)scenario, httpClient))));
            } else {
                String message = StringsKt.prependIndent((String)StringsKt.trimMargin$default((String)("KAFKA MESSAGE\n" + kafkaMessagePattern.generate(scenario.getResolver()).toDisplayableString()), null, (int)1, null), (String)"| ");
                System.out.println((Object)message);
                results2 = new Results(CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)results3.getResults(), (Object)new Result.Success(null, null, 3, null))));
            }
            accumulator$iv = results2;
        }
    }

    @NotNull
    public final Feature component1() {
        return this.contract;
    }

    @NotNull
    public final Contract copy(@NotNull Feature contract) {
        Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
        return new Contract(contract);
    }

    public static /* synthetic */ Contract copy$default(Contract contract, Feature feature, int n, Object object) {
        if ((n & 1) != 0) {
            feature = contract.contract;
        }
        return contract.copy(feature);
    }

    @NotNull
    public String toString() {
        return "Contract(contract=" + this.contract + ')';
    }

    public int hashCode() {
        return this.contract.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Contract)) {
            return false;
        }
        Contract contract = (Contract)other;
        return Intrinsics.areEqual((Object)this.contract, (Object)contract.contract);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lin/specmatic/core/Contract$Companion;", "", "()V", "fromGherkin", "Lin/specmatic/core/Contract;", "contractGherkin", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Contract fromGherkin(@NotNull String contractGherkin) {
            Intrinsics.checkNotNullParameter((Object)contractGherkin, (String)"contractGherkin");
            return new Contract(FeatureKt.parseGherkinStringToFeature$default(contractGherkin, null, 2, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

