/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core;

import in.specmatic.conversions.OpenAPISecurityScheme;
import in.specmatic.core.FailureReason;
import in.specmatic.core.HeaderMatchParams;
import in.specmatic.core.HttpHeadersPattern;
import in.specmatic.core.HttpRequest;
import in.specmatic.core.HttpRequestPattern;
import in.specmatic.core.HttpRequestPatternKt;
import in.specmatic.core.KeyError;
import in.specmatic.core.MatchFailure;
import in.specmatic.core.MatchSuccess;
import in.specmatic.core.MatchingResult;
import in.specmatic.core.MultiPartFormDataPattern;
import in.specmatic.core.MultiPartFormDataValue;
import in.specmatic.core.RailwayOrientedProgrammingKt;
import in.specmatic.core.Resolver;
import in.specmatic.core.Result;
import in.specmatic.core.ResultKt;
import in.specmatic.core.URLMatcher;
import in.specmatic.core.URLMatcherKt;
import in.specmatic.core.URLPathPattern;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.pattern.ContractExceptionKt;
import in.specmatic.core.pattern.DeferredPattern;
import in.specmatic.core.pattern.DeferredPatternKt;
import in.specmatic.core.pattern.EmptyStringPattern;
import in.specmatic.core.pattern.ExactValuePattern;
import in.specmatic.core.pattern.GrammarKt;
import in.specmatic.core.pattern.Pattern;
import in.specmatic.core.pattern.Row;
import in.specmatic.core.pattern.TabularPatternKt;
import in.specmatic.core.pattern.XMLPattern;
import in.specmatic.core.value.JSONObjectValue;
import in.specmatic.core.value.StringValue;
import in.specmatic.core.value.Value;
import io.ktor.util.TextKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001Bg\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u000b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r\u00a2\u0006\u0002\u0010\u0011J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010\"\u001a\u00020\tH\u00c6\u0003J\u0015\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u000bH\u00c6\u0003J\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0003J\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u00c6\u0003Jk\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u00c6\u0001J*\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u00072\b\u0010)\u001a\u0004\u0018\u00010\u00072\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020,H\u0002J\u0013\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0016\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u0002022\u0006\u0010+\u001a\u00020,J\u000e\u00100\u001a\u0002022\u0006\u0010+\u001a\u00020,J\t\u00103\u001a\u000204H\u00d6\u0001J\u0010\u00105\u001a\u00020.2\u0006\u00106\u001a\u000204H\u0002JF\u00107\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020,\u0012\n\u0012\b\u0012\u0004\u0012\u00020:0\r09082\u001e\u0010;\u001a\u001a\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020,\u0012\n\u0012\b\u0012\u0004\u0012\u00020:0\r09H\u0002JD\u0010<\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020,\u0012\n\u0012\b\u0012\u0004\u0012\u00020:0\r09082\u001e\u0010;\u001a\u001a\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020,\u0012\n\u0012\b\u0012\u0004\u0012\u00020:0\r09J.\u0010=\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020,\u0012\n\u0012\b\u0012\u0004\u0012\u00020:0\r09082\u0006\u0010;\u001a\u00020>H\u0002J:\u0010?\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020,\u0012\n\u0012\b\u0012\u0004\u0012\u00020:0\r09082\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020,0@H\u0002JF\u0010A\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020,\u0012\n\u0012\b\u0012\u0004\u0012\u00020:0\r09082\u001e\u0010;\u001a\u001a\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020,\u0012\n\u0012\b\u0012\u0004\u0012\u00020:0\r09H\u0002J.\u0010B\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020,0@082\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020,0@H\u0002JF\u0010C\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020,\u0012\n\u0012\b\u0012\u0004\u0012\u00020:0\r09082\u001e\u0010;\u001a\u001a\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020,\u0012\n\u0012\b\u0012\u0004\u0012\u00020:0\r09H\u0002JF\u0010D\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020,\u0012\n\u0012\b\u0012\u0004\u0012\u00020:0\r09082\u001e\u0010;\u001a\u001a\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020,\u0012\n\u0012\b\u0012\u0004\u0012\u00020:0\r09H\u0002J.\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u0002022\u0006\u0010+\u001a\u00020,2\n\b\u0002\u0010H\u001a\u0004\u0018\u00010,2\n\b\u0002\u0010I\u001a\u0004\u0018\u00010JJ\u000e\u0010K\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0000J\u001c\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00000\r2\u0006\u0010M\u001a\u00020N2\u0006\u0010+\u001a\u00020,J\u0014\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00000\r2\u0006\u0010+\u001a\u00020,J&\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00000\r2\u0006\u0010M\u001a\u00020N2\u0006\u0010P\u001a\u00020,2\b\b\u0002\u00106\u001a\u000204J\u0006\u0010Q\u001a\u00020\u0007J,\u0010R\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b2\u0014\u0010S\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bH\u0002J\t\u0010T\u001a\u00020\u0007H\u00d6\u0001JD\u0010U\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u000b2\u0012\u0010V\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000b2\u0012\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010+\u001a\u00020,H\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006X"}, d2={"Lin/specmatic/core/HttpRequestPattern;", "", "headersPattern", "Lin/specmatic/core/HttpHeadersPattern;", "urlMatcher", "Lin/specmatic/core/URLMatcher;", "method", "", "body", "Lin/specmatic/core/pattern/Pattern;", "formFieldsPattern", "", "multiPartFormDataPattern", "", "Lin/specmatic/core/MultiPartFormDataPattern;", "securitySchemes", "Lin/specmatic/conversions/OpenAPISecurityScheme;", "(Lin/specmatic/core/HttpHeadersPattern;Lin/specmatic/core/URLMatcher;Ljava/lang/String;Lin/specmatic/core/pattern/Pattern;Ljava/util/Map;Ljava/util/List;Ljava/util/List;)V", "getBody", "()Lin/specmatic/core/pattern/Pattern;", "getFormFieldsPattern", "()Ljava/util/Map;", "getHeadersPattern", "()Lin/specmatic/core/HttpHeadersPattern;", "getMethod", "()Ljava/lang/String;", "getMultiPartFormDataPattern", "()Ljava/util/List;", "getSecuritySchemes", "getUrlMatcher", "()Lin/specmatic/core/URLMatcher;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "encompassedType", "valueString", "key", "type", "resolver", "Lin/specmatic/core/Resolver;", "equals", "", "other", "generate", "request", "Lin/specmatic/core/HttpRequest;", "hashCode", "", "isInvalidRequestResponse", "status", "matchBody", "Lin/specmatic/core/MatchingResult;", "Lkotlin/Triple;", "Lin/specmatic/core/Result$Failure;", "parameters", "matchFormFields", "matchHeaders", "Lin/specmatic/core/HeaderMatchParams;", "matchMethod", "Lkotlin/Pair;", "matchMultiPartFormData", "matchPath", "matchQuery", "matchSecurityScheme", "matches", "Lin/specmatic/core/Result;", "incomingHttpRequest", "headersResolver", "requestBodyReqex", "Lkotlin/text/Regex;", "matchesSignature", "negativeBasedOn", "row", "Lin/specmatic/core/pattern/Row;", "newBasedOn", "initialResolver", "testDescription", "toLowerCaseKeys", "map", "toString", "toTypeMap", "values", "types", "core"})
public final class HttpRequestPattern {
    @NotNull
    private final HttpHeadersPattern headersPattern;
    @Nullable
    private final URLMatcher urlMatcher;
    @Nullable
    private final String method;
    @NotNull
    private final Pattern body;
    @NotNull
    private final Map<String, Pattern> formFieldsPattern;
    @NotNull
    private final List<MultiPartFormDataPattern> multiPartFormDataPattern;
    @NotNull
    private final List<OpenAPISecurityScheme> securitySchemes;

    public HttpRequestPattern(@NotNull HttpHeadersPattern headersPattern, @Nullable URLMatcher urlMatcher, @Nullable String method, @NotNull Pattern body, @NotNull Map<String, ? extends Pattern> formFieldsPattern, @NotNull List<? extends MultiPartFormDataPattern> multiPartFormDataPattern, @NotNull List<? extends OpenAPISecurityScheme> securitySchemes) {
        Intrinsics.checkNotNullParameter((Object)headersPattern, (String)"headersPattern");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter(formFieldsPattern, (String)"formFieldsPattern");
        Intrinsics.checkNotNullParameter(multiPartFormDataPattern, (String)"multiPartFormDataPattern");
        Intrinsics.checkNotNullParameter(securitySchemes, (String)"securitySchemes");
        this.headersPattern = headersPattern;
        this.urlMatcher = urlMatcher;
        this.method = method;
        this.body = body;
        this.formFieldsPattern = formFieldsPattern;
        this.multiPartFormDataPattern = multiPartFormDataPattern;
        this.securitySchemes = securitySchemes;
    }

    public /* synthetic */ HttpRequestPattern(HttpHeadersPattern httpHeadersPattern, URLMatcher uRLMatcher, String string, Pattern pattern2, Map map, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            httpHeadersPattern = new HttpHeadersPattern(null, null, 3, null);
        }
        if ((n & 2) != 0) {
            uRLMatcher = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            pattern2 = EmptyStringPattern.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(httpHeadersPattern, uRLMatcher, string, pattern2, map, list, list2);
    }

    @NotNull
    public final HttpHeadersPattern getHeadersPattern() {
        return this.headersPattern;
    }

    @Nullable
    public final URLMatcher getUrlMatcher() {
        return this.urlMatcher;
    }

    @Nullable
    public final String getMethod() {
        return this.method;
    }

    @NotNull
    public final Pattern getBody() {
        return this.body;
    }

    @NotNull
    public final Map<String, Pattern> getFormFieldsPattern() {
        return this.formFieldsPattern;
    }

    @NotNull
    public final List<MultiPartFormDataPattern> getMultiPartFormDataPattern() {
        return this.multiPartFormDataPattern;
    }

    @NotNull
    public final List<OpenAPISecurityScheme> getSecuritySchemes() {
        return this.securitySchemes;
    }

    @NotNull
    public final Result matches(@NotNull HttpRequest incomingHttpRequest, @NotNull Resolver resolver, @Nullable Resolver headersResolver, @Nullable Regex requestBodyReqex) {
        Intrinsics.checkNotNullParameter((Object)incomingHttpRequest, (String)"incomingHttpRequest");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Result result2 = RailwayOrientedProgrammingKt.toResult(RailwayOrientedProgrammingKt.otherwise(RailwayOrientedProgrammingKt.then(RailwayOrientedProgrammingKt.then(RailwayOrientedProgrammingKt.then(RailwayOrientedProgrammingKt.then(RailwayOrientedProgrammingKt.then(RailwayOrientedProgrammingKt.then(RailwayOrientedProgrammingKt.then(RailwayOrientedProgrammingKt.then(RailwayOrientedProgrammingKt.then(RailwayOrientedProgrammingKt.to(TuplesKt.to((Object)incomingHttpRequest, (Object)resolver), (Function1)new Function1<Pair<? extends HttpRequest, ? extends Resolver>, MatchingResult<Pair<? extends HttpRequest, ? extends Resolver>>>((Object)this){

            @NotNull
            public final MatchingResult<Pair<HttpRequest, Resolver>> invoke(@NotNull Pair<HttpRequest, Resolver> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return HttpRequestPattern.access$matchPath((HttpRequestPattern)this.receiver, p0);
            }
        }), (Function1)new Function1<Pair<? extends HttpRequest, ? extends Resolver>, MatchingResult<Triple<? extends HttpRequest, ? extends Resolver, ? extends List<? extends Result.Failure>>>>((Object)this){

            @NotNull
            public final MatchingResult<Triple<HttpRequest, Resolver, List<Result.Failure>>> invoke(@NotNull Pair<HttpRequest, Resolver> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return HttpRequestPattern.access$matchMethod((HttpRequestPattern)this.receiver, p0);
            }
        }), (Function1)new Function1<Triple<? extends HttpRequest, ? extends Resolver, ? extends List<? extends Result.Failure>>, MatchingResult<Triple<? extends HttpRequest, ? extends Resolver, ? extends List<? extends Result.Failure>>>>((Object)this){

            @NotNull
            public final MatchingResult<Triple<HttpRequest, Resolver, List<Result.Failure>>> invoke(@NotNull Triple<HttpRequest, Resolver, ? extends List<Result.Failure>> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return HttpRequestPattern.access$matchSecurityScheme((HttpRequestPattern)this.receiver, p0);
            }
        }), (Function1)new Function1<Triple<? extends HttpRequest, ? extends Resolver, ? extends List<? extends Result.Failure>>, MatchingResult<Triple<? extends HttpRequest, ? extends Resolver, ? extends List<? extends Result.Failure>>>>((Object)this){

            @NotNull
            public final MatchingResult<Triple<HttpRequest, Resolver, List<Result.Failure>>> invoke(@NotNull Triple<HttpRequest, Resolver, ? extends List<Result.Failure>> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return HttpRequestPattern.access$matchQuery((HttpRequestPattern)this.receiver, p0);
            }
        }), (Function1)new Function1<Triple<? extends HttpRequest, ? extends Resolver, ? extends List<? extends Result.Failure>>, MatchingResult<Triple<? extends HttpRequest, ? extends Resolver, ? extends List<? extends Result.Failure>>>>(this, headersResolver){
            final /* synthetic */ HttpRequestPattern this$0;
            final /* synthetic */ Resolver $headersResolver;
            {
                this.this$0 = $receiver;
                this.$headersResolver = $headersResolver;
                super(1);
            }

            @NotNull
            public final MatchingResult<Triple<HttpRequest, Resolver, List<Result.Failure>>> invoke(@NotNull Triple<HttpRequest, Resolver, ? extends List<Result.Failure>> triple) {
                Intrinsics.checkNotNullParameter(triple, (String)"<name for destructuring parameter 0>");
                HttpRequest request = (HttpRequest)triple.component1();
                Resolver defaultResolver = (Resolver)triple.component2();
                List failures2 = (List)triple.component3();
                return HttpRequestPattern.access$matchHeaders(this.this$0, new HeaderMatchParams(request, this.$headersResolver, defaultResolver, failures2));
            }
        }), (Function1)new Function1<Triple<? extends HttpRequest, ? extends Resolver, ? extends List<? extends Result.Failure>>, MatchingResult<Triple<? extends HttpRequest, ? extends Resolver, ? extends List<? extends Result.Failure>>>>((Object)this){

            @NotNull
            public final MatchingResult<Triple<HttpRequest, Resolver, List<Result.Failure>>> invoke(@NotNull Triple<HttpRequest, Resolver, ? extends List<Result.Failure>> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return ((HttpRequestPattern)this.receiver).matchFormFields(p0);
            }
        }), (Function1)new Function1<Triple<? extends HttpRequest, ? extends Resolver, ? extends List<? extends Result.Failure>>, MatchingResult<Triple<? extends HttpRequest, ? extends Resolver, ? extends List<? extends Result.Failure>>>>((Object)this){

            @NotNull
            public final MatchingResult<Triple<HttpRequest, Resolver, List<Result.Failure>>> invoke(@NotNull Triple<HttpRequest, Resolver, ? extends List<Result.Failure>> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return HttpRequestPattern.access$matchMultiPartFormData((HttpRequestPattern)this.receiver, p0);
            }
        }), (Function1)new Function1<Triple<? extends HttpRequest, ? extends Resolver, ? extends List<? extends Result.Failure>>, MatchingResult<Triple<? extends HttpRequest, ? extends Resolver, ? extends List<? extends Result.Failure>>>>((Object)this){

            @NotNull
            public final MatchingResult<Triple<HttpRequest, Resolver, List<Result.Failure>>> invoke(@NotNull Triple<HttpRequest, Resolver, ? extends List<Result.Failure>> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return HttpRequestPattern.access$matchBody((HttpRequestPattern)this.receiver, p0);
            }
        }), (Function1)new Function1<Triple<? extends HttpRequest, ? extends Resolver, ? extends List<? extends Result.Failure>>, MatchingResult<Triple<? extends HttpRequest, ? extends Resolver, ? extends List<? extends Result.Failure>>>>(requestBodyReqex){
            final /* synthetic */ Regex $requestBodyReqex;
            {
                this.$requestBodyReqex = $requestBodyReqex;
                super(1);
            }

            @NotNull
            public final MatchingResult<Triple<HttpRequest, Resolver, List<Result.Failure>>> invoke(@NotNull Triple<HttpRequest, Resolver, ? extends List<Result.Failure>> triple) {
                Intrinsics.checkNotNullParameter(triple, (String)"<name for destructuring parameter 0>");
                HttpRequest request = (HttpRequest)triple.component1();
                Resolver resolver = (Resolver)triple.component2();
                List failures2 = (List)triple.component3();
                Regex regex = this.$requestBodyReqex;
                return (regex != null ? !regex.matches((CharSequence)request.getBodyString()) : false) ? new MatchSuccess<Triple>(new Triple((Object)request, (Object)resolver, (Object)CollectionsKt.plus((Collection)failures2, (Object)new Result.Failure("Request did not match regex " + this.$requestBodyReqex, null, null, null, 14, null)))) : new MatchSuccess<Triple>(new Triple((Object)request, (Object)resolver, (Object)failures2));
            }
        }), matches.result.10.INSTANCE), matches.result.11.INSTANCE), (Function1<? super Result, ? extends Result>)((Function1)matches.result.12.INSTANCE));
        return result2 instanceof Result.Failure ? (Result)((Result.Failure)result2).breadCrumb("REQUEST") : result2;
    }

    public static /* synthetic */ Result matches$default(HttpRequestPattern httpRequestPattern, HttpRequest httpRequest, Resolver resolver, Resolver resolver2, Regex regex, int n, Object object) {
        if ((n & 4) != 0) {
            resolver2 = null;
        }
        if ((n & 8) != 0) {
            regex = null;
        }
        return httpRequestPattern.matches(httpRequest, resolver, resolver2, regex);
    }

    private final MatchingResult<Triple<HttpRequest, Resolver, List<Result.Failure>>> matchSecurityScheme(Triple<HttpRequest, Resolver, ? extends List<Result.Failure>> parameters) {
        Object v0;
        List failures2;
        Resolver resolver;
        HttpRequest httpRequest;
        block3: {
            httpRequest = (HttpRequest)parameters.component1();
            resolver = (Resolver)parameters.component2();
            failures2 = (List)parameters.component3();
            if (this.securitySchemes.isEmpty()) {
                return new MatchSuccess<Triple>(new Triple((Object)httpRequest, (Object)resolver, (Object)failures2));
            }
            Iterable iterable = this.securitySchemes;
            for (Object t : iterable) {
                OpenAPISecurityScheme it = (OpenAPISecurityScheme)t;
                boolean bl = false;
                if (!it.matches(httpRequest)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        OpenAPISecurityScheme openAPISecurityScheme = v0;
        if (openAPISecurityScheme == null) {
            return new MatchSuccess<Triple>(new Triple((Object)httpRequest, (Object)resolver, (Object)CollectionsKt.plus((Collection)failures2, (Object)new Result.Failure("No auth params were found in the request", null, null, null, 14, null))));
        }
        OpenAPISecurityScheme matchingSecurityScheme = openAPISecurityScheme;
        return new MatchSuccess<Triple>(new Triple((Object)matchingSecurityScheme.removeParam(httpRequest), (Object)resolver, (Object)failures2));
    }

    public final boolean matchesSignature(@NotNull HttpRequestPattern other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        URLMatcher uRLMatcher = this.urlMatcher;
        Intrinsics.checkNotNull((Object)uRLMatcher);
        String string = uRLMatcher.getPath();
        URLMatcher uRLMatcher2 = other.urlMatcher;
        Intrinsics.checkNotNull((Object)uRLMatcher2);
        return Intrinsics.areEqual((Object)string, (Object)uRLMatcher2.getPath()) && StringsKt.equals$default((String)this.method, (String)this.method, (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final MatchingResult<Triple<HttpRequest, Resolver, List<Result.Failure>>> matchMultiPartFormData(Triple<HttpRequest, Resolver, ? extends List<Result.Failure>> parameters) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$mapTo$iv$iv3;
        void $this$map$iv2;
        void $this$filterTo$iv$iv2;
        void $this$mapTo$iv$iv4;
        void $this$mapTo$iv$iv5;
        void $this$filterIsInstanceTo$iv$iv;
        Object result2;
        Collection collection;
        void $this$mapTo$iv$iv6;
        HttpRequest httpRequest = (HttpRequest)parameters.component1();
        Resolver resolver = (Resolver)parameters.component2();
        List failures2 = (List)parameters.component3();
        if (this.multiPartFormDataPattern.isEmpty() && httpRequest.getMultiPartFormData().isEmpty()) {
            return new MatchSuccess<Triple<HttpRequest, Resolver, ? extends List<Result.Failure>>>(parameters);
        }
        Iterable $this$map$iv3 = this.multiPartFormDataPattern;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv3;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv6) {
            Result result3;
            Result result4;
            Iterator<Object> iterator;
            List results2;
            void type;
            block16: {
                void $this$mapTo$iv$iv7;
                MultiPartFormDataPattern multiPartFormDataPattern = (MultiPartFormDataPattern)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv4 = httpRequest.getMultiPartFormData();
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv4;
                Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv7) {
                    void value2;
                    MultiPartFormDataValue multiPartFormDataValue = (MultiPartFormDataValue)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection2.add(type.matches((MultiPartFormDataValue)value2, resolver));
                }
                results2 = (List)destination$iv$iv2;
                destination$iv$iv2 = results2;
                for (Iterator<Object> iterator2 : destination$iv$iv2) {
                    Result it = (Result)((Object)iterator2);
                    boolean bl3 = false;
                    if (!(it instanceof Result.Success)) continue;
                    iterator = iterator2;
                    break block16;
                }
                iterator = null;
            }
            if ((result4 = (Result)((Object)iterator)) == null) {
                Result result5;
                Object object;
                block17: {
                    Iterator<Object> iterator2;
                    Iterable $i$f$mapTo2 = results2;
                    iterator2 = $i$f$mapTo2.iterator();
                    while (iterator2.hasNext()) {
                        Object object2 = iterator2.next();
                        Result it = (Result)object2;
                        boolean bl = false;
                        if (!(it instanceof Result.Failure && ((Result.Failure)it).getFailureReason() != FailureReason.PartNameMisMatch)) continue;
                        object = object2;
                        break block17;
                    }
                    object = null;
                }
                result4 = (result5 = (Result)object) != null && (result5 = result5.breadCrumb(type.getName())) != null ? result5.breadCrumb("MULTIPART-FORMDATA") : null;
            }
            if ((result3 = (result2 = result4)) == null) {
                result3 = GrammarKt.isOptional(type.getName()) ? new Result.Success(null, null, 3, null) : null;
            }
            collection.add(result3);
        }
        List results3 = (List)destination$iv$iv;
        Iterable $this$filterIsInstance$iv = results3;
        boolean $i$f$filterIsInstance = false;
        destination$iv$iv = $this$filterIsInstance$iv;
        Iterable destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Result.Failure)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List payloadFailures = (List)destination$iv$iv3;
        Iterable $this$map$iv5 = this.multiPartFormDataPattern;
        boolean $i$f$map3 = false;
        destination$iv$iv3 = $this$map$iv5;
        Iterable destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv5) {
            void it;
            result2 = (MultiPartFormDataPattern)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl = false;
            collection.add(GrammarKt.withoutOptionality(it.getName()));
        }
        List typeKeys = CollectionsKt.sorted((Iterable)((List)destination$iv$iv4));
        Iterable $this$map$iv6 = httpRequest.getMultiPartFormData();
        boolean $i$f$map4 = false;
        destination$iv$iv4 = $this$map$iv6;
        Iterable destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv6, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            void it;
            MultiPartFormDataValue bl = (MultiPartFormDataValue)item$iv$iv;
            collection = destination$iv$iv5;
            boolean bl4 = false;
            collection.add(it.getName());
        }
        List valueKeys = CollectionsKt.sorted((Iterable)((List)destination$iv$iv5));
        Iterable $this$filter$iv = valueKeys;
        boolean $i$f$filter = false;
        destination$iv$iv5 = $this$filter$iv;
        Iterable destination$iv$iv6 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!typeKeys.contains(it))) continue;
            destination$iv$iv6.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv6;
        boolean $i$f$map5 = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo5 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            String it = (String)item$iv$iv;
            collection = destination$iv$iv6;
            boolean bl = false;
            collection.add(new Result.Failure(resolver.getMismatchMessages().unexpectedKey("part", it), null, null, null, 14, null).breadCrumb(it).breadCrumb("MULTIPART-FORMDATA"));
        }
        List missingInType = (List)destination$iv$iv6;
        Iterable $this$map$iv7 = this.multiPartFormDataPattern;
        boolean $i$f$map6 = false;
        destination$iv$iv6 = $this$map$iv7;
        Iterable destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv7, (int)10));
        boolean $i$f$mapTo6 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            MultiPartFormDataPattern bl = (MultiPartFormDataPattern)item$iv$iv;
            collection = destination$iv$iv7;
            boolean bl5 = false;
            collection.add(it.getName());
        }
        List originalTypeKeys = CollectionsKt.sorted((Iterable)((List)destination$iv$iv7));
        Iterable $this$filter$iv2 = originalTypeKeys;
        boolean $i$f$filter2 = false;
        destination$iv$iv7 = $this$filter$iv2;
        Collection destination$iv$iv8 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!GrammarKt.isOptional(it))) continue;
            destination$iv$iv8.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv8;
        $i$f$filter2 = false;
        $this$filterTo$iv$iv = $this$filter$iv2;
        destination$iv$iv8 = new ArrayList();
        $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!valueKeys.contains(GrammarKt.withoutOptionality(it)))) continue;
            destination$iv$iv8.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv8;
        boolean $i$f$map7 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv8 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo7 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void partName;
            String it = (String)item$iv$iv;
            collection = destination$iv$iv8;
            boolean bl = false;
            collection.add(new Result.Failure(resolver.getMismatchMessages().expectedKeyWasMissing("part", GrammarKt.withoutOptionality((String)partName)), null, null, null, 14, null).breadCrumb(GrammarKt.withoutOptionality((String)partName)).breadCrumb("MULTIPART-FORMDATA"));
        }
        List missingInValue = (List)destination$iv$iv8;
        List allFailures = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)missingInValue, (Iterable)missingInType), (Iterable)payloadFailures);
        return allFailures.isEmpty() ? (MatchingResult)new MatchSuccess<Triple<HttpRequest, Resolver, ? extends List<Result.Failure>>>(parameters) : (MatchingResult)new MatchSuccess<Triple>(new Triple((Object)httpRequest, (Object)resolver, (Object)CollectionsKt.plus((Collection)failures2, (Iterable)allFailures)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MatchingResult<Triple<HttpRequest, Resolver, List<Result.Failure>>> matchFormFields(@NotNull Triple<HttpRequest, Resolver, ? extends List<Result.Failure>> parameters) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Pattern pattern2;
        String key2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterator key3;
        Map $this$filterKeys$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        HttpRequest httpRequest = (HttpRequest)parameters.component1();
        Resolver resolver = (Resolver)parameters.component2();
        List failures2 = (List)parameters.component3();
        Iterable $this$map$iv2 = resolver.findKeyErrorList(this.formFieldsPattern, httpRequest.getFormFields());
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            KeyError keyError = (KeyError)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.missingKeyToResult("form field", resolver.getMismatchMessages()).breadCrumb(it.getName()).breadCrumb("FORM-FIELDS"));
        }
        List keyErrorResults = (List)destination$iv$iv;
        Map<String, Pattern> $i$f$map22 = this.formFieldsPattern;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            key3 = (String)entry$iv.getKey();
            boolean bl = false;
            if (!httpRequest.getFormFields().containsKey(GrammarKt.withoutOptionality((String)((Object)key3)))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterKeys$iv = result$iv;
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo2 = false;
        key3 = $this$mapTo$iv$iv.entrySet().iterator();
        while (key3.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry bl = item$iv$iv = (Map.Entry)key3.next();
            collection = destination$iv$iv2;
            boolean bl2 = false;
            key2 = (String)bl.getKey();
            pattern2 = (Pattern)bl.getValue();
            collection.add(new Triple((Object)GrammarKt.withoutOptionality(key2), (Object)pattern2, MapsKt.getValue(httpRequest.getFormFields(), (Object)key2)));
        }
        $this$map$iv = (List)destination$iv$iv2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Result result2;
            Triple bl = (Triple)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            key2 = (String)bl.component1();
            pattern2 = (Pattern)bl.component2();
            String value2 = (String)bl.component3();
            try {
                Value value3;
                Pattern pattern3;
                String string;
                Resolver resolver2;
                Pattern pattern4 = pattern2;
                String string2 = key2;
                Resolver resolver3 = resolver;
                try {
                    resolver2 = resolver3;
                    string = string2;
                    pattern3 = pattern4;
                    value3 = pattern2.parse(value2, resolver);
                }
                catch (Throwable throwable) {
                    resolver2 = resolver3;
                    string = string2;
                    pattern3 = pattern4;
                    value3 = new StringValue(value2);
                }
                Result result3 = resolver2.matchesPattern(string, pattern3, value3);
                result2 = result3 instanceof Result.Failure ? (Result)((Result.Failure)result3).breadCrumb(key2).breadCrumb("FORM-FIELDS") : result3;
            }
            catch (ContractException e) {
                result2 = e.failure().breadCrumb(key2).breadCrumb("FORM-FIELDS");
            }
            catch (Throwable e) {
                result2 = ResultKt.mismatchResult$default(pattern2, value2, null, 4, null).breadCrumb(key2).breadCrumb("FORM-FIELDS");
            }
            collection.add(result2);
        }
        List payloadResults = (List)destination$iv$iv2;
        Iterable $i$f$map3 = payloadResults;
        collection = keyErrorResults;
        boolean $i$f$filterIsInstance = false;
        destination$iv$iv2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Result.Failure)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List allFailures = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv3));
        return allFailures.isEmpty() ? (MatchingResult)new MatchSuccess<Triple<HttpRequest, Resolver, ? extends List<Result.Failure>>>(parameters) : (MatchingResult)new MatchSuccess<Triple>(new Triple((Object)httpRequest, (Object)resolver, (Object)allFailures));
    }

    private final MatchingResult<Triple<HttpRequest, Resolver, List<Result.Failure>>> matchHeaders(HeaderMatchParams parameters) {
        Result result2;
        HttpRequest httpRequest = parameters.component1();
        Resolver headersResolver = parameters.component2();
        Resolver defaultResolver = parameters.component3();
        List<Result.Failure> failures2 = parameters.component4();
        Map<String, String> headers = httpRequest.getHeaders();
        Resolver resolver = headersResolver;
        if (resolver == null) {
            resolver = defaultResolver;
        }
        return (result2 = this.headersPattern.matches(headers, resolver)) instanceof Result.Failure ? (MatchingResult)new MatchSuccess<Triple>(new Triple((Object)httpRequest, (Object)defaultResolver, (Object)CollectionsKt.plus((Collection)failures2, (Object)result2))) : (MatchingResult)new MatchSuccess<Triple>(new Triple((Object)httpRequest, (Object)defaultResolver, failures2));
    }

    private final MatchingResult<Triple<HttpRequest, Resolver, List<Result.Failure>>> matchBody(Triple<HttpRequest, Resolver, ? extends List<Result.Failure>> parameters) {
        Result result2;
        HttpRequest httpRequest = (HttpRequest)parameters.component1();
        Resolver resolver = (Resolver)parameters.component2();
        List failures2 = (List)parameters.component3();
        try {
            Value bodyValue = GrammarKt.isPatternToken(httpRequest.getBodyString()) ? (Value)new StringValue(httpRequest.getBodyString()) : this.body.parse(httpRequest.getBodyString(), resolver);
            result2 = resolver.matchesPattern(null, this.body, bodyValue).breadCrumb("BODY");
        }
        catch (ContractException e) {
            result2 = e.failure().breadCrumb("BODY");
        }
        Result result3 = result2;
        return result3 instanceof Result.Failure ? (MatchingResult)new MatchSuccess<Triple>(new Triple((Object)httpRequest, (Object)resolver, (Object)CollectionsKt.plus((Collection)failures2, (Object)result3))) : (MatchingResult)new MatchSuccess<Triple<HttpRequest, Resolver, ? extends List<Result.Failure>>>(parameters);
    }

    private final MatchingResult<Triple<HttpRequest, Resolver, List<Result.Failure>>> matchMethod(Pair<HttpRequest, Resolver> parameters) {
        MatchingResult matchingResult;
        HttpRequest httpRequest = (HttpRequest)parameters.component1();
        Resolver resolver = (Resolver)parameters.component2();
        String it = this.method;
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)it, (Object)httpRequest.getMethod())) {
            String string;
            String string2 = this.method;
            if (string2 == null) {
                string2 = "";
            }
            if ((string = httpRequest.getMethod()) == null) {
                string = "";
            }
            matchingResult = new MatchFailure(Result.Failure.copy$default(ResultKt.mismatchResult$default(string2, string, null, 4, null), null, null, FailureReason.MethodMismatch, 3, null).breadCrumb("METHOD"));
        } else {
            matchingResult = new MatchSuccess<Triple>(new Triple((Object)httpRequest, (Object)resolver, (Object)CollectionsKt.emptyList()));
        }
        return matchingResult;
    }

    private final MatchingResult<Pair<HttpRequest, Resolver>> matchPath(Pair<HttpRequest, Resolver> parameters) {
        HttpRequest httpRequest = (HttpRequest)parameters.component1();
        Resolver resolver = (Resolver)parameters.component2();
        URLMatcher uRLMatcher = this.urlMatcher;
        Intrinsics.checkNotNull((Object)uRLMatcher);
        String string = httpRequest.getPath();
        Intrinsics.checkNotNull((Object)string);
        Result result2 = uRLMatcher.matchesPath(string, resolver);
        return result2 instanceof Result.Failure ? (MatchingResult)new MatchFailure((Result.Failure)result2) : (MatchingResult)new MatchSuccess<Pair<HttpRequest, Resolver>>(parameters);
    }

    private final MatchingResult<Triple<HttpRequest, Resolver, List<Result.Failure>>> matchQuery(Triple<HttpRequest, Resolver, ? extends List<Result.Failure>> parameters) {
        HttpRequest httpRequest = (HttpRequest)parameters.component1();
        Resolver resolver = (Resolver)parameters.component2();
        List failures2 = (List)parameters.component3();
        URLMatcher uRLMatcher = this.urlMatcher;
        Intrinsics.checkNotNull((Object)uRLMatcher);
        Result result2 = uRLMatcher.matchesQuery(httpRequest, resolver);
        return result2 instanceof Result.Failure ? (MatchingResult)new MatchSuccess<Triple>(new Triple((Object)httpRequest, (Object)resolver, (Object)CollectionsKt.plus((Collection)failures2, (Object)((Result.Failure)result2).breadCrumb("QUERY-PARAMS")))) : (MatchingResult)new MatchSuccess<Triple<HttpRequest, Resolver, ? extends List<Result.Failure>>>(parameters);
    }

    @NotNull
    public final HttpRequestPattern generate(@NotNull HttpRequest request, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Ref.ObjectRef requestType = new Ref.ObjectRef();
        requestType.element = new HttpRequestPattern(null, null, null, null, null, null, null, 127, null);
        return (HttpRequestPattern)ContractExceptionKt.attempt$default(null, "REQUEST", (Function0)new Function0<HttpRequestPattern>(this, (Ref.ObjectRef<HttpRequestPattern>)requestType, request, resolver){
            final /* synthetic */ HttpRequestPattern this$0;
            final /* synthetic */ Ref.ObjectRef<HttpRequestPattern> $requestType;
            final /* synthetic */ HttpRequest $request;
            final /* synthetic */ Resolver $resolver;
            {
                this.this$0 = $receiver;
                this.$requestType = $requestType;
                this.$request = $request;
                this.$resolver = $resolver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final HttpRequestPattern invoke() {
                void $this$fold$iv;
                if (this.this$0.getMethod() == null) {
                    throw HttpRequestPatternKt.missingParam("HTTP method");
                }
                if (this.this$0.getUrlMatcher() == null) {
                    throw HttpRequestPatternKt.missingParam("URL path");
                }
                this.$requestType.element = HttpRequestPattern.copy$default((HttpRequestPattern)this.$requestType.element, null, null, this.$request.getMethod(), null, null, null, null, 123, null);
                this.$requestType.element = ContractExceptionKt.attempt$default(null, "URL", (Function0)new Function0<HttpRequestPattern>(this.$request, this.this$0, this.$resolver, this.$requestType){
                    final /* synthetic */ HttpRequest $request;
                    final /* synthetic */ HttpRequestPattern this$0;
                    final /* synthetic */ Resolver $resolver;
                    final /* synthetic */ Ref.ObjectRef<HttpRequestPattern> $requestType;
                    {
                        this.$request = $request;
                        this.this$0 = $receiver;
                        this.$resolver = $resolver;
                        this.$requestType = $requestType;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final HttpRequestPattern invoke() {
                        void $this$mapKeysTo$iv$iv;
                        void $this$mapKeys$iv;
                        String string = this.$request.getPath();
                        if (string == null) {
                            string = "";
                        }
                        String path2 = string;
                        List<URLPathPattern> pathTypes = URLMatcherKt.pathToPattern(path2);
                        Map map = HttpRequestPattern.access$toTypeMap(this.this$0, this.$request.getQueryParams(), this.this$0.getUrlMatcher().getQueryPattern(), this.$resolver);
                        boolean $i$f$mapKeys = false;
                        void var6_5 = $this$mapKeys$iv;
                        Map destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
                        boolean $i$f$mapKeysTo = false;
                        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
                        boolean $i$f$associateByTo = false;
                        for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                            void it$iv$iv;
                            void it;
                            Map.Entry<K, V> entry = (Map.Entry)element$iv$iv$iv;
                            Map map2 = destination$iv$iv;
                            boolean bl = false;
                            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                            String string2 = StringsKt.removeSuffix((String)((String)it.getKey()), (CharSequence)"?");
                            Map map3 = map2;
                            boolean bl2 = false;
                            entry = it$iv$iv.getValue();
                            map3.put(string2, entry);
                        }
                        Map queryParamTypes = destination$iv$iv;
                        return HttpRequestPattern.copy$default((HttpRequestPattern)this.$requestType.element, null, new URLMatcher(queryParamTypes, pathTypes, path2), null, null, null, null, null, 125, null);
                    }
                }, 1, null);
                this.$requestType.element = ContractExceptionKt.attempt$default(null, "HEADERS", (Function0)new Function0<HttpRequestPattern>(this.$requestType, this.this$0, this.$request, this.$resolver){
                    final /* synthetic */ Ref.ObjectRef<HttpRequestPattern> $requestType;
                    final /* synthetic */ HttpRequestPattern this$0;
                    final /* synthetic */ HttpRequest $request;
                    final /* synthetic */ Resolver $resolver;
                    {
                        this.$requestType = $requestType;
                        this.this$0 = $receiver;
                        this.$request = $request;
                        this.$resolver = $resolver;
                        super(0);
                    }

                    @NotNull
                    public final HttpRequestPattern invoke() {
                        HttpRequestPattern httpRequestPattern = (HttpRequestPattern)this.$requestType.element;
                        Map map = HttpRequestPattern.access$toLowerCaseKeys(this.this$0, this.$request.getHeaders());
                        Intrinsics.checkNotNull((Object)map, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                        Map map2 = HttpRequestPattern.access$toLowerCaseKeys(this.this$0, this.this$0.getHeadersPattern().getPattern());
                        Intrinsics.checkNotNull((Object)map2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, in.specmatic.core.pattern.Pattern>");
                        return HttpRequestPattern.copy$default(httpRequestPattern, new HttpHeadersPattern(HttpRequestPattern.access$toTypeMap(this.this$0, map, map2, this.$resolver), null, 2, null), null, null, null, null, null, null, 126, null);
                    }
                }, 1, null);
                this.$requestType.element = ContractExceptionKt.attempt$default(null, "BODY", (Function0)new Function0<HttpRequestPattern>(this.$requestType, this.$request, this.this$0, this.$resolver){
                    final /* synthetic */ Ref.ObjectRef<HttpRequestPattern> $requestType;
                    final /* synthetic */ HttpRequest $request;
                    final /* synthetic */ HttpRequestPattern this$0;
                    final /* synthetic */ Resolver $resolver;
                    {
                        this.$requestType = $requestType;
                        this.$request = $request;
                        this.this$0 = $receiver;
                        this.$resolver = $resolver;
                        super(0);
                    }

                    @NotNull
                    public final HttpRequestPattern invoke() {
                        return HttpRequestPattern.copy$default((HttpRequestPattern)this.$requestType.element, null, null, null, this.$request.getBody() instanceof StringValue ? HttpRequestPattern.access$encompassedType(this.this$0, this.$request.getBodyString(), null, this.this$0.getBody(), this.$resolver) : this.$request.getBody().exactMatchElseType(), null, null, null, 119, null);
                    }
                }, 1, null);
                this.$requestType.element = ContractExceptionKt.attempt$default(null, "FORM FIELDS", (Function0)new Function0<HttpRequestPattern>(this.$requestType, this.this$0, this.$request, this.$resolver){
                    final /* synthetic */ Ref.ObjectRef<HttpRequestPattern> $requestType;
                    final /* synthetic */ HttpRequestPattern this$0;
                    final /* synthetic */ HttpRequest $request;
                    final /* synthetic */ Resolver $resolver;
                    {
                        this.$requestType = $requestType;
                        this.this$0 = $receiver;
                        this.$request = $request;
                        this.$resolver = $resolver;
                        super(0);
                    }

                    @NotNull
                    public final HttpRequestPattern invoke() {
                        return HttpRequestPattern.copy$default((HttpRequestPattern)this.$requestType.element, null, null, null, null, HttpRequestPattern.access$toTypeMap(this.this$0, this.$request.getFormFields(), this.this$0.getFormFieldsPattern(), this.$resolver), null, null, 111, null);
                    }
                }, 1, null);
                Iterable iterable = this.$request.getMultiPartFormData();
                Map initial$iv = MapsKt.emptyMap();
                boolean $i$f$fold = false;
                Map accumulator$iv = initial$iv;
                for (T element$iv : $this$fold$iv) {
                    void part;
                    MultiPartFormDataValue multiPartFormDataValue = (MultiPartFormDataValue)element$iv;
                    Map acc = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = MapsKt.plus((Map)acc, (Pair)TuplesKt.to((Object)part.getName(), (Object)part));
                }
                Map multiPartFormDataRequestMap = accumulator$iv;
                return (HttpRequestPattern)ContractExceptionKt.attempt$default(null, "MULTIPART DATA", (Function0)new Function0<HttpRequestPattern>(this.$requestType, this.this$0, (Map<String, ? extends MultiPartFormDataValue>)multiPartFormDataRequestMap){
                    final /* synthetic */ Ref.ObjectRef<HttpRequestPattern> $requestType;
                    final /* synthetic */ HttpRequestPattern this$0;
                    final /* synthetic */ Map<String, MultiPartFormDataValue> $multiPartFormDataRequestMap;
                    {
                        this.$requestType = $requestType;
                        this.this$0 = $receiver;
                        this.$multiPartFormDataRequestMap = $multiPartFormDataRequestMap;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final HttpRequestPattern invoke() {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        MultiPartFormDataPattern it;
                        void $this$filterTo$iv$iv;
                        Iterable $this$filter$iv;
                        Iterable iterable = this.this$0.getMultiPartFormDataPattern();
                        Map<String, MultiPartFormDataValue> map = this.$multiPartFormDataRequestMap;
                        Map map2 = null;
                        Pattern pattern2 = null;
                        String string = null;
                        URLMatcher uRLMatcher = null;
                        HttpHeadersPattern httpHeadersPattern = null;
                        HttpRequestPattern httpRequestPattern = (HttpRequestPattern)this.$requestType.element;
                        boolean $i$f$filter = false;
                        void var4_10 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (MultiPartFormDataPattern)element$iv$iv;
                            boolean bl = false;
                            if (!map.containsKey(GrammarKt.withoutOptionality(it.getName()))) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        Collection<MultiPartFormDataPattern> collection = (List)destination$iv$iv;
                        $this$filter$iv = collection;
                        map = this.$multiPartFormDataRequestMap;
                        boolean $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            it = (MultiPartFormDataPattern)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            String key2 = GrammarKt.withoutOptionality(it.getName());
                            collection.add(((MultiPartFormDataValue)MapsKt.getValue(map, (Object)key2)).inferType());
                        }
                        collection = (List)destination$iv$iv;
                        return HttpRequestPattern.copy$default(httpRequestPattern, httpHeadersPattern, uRLMatcher, string, pattern2, map2, (List)collection, null, 95, null);
                    }
                }, 1, null);
            }
        }, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> toLowerCaseKeys(Map<String, ? extends Object> map) {
        void $this$mapTo$iv$iv;
        Map<String, ? extends Object> $this$map$iv = map;
        boolean $i$f$map = false;
        Map<String, ? extends Object> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String key2 = (String)entry.getKey();
            Object value2 = entry.getValue();
            collection.add(TuplesKt.to((Object)TextKt.toLowerCasePreservingASCIIRules((String)key2), value2));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Pattern> toTypeMap(Map<String, String> values2, Map<String, ? extends Pattern> types, Resolver resolver) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map $this$filterKeys$iv = types;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<String, Pattern> result$iv = new LinkedHashMap<String, Pattern>();
        for (Map.Entry<String, ? extends Pattern> entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = entry$iv.getKey();
            boolean bl = false;
            if (!values2.containsKey(GrammarKt.withoutOptionality(it))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterKeys$iv = result$iv;
        boolean $i$f$mapValues = false;
        result$iv = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl2 = false;
            String key2 = GrammarKt.withoutOptionality((String)it.getKey());
            Pattern type = (Pattern)it.getValue();
            Pattern pattern2 = (Pattern)ContractExceptionKt.attempt$default(null, key2, (Function0)new Function0<Pattern>(values2, key2, this, type, resolver){
                final /* synthetic */ Map<String, String> $values;
                final /* synthetic */ String $key;
                final /* synthetic */ HttpRequestPattern this$0;
                final /* synthetic */ Pattern $type;
                final /* synthetic */ Resolver $resolver;
                {
                    this.$values = $values;
                    this.$key = $key;
                    this.this$0 = $receiver;
                    this.$type = $type;
                    this.$resolver = $resolver;
                    super(0);
                }

                @NotNull
                public final Pattern invoke() {
                    String valueString = (String)MapsKt.getValue(this.$values, (Object)this.$key);
                    return HttpRequestPattern.access$encompassedType(this.this$0, valueString, this.$key, this.$type, this.$resolver);
                }
            }, 1, null);
            map2.put(k, pattern2);
        }
        return destination$iv$iv;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Pattern encompassedType(String valueString, String key2, Pattern type, Resolver resolver) {
        Pattern pattern2;
        if (!GrammarKt.isPatternToken(valueString)) {
            pattern2 = type.parseToType(valueString, resolver);
            return pattern2;
        }
        Pattern parsedType = DeferredPatternKt.resolvedHop(GrammarKt.parsedPattern$default(valueString, key2, null, 4, null), resolver);
        boolean bl = false;
        Result result2 = Pattern.DefaultImpls.encompasses$default(type, parsedType, resolver, resolver, null, 8, null);
        if (result2 instanceof Result.Success) {
            pattern2 = parsedType;
            return pattern2;
        }
        if (!(result2 instanceof Result.Failure)) throw new NoWhenBranchMatchedException();
        throw new ContractException(Result.Failure.toFailureReport$default((Result.Failure)result2, null, 1, null));
    }

    @NotNull
    public final HttpRequest generate(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Ref.ObjectRef newRequest = new Ref.ObjectRef();
        newRequest.element = new HttpRequest(null, null, null, null, null, null, null, 127, null);
        return (HttpRequest)ContractExceptionKt.attempt$default(null, "REQUEST", (Function0)new Function0<HttpRequest>(this, (Ref.ObjectRef<HttpRequest>)newRequest, resolver){
            final /* synthetic */ HttpRequestPattern this$0;
            final /* synthetic */ Ref.ObjectRef<HttpRequest> $newRequest;
            final /* synthetic */ Resolver $resolver;
            {
                this.this$0 = $receiver;
                this.$newRequest = $newRequest;
                this.$resolver = $resolver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final HttpRequest invoke() {
                HttpRequest httpRequest;
                void $this$fold$iv;
                void initial$iv;
                Object object;
                HttpRequest httpRequest2;
                if (this.this$0.getMethod() == null) {
                    throw HttpRequestPatternKt.missingParam("HTTP method");
                }
                if (this.this$0.getUrlMatcher() == null) {
                    throw HttpRequestPatternKt.missingParam("URL path");
                }
                this.$newRequest.element = ((HttpRequest)this.$newRequest.element).updateMethod(this.this$0.getMethod());
                ContractExceptionKt.attempt$default(null, "URL", (Function0)new Function0<Unit>(this.$newRequest, this.this$0, this.$resolver){
                    final /* synthetic */ Ref.ObjectRef<HttpRequest> $newRequest;
                    final /* synthetic */ HttpRequestPattern this$0;
                    final /* synthetic */ Resolver $resolver;
                    {
                        this.$newRequest = $newRequest;
                        this.this$0 = $receiver;
                        this.$resolver = $resolver;
                        super(0);
                    }

                    public final void invoke() {
                        this.$newRequest.element = ((HttpRequest)this.$newRequest.element).updatePath(this.this$0.getUrlMatcher().generatePath(this.$resolver));
                        Map<String, String> queryParams = this.this$0.getUrlMatcher().generateQuery(this.$resolver);
                        for (String key2 : queryParams.keySet()) {
                            HttpRequest httpRequest = (HttpRequest)this.$newRequest.element;
                            String string = queryParams.get(key2);
                            if (string == null) {
                                string = "";
                            }
                            this.$newRequest.element = httpRequest.updateQueryParam(key2, string);
                        }
                    }
                }, 1, null);
                Map<String, String> headers = this.this$0.getHeadersPattern().generate(this.$resolver);
                Pattern body = this.this$0.getBody();
                ContractExceptionKt.attempt$default(null, "BODY", (Function0)new Function0<Unit>(this.$resolver, body, this.$newRequest){
                    final /* synthetic */ Resolver $resolver;
                    final /* synthetic */ Pattern $body;
                    final /* synthetic */ Ref.ObjectRef<HttpRequest> $newRequest;
                    {
                        this.$resolver = $resolver;
                        this.$body = $body;
                        this.$newRequest = $newRequest;
                        super(0);
                    }

                    public final void invoke() {
                        this.$resolver.withCyclePrevention(this.$body, (Function1)new Function1<Resolver, Unit>(this.$body, this.$newRequest){
                            final /* synthetic */ Pattern $body;
                            final /* synthetic */ Ref.ObjectRef<HttpRequest> $newRequest;
                            {
                                this.$body = $body;
                                this.$newRequest = $newRequest;
                                super(1);
                            }

                            public final void invoke(@NotNull Resolver cyclePreventedResolver) {
                                Intrinsics.checkNotNullParameter((Object)cyclePreventedResolver, (String)"cyclePreventedResolver");
                                Value value2 = this.$body.generate(cyclePreventedResolver);
                                Ref.ObjectRef<HttpRequest> objectRef = this.$newRequest;
                                Value value3 = value2;
                                boolean bl = false;
                                objectRef.element = ((HttpRequest)objectRef.element).updateBody(value3);
                                objectRef.element = ((HttpRequest)objectRef.element).updateHeader("Content-Type", value3.getHttpContentType());
                            }
                        });
                    }
                }, 1, null);
                this.$newRequest.element = HttpRequest.copy$default((HttpRequest)this.$newRequest.element, null, null, headers, null, null, null, null, 123, null);
                Map formFieldsValue2 = (Map)ContractExceptionKt.attempt$default(null, "FORM FIELDS", (Function0)new Function0<Map<String, ? extends String>>(this.this$0, this.$resolver){
                    final /* synthetic */ HttpRequestPattern this$0;
                    final /* synthetic */ Resolver $resolver;
                    {
                        this.this$0 = $receiver;
                        this.$resolver = $resolver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final Map<String, String> invoke() {
                        void $this$mapValuesTo$iv$iv;
                        void $this$mapValues$iv;
                        Map<String, Pattern> map = this.this$0.getFormFieldsPattern();
                        Resolver resolver = this.$resolver;
                        boolean $i$f$mapValues = false;
                        void var4_4 = $this$mapValues$iv;
                        Map destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                        boolean $i$f$mapValuesTo = false;
                        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                        boolean $i$f$associateByTo = false;
                        for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                            void it$iv$iv;
                            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                            Map map2 = destination$iv$iv;
                            boolean bl = false;
                            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                            K k = it$iv$iv.getKey();
                            Map map3 = map2;
                            boolean bl2 = false;
                            String key2 = (String)entry2.getKey();
                            Pattern pattern2 = (Pattern)entry2.getValue();
                            String string = (String)ContractExceptionKt.attempt$default(null, key2, (Function0)new Function0<String>(resolver, pattern2, key2){
                                final /* synthetic */ Resolver $resolver;
                                final /* synthetic */ Pattern $pattern;
                                final /* synthetic */ String $key;
                                {
                                    this.$resolver = $resolver;
                                    this.$pattern = $pattern;
                                    this.$key = $key;
                                    super(0);
                                }

                                @NotNull
                                public final String invoke() {
                                    return this.$resolver.withCyclePrevention(this.$pattern, (Function1)new Function1<Resolver, Value>(this.$key, this.$pattern){
                                        final /* synthetic */ String $key;
                                        final /* synthetic */ Pattern $pattern;
                                        {
                                            this.$key = $key;
                                            this.$pattern = $pattern;
                                            super(1);
                                        }

                                        @NotNull
                                        public final Value invoke(@NotNull Resolver cyclePreventedResolver) {
                                            Intrinsics.checkNotNullParameter((Object)cyclePreventedResolver, (String)"cyclePreventedResolver");
                                            return cyclePreventedResolver.generate(this.$key, this.$pattern);
                                        }
                                    }).toString();
                                }
                            }, 1, null);
                            map3.put(k, string);
                        }
                        return destination$iv$iv;
                    }
                }, 1, null);
                if (formFieldsValue2.size() == 0) {
                    httpRequest2 = (HttpRequest)this.$newRequest.element;
                } else {
                    object = (HttpRequest)this.$newRequest.element;
                    Map map = MapsKt.plus(((HttpRequest)this.$newRequest.element).getHeaders(), (Pair)TuplesKt.to((Object)"Content-Type", (Object)"application/x-www-form-urlencoded"));
                    httpRequest2 = HttpRequest.copy$default((HttpRequest)object, null, null, map, null, null, formFieldsValue2, null, 91, null);
                }
                this.$newRequest.element = httpRequest2;
                Iterable iterable = this.this$0.getSecuritySchemes();
                object = this.$newRequest.element;
                Ref.ObjectRef<HttpRequest> objectRef = this.$newRequest;
                boolean $i$f$fold = false;
                HttpRequest accumulator$iv = initial$iv;
                for (T element$iv : $this$fold$iv) {
                    void securityScheme;
                    OpenAPISecurityScheme openAPISecurityScheme = (OpenAPISecurityScheme)element$iv;
                    HttpRequest request = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = securityScheme.addTo(request);
                }
                objectRef.element = accumulator$iv;
                List multipartData2 = (List)ContractExceptionKt.attempt$default(null, "MULTIPART DATA", (Function0)new Function0<List<? extends MultiPartFormDataValue>>(this.this$0, this.$resolver){
                    final /* synthetic */ HttpRequestPattern this$0;
                    final /* synthetic */ Resolver $resolver;
                    {
                        this.this$0 = $receiver;
                        this.$resolver = $resolver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final List<MultiPartFormDataValue> invoke() {
                        void $this$mapIndexedTo$iv$iv;
                        void $this$mapIndexed$iv;
                        Iterable iterable = this.this$0.getMultiPartFormDataPattern();
                        Resolver resolver = this.$resolver;
                        boolean $i$f$mapIndexed = false;
                        void var4_4 = $this$mapIndexed$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                        boolean $i$f$mapIndexedTo = false;
                        int index$iv$iv = 0;
                        for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                            void multiPartFormDataPattern;
                            void index;
                            int n;
                            if ((n = index$iv$iv++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            MultiPartFormDataPattern multiPartFormDataPattern2 = (MultiPartFormDataPattern)item$iv$iv;
                            int n2 = n;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add((MultiPartFormDataValue)ContractExceptionKt.attempt$default(null, "" + '[' + (int)index + ']', (Function0)new Function0<MultiPartFormDataValue>((MultiPartFormDataPattern)multiPartFormDataPattern, resolver){
                                final /* synthetic */ MultiPartFormDataPattern $multiPartFormDataPattern;
                                final /* synthetic */ Resolver $resolver;
                                {
                                    this.$multiPartFormDataPattern = $multiPartFormDataPattern;
                                    this.$resolver = $resolver;
                                    super(0);
                                }

                                @NotNull
                                public final MultiPartFormDataValue invoke() {
                                    return this.$multiPartFormDataPattern.generate(this.$resolver);
                                }
                            }, 1, null));
                        }
                        return (List)destination$iv$iv;
                    }
                }, 1, null);
                if (multipartData2.size() == 0) {
                    httpRequest = (HttpRequest)this.$newRequest.element;
                } else {
                    HttpRequest httpRequest3 = (HttpRequest)this.$newRequest.element;
                    Map map = MapsKt.plus(((HttpRequest)this.$newRequest.element).getHeaders(), (Pair)TuplesKt.to((Object)"Content-Type", (Object)"multipart/form-data"));
                    httpRequest = HttpRequest.copy$default(httpRequest3, null, null, map, null, null, null, multipartData2, 59, null);
                }
                return httpRequest;
            }
        }, 1, null);
    }

    @NotNull
    public final List<HttpRequestPattern> newBasedOn(@NotNull Row row, @NotNull Resolver initialResolver, int status) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)initialResolver, (String)"initialResolver");
        Resolver resolver = HttpRequestPatternKt.access$getInvalidRequestStatuses$p().contains(status) ? initialResolver.invalidRequestResolver() : initialResolver;
        return (List)ContractExceptionKt.attempt$default(null, "REQUEST", (Function0)new Function0<List<? extends HttpRequestPattern>>(this, row, resolver, status){
            final /* synthetic */ HttpRequestPattern this$0;
            final /* synthetic */ Row $row;
            final /* synthetic */ Resolver $resolver;
            final /* synthetic */ int $status;
            {
                this.this$0 = $receiver;
                this.$row = $row;
                this.$resolver = $resolver;
                this.$status = $status;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<HttpRequestPattern> invoke() {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Object object = this.this$0.getUrlMatcher();
                if (object == null || (object = ((URLMatcher)object).newBasedOn(this.$row, this.$resolver)) == null) {
                    object = CollectionsKt.listOf(null);
                }
                List<URLMatcher> newURLMatchers = object;
                List newBodies2 = (List)ContractExceptionKt.attempt$default(null, "BODY", (Function0)new Function0<List<? extends Pattern>>(this.this$0, this.$row, this.$resolver, this.$status){
                    final /* synthetic */ HttpRequestPattern this$0;
                    final /* synthetic */ Row $row;
                    final /* synthetic */ Resolver $resolver;
                    final /* synthetic */ int $status;
                    {
                        this.this$0 = $receiver;
                        this.$row = $row;
                        this.$resolver = $resolver;
                        this.$status = $status;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @NotNull
                    public final List<Pattern> invoke() {
                        boolean bl;
                        List list;
                        Pattern pattern2 = this.this$0.getBody();
                        Row row = this.$row;
                        Resolver resolver = this.$resolver;
                        HttpRequestPattern httpRequestPattern = this.this$0;
                        int n = this.$status;
                        Pattern it = pattern2;
                        boolean bl2 = false;
                        if (it instanceof DeferredPattern && row.containsField(((DeferredPattern)it).getPattern())) {
                            String example = row.getField(((DeferredPattern)it).getPattern());
                            list = CollectionsKt.listOf((Object)new ExactValuePattern(it.parse(example, resolver), null, 2, null));
                            return list;
                        }
                        String string = it.getTypeAlias();
                        if (string != null) {
                            String p = string;
                            boolean bl3 = false;
                            bl = GrammarKt.isPatternToken(p);
                        } else {
                            bl = false;
                        }
                        if (bl) {
                            String string2 = it.getTypeAlias();
                            Intrinsics.checkNotNull((Object)string2);
                            if (row.containsField(string2)) {
                                String string3 = it.getTypeAlias();
                                Intrinsics.checkNotNull((Object)string3);
                                String example = row.getField(string3);
                                list = CollectionsKt.listOf((Object)new ExactValuePattern(it.parse(example, resolver), null, 2, null));
                                return list;
                            }
                        }
                        if (it instanceof XMLPattern) {
                            boolean bl4;
                            String string4 = ((XMLPattern)it).getReferredType();
                            if (string4 != null) {
                                String referredType = string4;
                                boolean bl5 = false;
                                bl4 = row.containsField('(' + referredType + ')');
                            } else {
                                bl4 = false;
                            }
                            if (bl4) {
                                String referredType = '(' + ((XMLPattern)it).getReferredType() + ')';
                                String example = row.getField(referredType);
                                list = CollectionsKt.listOf((Object)new ExactValuePattern(it.parse(example, resolver), null, 2, null));
                                return list;
                            }
                        }
                        if (row.containsField("(REQUEST-BODY)")) {
                            Result result2;
                            String example = row.getField("(REQUEST-BODY)");
                            Value value2 = it.parse(example, resolver);
                            if (!HttpRequestPattern.access$isInvalidRequestResponse(httpRequestPattern, n) && (result2 = httpRequestPattern.getBody().matches(value2, resolver)) instanceof Result.Failure) {
                                throw new ContractException(Result.Failure.toFailureReport$default((Result.Failure)result2, null, 1, null));
                            }
                            if (resolver.getGenerativeTestingEnabled()) {
                                boolean bl6;
                                List requestsFromFlattenedRow2;
                                List rowWithRequestBodyAsIs;
                                block20: {
                                    ExactValuePattern requestBodyAsIs = new ExactValuePattern(value2, null, 2, null);
                                    rowWithRequestBodyAsIs = CollectionsKt.listOf((Object)requestBodyAsIs);
                                    requestsFromFlattenedRow2 = (List)resolver.withCyclePrevention(httpRequestPattern.getBody(), (Function1)new Function1<Resolver, List<? extends Pattern>>(httpRequestPattern, row){
                                        final /* synthetic */ HttpRequestPattern this$0;
                                        final /* synthetic */ Row $row;
                                        {
                                            this.this$0 = $receiver;
                                            this.$row = $row;
                                            super(1);
                                        }

                                        @NotNull
                                        public final List<Pattern> invoke(@NotNull Resolver cyclePreventedResolver) {
                                            Intrinsics.checkNotNullParameter((Object)cyclePreventedResolver, (String)"cyclePreventedResolver");
                                            return this.this$0.getBody().newBasedOn(this.$row.flattenRequestBodyIntoRow(), cyclePreventedResolver);
                                        }
                                    });
                                    Iterable $this$none$iv = requestsFromFlattenedRow2;
                                    boolean $i$f$none = false;
                                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                        bl6 = true;
                                    } else {
                                        for (T element$iv : $this$none$iv) {
                                            Pattern p = (Pattern)element$iv;
                                            boolean bl7 = false;
                                            if (!(p.encompasses(requestBodyAsIs, resolver, resolver, SetsKt.emptySet()) instanceof Result.Success)) continue;
                                            bl6 = false;
                                            break block20;
                                        }
                                        bl6 = true;
                                    }
                                }
                                list = bl6 ? CollectionsKt.plus((Collection)requestsFromFlattenedRow2, (Iterable)rowWithRequestBodyAsIs) : requestsFromFlattenedRow2;
                                return list;
                            }
                            list = CollectionsKt.listOf((Object)new ExactValuePattern(value2, null, 2, null));
                            return list;
                        }
                        if (resolver.getGenerativeTestingEnabled()) {
                            void $this$filterNotTo$iv$iv;
                            List vanilla2 = (List)resolver.withCyclePrevention(httpRequestPattern.getBody(), (Function1)new Function1<Resolver, List<? extends Pattern>>(httpRequestPattern){
                                final /* synthetic */ HttpRequestPattern this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                @NotNull
                                public final List<Pattern> invoke(@NotNull Resolver cyclePreventedResolver) {
                                    Intrinsics.checkNotNullParameter((Object)cyclePreventedResolver, (String)"cyclePreventedResolver");
                                    return this.this$0.getBody().newBasedOn(new Row(null, null, null, null, null, 31, null), cyclePreventedResolver);
                                }
                            });
                            List fromExamples2 = (List)resolver.withCyclePrevention(httpRequestPattern.getBody(), (Function1)new Function1<Resolver, List<? extends Pattern>>(httpRequestPattern, row){
                                final /* synthetic */ HttpRequestPattern this$0;
                                final /* synthetic */ Row $row;
                                {
                                    this.this$0 = $receiver;
                                    this.$row = $row;
                                    super(1);
                                }

                                @NotNull
                                public final List<Pattern> invoke(@NotNull Resolver cyclePreventedResolver) {
                                    Intrinsics.checkNotNullParameter((Object)cyclePreventedResolver, (String)"cyclePreventedResolver");
                                    return this.this$0.getBody().newBasedOn(this.$row, cyclePreventedResolver);
                                }
                            });
                            Iterable $this$filterNot$iv = vanilla2;
                            boolean $i$f$filterNot = false;
                            Iterable $this$none$iv = $this$filterNot$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterNotTo = false;
                            for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                                boolean bl8;
                                block21: {
                                    Pattern vanillaType = (Pattern)element$iv$iv;
                                    boolean bl9 = false;
                                    Iterable $this$any$iv = fromExamples2;
                                    boolean $i$f$any = false;
                                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                        bl8 = false;
                                    } else {
                                        for (T element$iv : $this$any$iv) {
                                            Pattern typeFromExamples = (Pattern)element$iv;
                                            boolean bl10 = false;
                                            if (!Pattern.DefaultImpls.encompasses$default(vanillaType, typeFromExamples, resolver, resolver, null, 8, null).isSuccess()) continue;
                                            bl8 = true;
                                            break block21;
                                        }
                                        bl8 = false;
                                    }
                                }
                                if (bl8) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            List remainingVanilla = (List)destination$iv$iv;
                            list = CollectionsKt.plus((Collection)fromExamples2, (Iterable)remainingVanilla);
                            return list;
                        }
                        list = (List)resolver.withCyclePrevention(httpRequestPattern.getBody(), (Function1)new Function1<Resolver, List<? extends Pattern>>(httpRequestPattern, row){
                            final /* synthetic */ HttpRequestPattern this$0;
                            final /* synthetic */ Row $row;
                            {
                                this.this$0 = $receiver;
                                this.$row = $row;
                                super(1);
                            }

                            @NotNull
                            public final List<Pattern> invoke(@NotNull Resolver cyclePreventedResolver) {
                                Intrinsics.checkNotNullParameter((Object)cyclePreventedResolver, (String)"cyclePreventedResolver");
                                return this.this$0.getBody().newBasedOn(this.$row, cyclePreventedResolver);
                            }
                        });
                        return list;
                    }
                }, 1, null);
                List<HttpHeadersPattern> newHeadersPattern = this.this$0.getHeadersPattern().newBasedOn(this.$row, this.$resolver);
                List<Map<String, Pattern>> newFormFieldsPatterns = TabularPatternKt.newBasedOn(this.this$0.getFormFieldsPattern(), this.$row, this.$resolver);
                List<List<MultiPartFormDataPattern>> newFormDataPartLists = HttpRequestPatternKt.newMultiPartBasedOn(this.this$0.getMultiPartFormDataPattern(), this.$row, this.$resolver);
                Iterable iterable = newURLMatchers;
                HttpRequestPattern httpRequestPattern = this.this$0;
                Row row = this.$row;
                boolean $i$f$flatMap = false;
                void var10_10 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    void $this$flatMapTo$iv$iv2;
                    URLMatcher newURLMatcher = (URLMatcher)element$iv$iv;
                    boolean bl = false;
                    Iterable $this$flatMap$iv2 = newBodies2;
                    boolean $i$f$flatMap2 = false;
                    Iterable iterable2 = $this$flatMap$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>();
                    boolean $i$f$flatMapTo2 = false;
                    for (T element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                        void $this$flatMapTo$iv$iv3;
                        Pattern newBody = (Pattern)element$iv$iv2;
                        boolean bl2 = false;
                        Iterable $this$flatMap$iv3 = newHeadersPattern;
                        boolean $i$f$flatMap3 = false;
                        Iterable iterable3 = $this$flatMap$iv3;
                        Collection destination$iv$iv3 = new ArrayList<E>();
                        boolean $i$f$flatMapTo3 = false;
                        for (T element$iv$iv3 : $this$flatMapTo$iv$iv3) {
                            void $this$flatMapTo$iv$iv4;
                            HttpHeadersPattern newHeadersPattern2 = (HttpHeadersPattern)element$iv$iv3;
                            boolean bl3 = false;
                            Iterable $this$flatMap$iv4 = newFormFieldsPatterns;
                            boolean $i$f$flatMap4 = false;
                            Iterable iterable4 = $this$flatMap$iv4;
                            Collection destination$iv$iv4 = new ArrayList<E>();
                            boolean $i$f$flatMapTo4 = false;
                            for (T element$iv$iv4 : $this$flatMapTo$iv$iv4) {
                                void $this$flatMapTo$iv$iv5;
                                Map newFormFieldsPattern = (Map)element$iv$iv4;
                                boolean bl4 = false;
                                Iterable $this$flatMap$iv5 = newFormDataPartLists;
                                boolean $i$f$flatMap5 = false;
                                Iterable iterable5 = $this$flatMap$iv5;
                                Collection destination$iv$iv5 = new ArrayList<E>();
                                boolean $i$f$flatMapTo5 = false;
                                for (T element$iv$iv5 : $this$flatMapTo$iv$iv5) {
                                    List list;
                                    List newFormDataPartList = (List)element$iv$iv5;
                                    boolean bl5 = false;
                                    HttpRequestPattern newRequestPattern = new HttpRequestPattern(newHeadersPattern2, newURLMatcher, httpRequestPattern.getMethod(), newBody, newFormFieldsPattern, newFormDataPartList, null, 64, null);
                                    if (httpRequestPattern.getSecuritySchemes().isEmpty()) {
                                        list = CollectionsKt.listOf((Object)newRequestPattern);
                                    } else {
                                        Object v2;
                                        block12: {
                                            Iterable iterable6 = httpRequestPattern.getSecuritySchemes();
                                            for (T t : iterable6) {
                                                OpenAPISecurityScheme it = (OpenAPISecurityScheme)t;
                                                boolean bl6 = false;
                                                if (!it.isInRow(row)) continue;
                                                v2 = t;
                                                break block12;
                                            }
                                            v2 = null;
                                        }
                                        OpenAPISecurityScheme schemeInRow = v2;
                                        if (schemeInRow != null) {
                                            list = CollectionsKt.listOf((Object)schemeInRow.addTo(newRequestPattern, row));
                                        } else {
                                            void $this$mapTo$iv$iv;
                                            Iterable $this$map$iv = httpRequestPattern.getSecuritySchemes();
                                            boolean $i$f$map = false;
                                            Iterable iterable7 = $this$map$iv;
                                            Collection destination$iv$iv6 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                            boolean $i$f$mapTo = false;
                                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                                void it;
                                                OpenAPISecurityScheme openAPISecurityScheme = (OpenAPISecurityScheme)item$iv$iv;
                                                Collection collection = destination$iv$iv6;
                                                boolean bl7 = false;
                                                collection.add(HttpRequestPattern.copy$default(newRequestPattern, null, null, null, null, null, null, CollectionsKt.listOf((Object)it), 63, null));
                                            }
                                            list = (List)destination$iv$iv6;
                                        }
                                    }
                                    Iterable list$iv$iv = list;
                                    CollectionsKt.addAll((Collection)destination$iv$iv5, (Iterable)list$iv$iv);
                                }
                                Iterable list$iv$iv = (List)destination$iv$iv5;
                                CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
                            }
                            Iterable list$iv$iv = (List)destination$iv$iv4;
                            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                        }
                        Iterable list$iv$iv = (List)destination$iv$iv3;
                        CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }, 1, null);
    }

    public static /* synthetic */ List newBasedOn$default(HttpRequestPattern httpRequestPattern, Row row, Resolver resolver, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return httpRequestPattern.newBasedOn(row, resolver, n);
    }

    private final boolean isInvalidRequestResponse(int status) {
        return HttpRequestPatternKt.access$getInvalidRequestStatuses$p().contains(status);
    }

    @NotNull
    public final List<HttpRequestPattern> newBasedOn(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return (List)ContractExceptionKt.attempt$default(null, "REQUEST", (Function0)new Function0<List<? extends HttpRequestPattern>>(this, resolver){
            final /* synthetic */ HttpRequestPattern this$0;
            final /* synthetic */ Resolver $resolver;
            {
                this.this$0 = $receiver;
                this.$resolver = $resolver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<HttpRequestPattern> invoke() {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Object object = this.this$0.getUrlMatcher();
                if (object == null || (object = ((URLMatcher)object).newBasedOn(this.$resolver)) == null) {
                    object = CollectionsKt.listOf(null);
                }
                List<URLMatcher> newURLMatchers = object;
                List newBodies2 = (List)ContractExceptionKt.attempt$default(null, "BODY", (Function0)new Function0<List<? extends Pattern>>(this.$resolver, this.this$0){
                    final /* synthetic */ Resolver $resolver;
                    final /* synthetic */ HttpRequestPattern this$0;
                    {
                        this.$resolver = $resolver;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final List<Pattern> invoke() {
                        return (List)this.$resolver.withCyclePrevention(this.this$0.getBody(), (Function1)new Function1<Resolver, List<? extends Pattern>>(this.this$0){
                            final /* synthetic */ HttpRequestPattern this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            @NotNull
                            public final List<Pattern> invoke(@NotNull Resolver cyclePreventedResolver) {
                                Intrinsics.checkNotNullParameter((Object)cyclePreventedResolver, (String)"cyclePreventedResolver");
                                return this.this$0.getBody().newBasedOn(cyclePreventedResolver);
                            }
                        });
                    }
                }, 1, null);
                List<HttpHeadersPattern> newHeadersPattern = this.this$0.getHeadersPattern().newBasedOn(this.$resolver);
                List<Map<String, Pattern>> newFormFieldsPatterns = TabularPatternKt.newBasedOn(this.this$0.getFormFieldsPattern(), this.$resolver);
                List<List<MultiPartFormDataPattern>> newFormDataPartLists = HttpRequestPatternKt.newMultiPartBasedOn(this.this$0.getMultiPartFormDataPattern(), new Row(null, null, null, null, null, 31, null), this.$resolver);
                Iterable iterable = newURLMatchers;
                HttpRequestPattern httpRequestPattern = this.this$0;
                boolean $i$f$flatMap = false;
                void var9_9 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    void $this$flatMapTo$iv$iv2;
                    URLMatcher newURLMatcher = (URLMatcher)element$iv$iv;
                    boolean bl = false;
                    Iterable $this$flatMap$iv2 = newBodies2;
                    boolean $i$f$flatMap2 = false;
                    Iterable iterable2 = $this$flatMap$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>();
                    boolean $i$f$flatMapTo2 = false;
                    for (T element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                        void $this$flatMapTo$iv$iv3;
                        Pattern newBody = (Pattern)element$iv$iv2;
                        boolean bl2 = false;
                        Iterable $this$flatMap$iv3 = newHeadersPattern;
                        boolean $i$f$flatMap3 = false;
                        Iterable iterable3 = $this$flatMap$iv3;
                        Collection destination$iv$iv3 = new ArrayList<E>();
                        boolean $i$f$flatMapTo3 = false;
                        for (T element$iv$iv3 : $this$flatMapTo$iv$iv3) {
                            void $this$flatMapTo$iv$iv4;
                            HttpHeadersPattern newHeadersPattern2 = (HttpHeadersPattern)element$iv$iv3;
                            boolean bl3 = false;
                            Iterable $this$flatMap$iv4 = newFormFieldsPatterns;
                            boolean $i$f$flatMap4 = false;
                            Iterable iterable4 = $this$flatMap$iv4;
                            Collection destination$iv$iv4 = new ArrayList<E>();
                            boolean $i$f$flatMapTo4 = false;
                            for (T element$iv$iv4 : $this$flatMapTo$iv$iv4) {
                                void $this$flatMapTo$iv$iv5;
                                Map newFormFieldsPattern = (Map)element$iv$iv4;
                                boolean bl4 = false;
                                Iterable $this$flatMap$iv5 = newFormDataPartLists;
                                boolean $i$f$flatMap5 = false;
                                Iterable iterable5 = $this$flatMap$iv5;
                                Collection destination$iv$iv5 = new ArrayList<E>();
                                boolean $i$f$flatMapTo5 = false;
                                for (T element$iv$iv5 : $this$flatMapTo$iv$iv5) {
                                    List list;
                                    List newFormDataPartList = (List)element$iv$iv5;
                                    boolean bl5 = false;
                                    HttpRequestPattern newRequestPattern = new HttpRequestPattern(newHeadersPattern2, newURLMatcher, httpRequestPattern.getMethod(), newBody, newFormFieldsPattern, newFormDataPartList, null, 64, null);
                                    if (Intrinsics.areEqual(httpRequestPattern.getSecuritySchemes(), (Object)CollectionsKt.emptyList())) {
                                        list = CollectionsKt.listOf((Object)newRequestPattern);
                                    } else {
                                        void $this$mapTo$iv$iv;
                                        Iterable $this$map$iv = httpRequestPattern.getSecuritySchemes();
                                        boolean $i$f$map = false;
                                        Iterable iterable6 = $this$map$iv;
                                        Collection destination$iv$iv6 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                        boolean $i$f$mapTo = false;
                                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                                            void it;
                                            OpenAPISecurityScheme openAPISecurityScheme = (OpenAPISecurityScheme)item$iv$iv;
                                            Collection collection = destination$iv$iv6;
                                            boolean bl6 = false;
                                            collection.add(HttpRequestPattern.copy$default(newRequestPattern, null, null, null, null, null, null, CollectionsKt.listOf((Object)it), 63, null));
                                        }
                                        list = (List)destination$iv$iv6;
                                    }
                                    Iterable list$iv$iv = list;
                                    CollectionsKt.addAll((Collection)destination$iv$iv5, (Iterable)list$iv$iv);
                                }
                                Iterable list$iv$iv = (List)destination$iv$iv5;
                                CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
                            }
                            Iterable list$iv$iv = (List)destination$iv$iv4;
                            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                        }
                        Iterable list$iv$iv = (List)destination$iv$iv3;
                        CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }, 1, null);
    }

    @NotNull
    public final String testDescription() {
        return this.method + ' ' + this.urlMatcher;
    }

    @NotNull
    public final List<HttpRequestPattern> negativeBasedOn(@NotNull Row row, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return (List)ContractExceptionKt.attempt$default(null, "REQUEST", (Function0)new Function0<List<? extends HttpRequestPattern>>(this, row, resolver){
            final /* synthetic */ HttpRequestPattern this$0;
            final /* synthetic */ Row $row;
            final /* synthetic */ Resolver $resolver;
            {
                this.this$0 = $receiver;
                this.$row = $row;
                this.$resolver = $resolver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<HttpRequestPattern> invoke() {
                List list;
                List newFormDataPartListPattern;
                Object object = this.this$0.getUrlMatcher();
                if (object == null || (object = ((URLMatcher)object).newBasedOn(this.$row, this.$resolver)) == null) {
                    object = CollectionsKt.listOf(null);
                }
                List<URLMatcher> newURLMatchers = object;
                List newBodies2 = (List)ContractExceptionKt.attempt$default(null, "BODY", (Function0)new Function0<List<? extends Pattern>>(this.this$0, this.$row, this.$resolver){
                    final /* synthetic */ HttpRequestPattern this$0;
                    final /* synthetic */ Row $row;
                    final /* synthetic */ Resolver $resolver;
                    {
                        this.this$0 = $receiver;
                        this.$row = $row;
                        this.$resolver = $resolver;
                        super(0);
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    public final List<Pattern> invoke() {
                        List<Pattern> list;
                        boolean bl;
                        List<Pattern> list2;
                        Pattern pattern2 = this.this$0.getBody();
                        Row row = this.$row;
                        Resolver resolver = this.$resolver;
                        HttpRequestPattern httpRequestPattern = this.this$0;
                        Pattern it = pattern2;
                        boolean bl2 = false;
                        if (it instanceof DeferredPattern && row.containsField(((DeferredPattern)it).getPattern())) {
                            String example = row.getField(((DeferredPattern)it).getPattern());
                            list2 = CollectionsKt.listOf((Object)new ExactValuePattern(it.parse(example, resolver), null, 2, null));
                            return list2;
                        }
                        String string = it.getTypeAlias();
                        if (string != null) {
                            String p = string;
                            boolean bl3 = false;
                            bl = GrammarKt.isPatternToken(p);
                        } else {
                            bl = false;
                        }
                        if (bl) {
                            String string2 = it.getTypeAlias();
                            Intrinsics.checkNotNull((Object)string2);
                            if (row.containsField(string2)) {
                                String string3 = it.getTypeAlias();
                                Intrinsics.checkNotNull((Object)string3);
                                String example = row.getField(string3);
                                list2 = CollectionsKt.listOf((Object)new ExactValuePattern(it.parse(example, resolver), null, 2, null));
                                return list2;
                            }
                        }
                        if (it instanceof XMLPattern) {
                            boolean bl4;
                            String string4 = ((XMLPattern)it).getReferredType();
                            if (string4 != null) {
                                String referredType = string4;
                                boolean bl5 = false;
                                bl4 = row.containsField('(' + referredType + ')');
                            } else {
                                bl4 = false;
                            }
                            if (bl4) {
                                String referredType = '(' + ((XMLPattern)it).getReferredType() + ')';
                                String example = row.getField(referredType);
                                list2 = CollectionsKt.listOf((Object)new ExactValuePattern(it.parse(example, resolver), null, 2, null));
                                return list2;
                            }
                        }
                        if (!row.containsField("(REQUEST-BODY)")) {
                            list2 = httpRequestPattern.getBody().negativeBasedOn(row, resolver);
                            return list2;
                        }
                        String example = row.getField("(REQUEST-BODY)");
                        Value value2 = it.parse(example, resolver);
                        Result result2 = httpRequestPattern.getBody().matches(value2, resolver);
                        if (result2 instanceof Result.Failure) {
                            throw new ContractException(Result.Failure.toFailureReport$default((Result.Failure)result2, null, 1, null));
                        }
                        if (value2 instanceof JSONObjectValue) {
                            Pair entry;
                            Collection collection;
                            Iterable $this$mapTo$iv$iv;
                            List<Pair<String, String>> jsonValues = HttpRequestPatternKt.jsonObjectToValues((JSONObjectValue)value2);
                            Iterable $this$map$iv = jsonValues;
                            boolean $i$f$map = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                Pair pair = (Pair)item$iv$iv;
                                collection = destination$iv$iv;
                                boolean bl6 = false;
                                collection.add((String)entry.getFirst());
                            }
                            $this$map$iv = jsonValues;
                            collection = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                            $i$f$map = false;
                            $this$mapTo$iv$iv = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                entry = (Pair)item$iv$iv;
                                Collection collection2 = destination$iv$iv;
                                boolean bl7 = false;
                                collection2.add((String)entry.getSecond());
                            }
                            DefaultConstructorMarker defaultConstructorMarker = null;
                            int n = 12;
                            String string5 = row.getName();
                            Map map = null;
                            Map map2 = null;
                            List list3 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                            Collection collection3 = collection;
                            Row jsonValueRow = new Row((List)collection3, list3, map2, map, string5, n, defaultConstructorMarker);
                            list = httpRequestPattern.getBody().negativeBasedOn(jsonValueRow, resolver);
                        } else {
                            list = CollectionsKt.listOf((Object)new ExactValuePattern(value2, null, 2, null));
                        }
                        List<Pattern> originalRequest = list;
                        List flattenedRequests2 = (List)resolver.withCyclePrevention(httpRequestPattern.getBody(), (Function1)new Function1<Resolver, List<? extends Pattern>>(httpRequestPattern, row){
                            final /* synthetic */ HttpRequestPattern this$0;
                            final /* synthetic */ Row $row;
                            {
                                this.this$0 = $receiver;
                                this.$row = $row;
                                super(1);
                            }

                            @NotNull
                            public final List<Pattern> invoke(@NotNull Resolver cyclePreventedResolver) {
                                Intrinsics.checkNotNullParameter((Object)cyclePreventedResolver, (String)"cyclePreventedResolver");
                                return this.this$0.getBody().newBasedOn(this.$row.flattenRequestBodyIntoRow(), cyclePreventedResolver);
                            }
                        });
                        CollectionsKt.plus((Collection)flattenedRequests2, (Iterable)originalRequest);
                        list2 = httpRequestPattern.getBody().negativeBasedOn(row.flattenRequestBodyIntoRow(), resolver);
                        return list2;
                    }
                }, 1, null);
                List<HttpHeadersPattern> newHeadersPattern = this.this$0.getHeadersPattern().negativeBasedOn(this.$row, this.$resolver);
                List<Map<String, Pattern>> newFormFieldsPatterns = TabularPatternKt.newBasedOn(this.this$0.getFormFieldsPattern(), this.$row, this.$resolver);
                List<List<MultiPartFormDataPattern>> newFormDataPartLists = HttpRequestPatternKt.newMultiPartBasedOn(this.this$0.getMultiPartFormDataPattern(), this.$row, this.$resolver);
                HttpRequestPattern positivePattern = (HttpRequestPattern)CollectionsKt.first((List)HttpRequestPattern.newBasedOn$default(this.this$0, this.$row, this.$resolver, 0, 4, null));
                List negativeRequestPatterns = new ArrayList<E>();
                Iterable $this$forEach$iv = newURLMatchers;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    URLMatcher newUrlMatcher = (URLMatcher)element$iv;
                    boolean bl = false;
                    negativeRequestPatterns.add(HttpRequestPattern.copy$default(positivePattern, null, newUrlMatcher, null, null, null, null, null, 125, null));
                }
                $this$forEach$iv = newBodies2;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Pattern newbodyPattern = (Pattern)element$iv;
                    boolean bl = false;
                    negativeRequestPatterns.add(HttpRequestPattern.copy$default(positivePattern, null, null, null, newbodyPattern, null, null, null, 119, null));
                }
                $this$forEach$iv = newHeadersPattern;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    HttpHeadersPattern newHeaderPattern = (HttpHeadersPattern)element$iv;
                    boolean bl = false;
                    negativeRequestPatterns.add(HttpRequestPattern.copy$default(positivePattern, newHeaderPattern, null, null, null, null, null, null, 126, null));
                }
                $this$forEach$iv = newFormFieldsPatterns;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Map newFormFieldPattern = (Map)element$iv;
                    boolean bl = false;
                    negativeRequestPatterns.add(HttpRequestPattern.copy$default(positivePattern, null, null, null, null, newFormFieldPattern, null, null, 111, null));
                }
                $this$forEach$iv = newFormDataPartLists;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    newFormDataPartListPattern = (List)element$iv;
                    boolean bl = false;
                    negativeRequestPatterns.add(HttpRequestPattern.copy$default(positivePattern, null, null, null, null, null, newFormDataPartListPattern, null, 95, null));
                }
                boolean bl = this.this$0.getSecuritySchemes().isEmpty();
                if (bl) {
                    list = negativeRequestPatterns;
                } else if (!bl) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable $i$f$forEach2 = negativeRequestPatterns;
                    HttpRequestPattern httpRequestPattern = this.this$0;
                    boolean $i$f$map = false;
                    newFormDataPartListPattern = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        HttpRequestPattern httpRequestPattern2 = (HttpRequestPattern)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(HttpRequestPattern.copy$default((HttpRequestPattern)it, null, null, null, null, null, null, CollectionsKt.listOf((Object)CollectionsKt.first(httpRequestPattern.getSecuritySchemes())), 63, null));
                    }
                    list = (List)destination$iv$iv;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return list;
            }
        }, 1, null);
    }

    @NotNull
    public final HttpHeadersPattern component1() {
        return this.headersPattern;
    }

    @Nullable
    public final URLMatcher component2() {
        return this.urlMatcher;
    }

    @Nullable
    public final String component3() {
        return this.method;
    }

    @NotNull
    public final Pattern component4() {
        return this.body;
    }

    @NotNull
    public final Map<String, Pattern> component5() {
        return this.formFieldsPattern;
    }

    @NotNull
    public final List<MultiPartFormDataPattern> component6() {
        return this.multiPartFormDataPattern;
    }

    @NotNull
    public final List<OpenAPISecurityScheme> component7() {
        return this.securitySchemes;
    }

    @NotNull
    public final HttpRequestPattern copy(@NotNull HttpHeadersPattern headersPattern, @Nullable URLMatcher urlMatcher, @Nullable String method, @NotNull Pattern body, @NotNull Map<String, ? extends Pattern> formFieldsPattern, @NotNull List<? extends MultiPartFormDataPattern> multiPartFormDataPattern, @NotNull List<? extends OpenAPISecurityScheme> securitySchemes) {
        Intrinsics.checkNotNullParameter((Object)headersPattern, (String)"headersPattern");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter(formFieldsPattern, (String)"formFieldsPattern");
        Intrinsics.checkNotNullParameter(multiPartFormDataPattern, (String)"multiPartFormDataPattern");
        Intrinsics.checkNotNullParameter(securitySchemes, (String)"securitySchemes");
        return new HttpRequestPattern(headersPattern, urlMatcher, method, body, formFieldsPattern, multiPartFormDataPattern, securitySchemes);
    }

    public static /* synthetic */ HttpRequestPattern copy$default(HttpRequestPattern httpRequestPattern, HttpHeadersPattern httpHeadersPattern, URLMatcher uRLMatcher, String string, Pattern pattern2, Map map, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            httpHeadersPattern = httpRequestPattern.headersPattern;
        }
        if ((n & 2) != 0) {
            uRLMatcher = httpRequestPattern.urlMatcher;
        }
        if ((n & 4) != 0) {
            string = httpRequestPattern.method;
        }
        if ((n & 8) != 0) {
            pattern2 = httpRequestPattern.body;
        }
        if ((n & 0x10) != 0) {
            map = httpRequestPattern.formFieldsPattern;
        }
        if ((n & 0x20) != 0) {
            list = httpRequestPattern.multiPartFormDataPattern;
        }
        if ((n & 0x40) != 0) {
            list2 = httpRequestPattern.securitySchemes;
        }
        return httpRequestPattern.copy(httpHeadersPattern, uRLMatcher, string, pattern2, map, list, list2);
    }

    @NotNull
    public String toString() {
        return "HttpRequestPattern(headersPattern=" + this.headersPattern + ", urlMatcher=" + this.urlMatcher + ", method=" + this.method + ", body=" + this.body + ", formFieldsPattern=" + this.formFieldsPattern + ", multiPartFormDataPattern=" + this.multiPartFormDataPattern + ", securitySchemes=" + this.securitySchemes + ')';
    }

    public int hashCode() {
        int result2 = this.headersPattern.hashCode();
        result2 = result2 * 31 + (this.urlMatcher == null ? 0 : this.urlMatcher.hashCode());
        result2 = result2 * 31 + (this.method == null ? 0 : this.method.hashCode());
        result2 = result2 * 31 + this.body.hashCode();
        result2 = result2 * 31 + ((Object)this.formFieldsPattern).hashCode();
        result2 = result2 * 31 + ((Object)this.multiPartFormDataPattern).hashCode();
        result2 = result2 * 31 + ((Object)this.securitySchemes).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpRequestPattern)) {
            return false;
        }
        HttpRequestPattern httpRequestPattern = (HttpRequestPattern)other;
        if (!Intrinsics.areEqual((Object)this.headersPattern, (Object)httpRequestPattern.headersPattern)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.urlMatcher, (Object)httpRequestPattern.urlMatcher)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.method, (Object)httpRequestPattern.method)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.body, (Object)httpRequestPattern.body)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.formFieldsPattern, httpRequestPattern.formFieldsPattern)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.multiPartFormDataPattern, httpRequestPattern.multiPartFormDataPattern)) {
            return false;
        }
        return Intrinsics.areEqual(this.securitySchemes, httpRequestPattern.securitySchemes);
    }

    public HttpRequestPattern() {
        this(null, null, null, null, null, null, null, 127, null);
    }

    public static final /* synthetic */ MatchingResult access$matchPath(HttpRequestPattern $this, Pair parameters) {
        return $this.matchPath((Pair<HttpRequest, Resolver>)parameters);
    }

    public static final /* synthetic */ MatchingResult access$matchMethod(HttpRequestPattern $this, Pair parameters) {
        return $this.matchMethod((Pair<HttpRequest, Resolver>)parameters);
    }

    public static final /* synthetic */ MatchingResult access$matchSecurityScheme(HttpRequestPattern $this, Triple parameters) {
        return $this.matchSecurityScheme((Triple<HttpRequest, Resolver, ? extends List<Result.Failure>>)parameters);
    }

    public static final /* synthetic */ MatchingResult access$matchQuery(HttpRequestPattern $this, Triple parameters) {
        return $this.matchQuery((Triple<HttpRequest, Resolver, ? extends List<Result.Failure>>)parameters);
    }

    public static final /* synthetic */ MatchingResult access$matchHeaders(HttpRequestPattern $this, HeaderMatchParams parameters) {
        return $this.matchHeaders(parameters);
    }

    public static final /* synthetic */ MatchingResult access$matchMultiPartFormData(HttpRequestPattern $this, Triple parameters) {
        return $this.matchMultiPartFormData((Triple<HttpRequest, Resolver, ? extends List<Result.Failure>>)parameters);
    }

    public static final /* synthetic */ MatchingResult access$matchBody(HttpRequestPattern $this, Triple parameters) {
        return $this.matchBody((Triple<HttpRequest, Resolver, ? extends List<Result.Failure>>)parameters);
    }

    public static final /* synthetic */ Map access$toTypeMap(HttpRequestPattern $this, Map values2, Map types, Resolver resolver) {
        return $this.toTypeMap(values2, types, resolver);
    }

    public static final /* synthetic */ Map access$toLowerCaseKeys(HttpRequestPattern $this, Map map) {
        return $this.toLowerCaseKeys(map);
    }

    public static final /* synthetic */ Pattern access$encompassedType(HttpRequestPattern $this, String valueString, String key2, Pattern type, Resolver resolver) {
        return $this.encompassedType(valueString, key2, type, resolver);
    }

    public static final /* synthetic */ boolean access$isInvalidRequestResponse(HttpRequestPattern $this, int status) {
        return $this.isInvalidRequestResponse(status);
    }
}

