/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.utilities;

import in.specmatic.core.git.GitCommand;
import in.specmatic.core.git.GitOperations;
import in.specmatic.core.git.SystemGit;
import in.specmatic.core.log.LoggingKt;
import in.specmatic.core.utilities.ContractPathData;
import in.specmatic.core.utilities.ContractSource;
import in.specmatic.core.utilities.ContractSourceKt;
import in.specmatic.core.utilities.ContractsSelectorPredicate;
import in.specmatic.core.utilities.Utilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0000H\u0002J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J?\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0001J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\t\u0010$\u001a\u00020%H\u00d6\u0001J\u0010\u0010&\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u0012H\u0002J\u0010\u0010)\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u0012H\u0002J&\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u00062\u0006\u0010,\u001a\u00020-2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u0003H\u0016J\u0010\u0010/\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u0010\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0003H\u0016J\u0010\u00102\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\t\u00103\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u00064"}, d2={"Lin/specmatic/core/utilities/GitRepo;", "Lin/specmatic/core/utilities/ContractSource;", "gitRepositoryURL", "", "branchName", "testContracts", "", "stubContracts", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getBranchName", "()Ljava/lang/String;", "getGitRepositoryURL", "repoName", "getRepoName", "getStubContracts", "()Ljava/util/List;", "getTestContracts", "cloneRepo", "Ljava/io/File;", "reposBaseDir", "gitRepo", "component1", "component2", "component3", "component4", "copy", "directoryRelativeTo", "workingDirectory", "equals", "", "other", "", "getLatest", "", "sourceGit", "Lin/specmatic/core/git/SystemGit;", "hashCode", "", "install", "isBehind", "contractsRepoDir", "isClean", "loadContracts", "Lin/specmatic/core/utilities/ContractPathData;", "selector", "Lin/specmatic/core/utilities/ContractsSelectorPredicate;", "configFilePath", "localRepoDir", "pathDescriptor", "path", "pushUpdates", "toString", "core"})
public final class GitRepo
extends ContractSource {
    @NotNull
    private final String gitRepositoryURL;
    @Nullable
    private final String branchName;
    @NotNull
    private final List<String> testContracts;
    @NotNull
    private final List<String> stubContracts;
    @NotNull
    private final String repoName;

    public GitRepo(@NotNull String gitRepositoryURL, @Nullable String branchName, @NotNull List<String> testContracts, @NotNull List<String> stubContracts) {
        Intrinsics.checkNotNullParameter((Object)gitRepositoryURL, (String)"gitRepositoryURL");
        Intrinsics.checkNotNullParameter(testContracts, (String)"testContracts");
        Intrinsics.checkNotNullParameter(stubContracts, (String)"stubContracts");
        super(null);
        this.gitRepositoryURL = gitRepositoryURL;
        this.branchName = branchName;
        this.testContracts = testContracts;
        this.stubContracts = stubContracts;
        String[] stringArray = new String[]{"/"};
        this.repoName = StringsKt.removeSuffix((String)((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)this.gitRepositoryURL, (String[])stringArray, (boolean)false, (int)0, (int)6, null))), (CharSequence)".git");
    }

    @NotNull
    public final String getGitRepositoryURL() {
        return this.gitRepositoryURL;
    }

    @Nullable
    public final String getBranchName() {
        return this.branchName;
    }

    @Override
    @NotNull
    public List<String> getTestContracts() {
        return this.testContracts;
    }

    @Override
    @NotNull
    public List<String> getStubContracts() {
        return this.stubContracts;
    }

    @NotNull
    public final String getRepoName() {
        return this.repoName;
    }

    @Override
    @NotNull
    public String pathDescriptor(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return this.repoName + ':' + path2;
    }

    @Override
    @NotNull
    public File directoryRelativeTo(@NotNull File workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        return FilesKt.resolve((File)workingDirectory, (String)this.repoName);
    }

    @Override
    public void getLatest(@NotNull SystemGit sourceGit) {
        Intrinsics.checkNotNullParameter((Object)sourceGit, (String)"sourceGit");
        sourceGit.pull();
    }

    @Override
    public void pushUpdates(@NotNull SystemGit sourceGit) {
        Intrinsics.checkNotNullParameter((Object)sourceGit, (String)"sourceGit");
        ContractSourceKt.commitAndPush(sourceGit);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ContractPathData> loadContracts(@NotNull ContractsSelectorPredicate selector, @NotNull String workingDirectory, @NotNull String configFilePath) {
        void $this$mapTo$iv$iv;
        File file;
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)configFilePath, (String)"configFilePath");
        File userHome = new File(System.getProperty("user.home"));
        File defaultQontractWorkingDir = FilesKt.resolve((File)userHome, (String)".specmatic/repos");
        File defaultRepoDir = this.directoryRelativeTo(defaultQontractWorkingDir);
        File bundleDir = FilesKt.resolve((File)new File(".specmatic_test_bundle"), (String)this.repoName);
        if (bundleDir.exists()) {
            LoggingKt.getLogger().log("Using contracts from " + bundleDir.getPath());
            file = bundleDir;
        } else if (defaultRepoDir.exists()) {
            LoggingKt.getLogger().log("Using contracts in home dir");
            file = defaultRepoDir;
        } else {
            File reposBaseDir = this.localRepoDir(workingDirectory);
            File contractsRepoDir = this.directoryRelativeTo(reposBaseDir);
            if (!contractsRepoDir.exists()) {
                file = this.cloneRepo(reposBaseDir, this);
            } else if (contractsRepoDir.exists() && this.isBehind(contractsRepoDir)) {
                file = this.cloneRepo(reposBaseDir, this);
            } else if (contractsRepoDir.exists() && this.isClean(contractsRepoDir)) {
                LoggingKt.getLogger().log("Couldn't find local contracts but " + contractsRepoDir.getPath() + " already exists and is clean and has contracts");
                file = contractsRepoDir;
            } else {
                LoggingKt.getLogger().log("Couldn't find local contracts. Although " + contractsRepoDir.getPath() + " exists, it is not clean.\nHence cloning " + this.gitRepositoryURL + " into " + reposBaseDir.getPath());
                file = GitOperations.clone(reposBaseDir, this);
            }
        }
        File repoDir = file;
        Iterable $this$map$iv = selector.select(this);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = repoDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"repoDir.path");
            String string3 = FilesKt.resolve((File)repoDir, (String)it).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"repoDir.resolve(it).path");
            collection.add(new ContractPathData(string2, string3));
        }
        return (List)destination$iv$iv;
    }

    private final boolean isClean(File contractsRepoDir) {
        String string = contractsRepoDir.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contractsRepoDir.path");
        GitCommand sourceGit = Utilities.getSystemGit(string);
        return ((CharSequence)sourceGit.statusPorcelain()).length() == 0;
    }

    private final boolean isBehind(File contractsRepoDir) {
        String string = contractsRepoDir.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contractsRepoDir.path");
        GitCommand sourceGit = Utilities.getSystemGit(string);
        sourceGit.fetch();
        return sourceGit.revisionsBehindCount() > 0;
    }

    private final File cloneRepo(File reposBaseDir, GitRepo gitRepo) {
        LoggingKt.getLogger().log("Couldn't find local contracts, cloning " + this.gitRepositoryURL + " into " + reposBaseDir.getPath());
        reposBaseDir.mkdirs();
        File repositoryDirectory = GitOperations.clone(reposBaseDir, gitRepo);
        if (this.branchName == null) {
            LoggingKt.getLogger().log("No branch specified, using default branch");
        } else {
            GitOperations.checkout(repositoryDirectory, this.branchName);
        }
        return repositoryDirectory;
    }

    private final File localRepoDir(String workingDirectory) {
        return FilesKt.resolve((File)new File(workingDirectory), (String)"repos");
    }

    @Override
    public void install(@NotNull File workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        File sourceDir = FilesKt.resolve((File)workingDirectory, (String)this.repoName);
        String string = sourceDir.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourceDir.path");
        SystemGit sourceGit = new SystemGit(string, null, null, 6, null);
        try {
            System.out.println((Object)("Checking " + sourceDir.getPath()));
            if (!sourceDir.exists()) {
                sourceDir.mkdirs();
            }
            if (!sourceGit.workingDirectoryIsGitRepo()) {
                System.out.println((Object)"Found it, not a git dir, recreating...");
                FilesKt.deleteRecursively((File)sourceDir);
                sourceDir.mkdirs();
                System.out.println((Object)("Cloning " + this.gitRepositoryURL + " into " + sourceDir.getAbsolutePath()));
                File file = sourceDir.getAbsoluteFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"sourceDir.absoluteFile");
                sourceGit.clone(this.gitRepositoryURL, file);
            } else {
                System.out.println((Object)("Git repo already exists at " + sourceDir.getPath() + ", so ignoring it and moving on"));
            }
        }
        catch (Throwable e) {
            System.out.println((Object)("Could not clone " + this.gitRepositoryURL + '\n' + e.getClass().getName() + ": " + Utilities.exceptionCauseMessage(e)));
        }
    }

    @NotNull
    public final String component1() {
        return this.gitRepositoryURL;
    }

    @Nullable
    public final String component2() {
        return this.branchName;
    }

    @NotNull
    public final List<String> component3() {
        return this.getTestContracts();
    }

    @NotNull
    public final List<String> component4() {
        return this.getStubContracts();
    }

    @NotNull
    public final GitRepo copy(@NotNull String gitRepositoryURL, @Nullable String branchName, @NotNull List<String> testContracts, @NotNull List<String> stubContracts) {
        Intrinsics.checkNotNullParameter((Object)gitRepositoryURL, (String)"gitRepositoryURL");
        Intrinsics.checkNotNullParameter(testContracts, (String)"testContracts");
        Intrinsics.checkNotNullParameter(stubContracts, (String)"stubContracts");
        return new GitRepo(gitRepositoryURL, branchName, testContracts, stubContracts);
    }

    public static /* synthetic */ GitRepo copy$default(GitRepo gitRepo, String string, String string2, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            string = gitRepo.gitRepositoryURL;
        }
        if ((n & 2) != 0) {
            string2 = gitRepo.branchName;
        }
        if ((n & 4) != 0) {
            list = gitRepo.getTestContracts();
        }
        if ((n & 8) != 0) {
            list2 = gitRepo.getStubContracts();
        }
        return gitRepo.copy(string, string2, list, list2);
    }

    @NotNull
    public String toString() {
        return "GitRepo(gitRepositoryURL=" + this.gitRepositoryURL + ", branchName=" + this.branchName + ", testContracts=" + this.getTestContracts() + ", stubContracts=" + this.getStubContracts() + ')';
    }

    public int hashCode() {
        int result2 = this.gitRepositoryURL.hashCode();
        result2 = result2 * 31 + (this.branchName == null ? 0 : this.branchName.hashCode());
        result2 = result2 * 31 + ((Object)this.getTestContracts()).hashCode();
        result2 = result2 * 31 + ((Object)this.getStubContracts()).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GitRepo)) {
            return false;
        }
        GitRepo gitRepo = (GitRepo)other;
        if (!Intrinsics.areEqual((Object)this.gitRepositoryURL, (Object)gitRepo.gitRepositoryURL)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.branchName, (Object)gitRepo.branchName)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getTestContracts(), gitRepo.getTestContracts())) {
            return false;
        }
        return Intrinsics.areEqual(this.getStubContracts(), gitRepo.getStubContracts());
    }
}

